/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.ibatis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.collections.map.TypedMap;

import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;

/**
 * IBatisUtils
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id$
 */
public class IBatisUtils {

	/**
	 * Get SqlMapExecutorDelegate object
	 * 
	 * @param sqlMapClientImpl SqlMapClientImpl object
	 * @return SqlMapExecutorDelegate object
	 */
	static public SqlMapExecutorDelegate getSqlMapExecutorDelegate(
			SqlMapClientImpl sqlMapClientImpl) {
		return sqlMapClientImpl.getDelegate();
	}
	
	
	/**
	 * Get MappedStatemnet map
	 * 
	 * @param sqlMapClientImpl SqlMapClientImpl object
	 * @return Map<String name, MappedStatement object>
	 */
	static public Map getMappedStatements(SqlMapClientImpl sqlMapClientImpl) {
		Map mappedStatements = null;
		
		mappedStatements = TypedMap.decorate(
				new HashMap(), String.class, MappedStatement.class);
		for (Iterator ite = sqlMapClientImpl.getDelegate().getMappedStatementNames();
			ite.hasNext();) {
			String mappedStatementName = (String)ite.next();
			mappedStatements.put(
					mappedStatementName,
					sqlMapClientImpl.getMappedStatement(mappedStatementName));
		}
		
		return mappedStatements;
	}

	
	/**
	 * Get MappedStatement object
	 * 
	 * @param id Statement ID
	 * @param sqlMapClientImpl SqlMapClientImpl object
	 * @return MappedStatement object
	 */
	static public MappedStatement getMappedStatement(
			String id, SqlMapClientImpl sqlMapClientImpl) {
		
		return sqlMapClientImpl.getMappedStatement(id);
	}

}
