/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.example.metasearch.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.webframe.example.metasearch.form.SearchActionForm;
import jp.sourceforge.webframe.compass.DistributedIndexSearcher;
import jp.sourceforge.webframe.compass.SearchFailedException;
import jp.sourceforge.webframe.compass.SearchResult;
import jp.sourceforge.webframe.compass.util.ResultListDefaultComparator;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.web.struts.ActionSupport;

/**
 * DistributedSearchAction
 *
 * @author Yomei Komiya
 *
 * $Id$
 */
public class DistributedSearchAction extends ActionSupport {

	public ActionForward execute(
			ActionMapping mapping,
			ActionForm actionForm,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		SearchActionForm form = (SearchActionForm)actionForm;
		String query = form.getQuery();
		int num = form.getNum();

		SearchResult result = null;
		SearchResult[] results = null;
		try {
			DistributedIndexSearcher searcher
				= (DistributedIndexSearcher)this.getWebApplicationContext()
					.getBean("distributedIndexSearcher");

			results = searcher.find(query, num, 0);
			
			result = this.mergeResults(results, query, num);
		}
		catch (SearchFailedException sfe) {
			sfe.printStackTrace();
			request.setAttribute("errorMessage", sfe.getMessage());

			result = new SearchResult();
			result.setQuery(query);
			result.setNum(num);
			result.setStart(0);
			
			return mapping.findForward("failure");
		}
		finally {
			request.setAttribute("results", results);
			request.setAttribute("result", result);
		}
		
		return mapping.findForward("distributedSearchResult");
	}
	
	
	/**
	 * Merge Search Results
	 * 
	 * @param results
	 * @param query Query String
	 * @param num Number of Display Item
	 * @return SearchResult object
	 */
	protected SearchResult mergeResults(
			SearchResult[] results,
			String query,
			int num) {

		int totalNum = 0;
		long searchTime = 0;
		
		SearchResult result = new SearchResult();
		List allList = new ArrayList();
		
		for (int i = 0; i < results.length; i++) {
			if (results[i] != null) {
				result.setCurrentQuery(results[i].getCurrentQuery());
				totalNum += results[i].getTotalNum();
				searchTime += results[i].getSearchTime();
				allList.addAll(results[i].getList());
			}
		}
		
		result.setQuery(query);
		result.setNum(num);
		result.setStart(0);
		result.setTotalNum(totalNum);
		result.setSearchTime(searchTime);
		// sort in descending order of score
		Collections.sort(allList, new ResultListDefaultComparator());
		Collections.reverse(allList);
		if (allList.size() > num) {
			allList = allList.subList(0, num);
		}
		result.setList(allList);
		
		return result;
	}

}
