/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.gps.fs;

import java.io.File;

import jp.sourceforge.webframe.compass.entity.TextFileSearchable;

import org.compass.core.CompassSession;
import org.compass.gps.CompassGpsException;

/**
 * TextFileGpsDevice
 *
 * @author Yomei Komiya
 * @since 0.9.1
 *
 * @deprecated Use jp.sourceforge.metasearch.compass.gps.device.fs.TextFileGpsDevice
 *		of <a href="http://metasearch.sourceforge.jp/">MetaSearch project</a>
 * @version $Id$
 */
public class TextFileGpsDevice extends AbstractFileGpsDevice {

	/**
	 * File encoding name
	 */
	private String fileEncoding = "UTF8";
	
	/**
	 * Max file size
	 */
	private int maxFileSize = 1024;
	
	/**
	 * Text file searchable class name
	 */
	private String textFileSearchableClass;
	

	protected void doStart() throws CompassGpsException {
		super.doStart();

		if (fileEncoding == null || fileEncoding.equals("")) {
			throw new IllegalArgumentException(buildMessage(
					"Must set fileEncoding property"));
		}
	}
	
	
	protected void doIndex(CompassSession session)
		throws CompassGpsException {
	
		if (log.isInfoEnabled()) {
			log.info(buildMessage(
					"Indexing the files in [" + this.getDirectory() + "]"));
		}
	
		try {
			File[] files = this.getFiles();
			
			Class clazz = Class.forName(this.getTextFileSearchableClass());
			TextFileSearchable fileEntity
				= (TextFileSearchable)clazz.newInstance();

			for (int i = 0; i < files.length; i++) {
				File file = files[i];
				if (file.isFile()) {
					fileEntity.loadFile(
							file, this.fileEncoding, this.maxFileSize);

					session.create(fileEntity);
				}
			}
		}
		catch (Exception e) {
			throw new FileGpsDeviceException(
					"Failed to index the files in ["
					+ this.getDirectory() + "]", e);
		}

		if (log.isInfoEnabled()) {
			log.info(buildMessage("Finished indexing the files"));
		}
	}


	public String getFileEncoding() {
		return fileEncoding;
	}


	public void setFileEncoding(String fileEncoding) {
		this.fileEncoding = fileEncoding;
	}


	public int getMaxFileSize() {
		return maxFileSize;
	}


	public void setMaxFileSize(int maxFileSize) {
		this.maxFileSize = maxFileSize;
	}


	public String getTextFileSearchableClass() {
		return textFileSearchableClass;
	}


	public void setTextFileSearchableClass(String textFileSearchableClass) {
		this.textFileSearchableClass = textFileSearchableClass;
	}
	
}
