/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;

/**
 * GenericTextFileEntity
 *
 * @author Yomei Komiya
 * @since 0.9.1
 *
 * @deprecated Use jp.sourceforge.metasearch.compass.entity.GenericTextFileEntity
 *		of <a href="http://metasearch.sourceforge.jp/">MetaSearch project</a>
 * @version $Id$
 */
abstract public class GenericTextFileEntity extends SearchableGenericEntity 
		implements TextFileSearchable {
	
	/**
	 * Default constructor
	 */
	public GenericTextFileEntity() {
		super();
	}

	
	/**
	 * Constructor
	 * 
	 * @param file File object
	 * @param encoding File encoding character set name
	 */
	public GenericTextFileEntity(File file, String encoding) {
		super();
	}

	
	/*
	 * @see jp.sourceforge.webframe.compass.entity.TextFileSearchable#loadFile(java.io.File, java.lang.String, int)
	 */
	public void loadFile(File file, String encoding, int maxSize) {
		this.setLocalIdentifier(file.getAbsolutePath());
		this.setDate(new Date(file.lastModified()));
		this.setTitle(file.getName());
		long fileLength = file.length();
		this.setSize(fileLength);
		
		BufferedReader reader = null;
		try {
			reader =
				new BufferedReader(
					new InputStreamReader(
						new FileInputStream(file), encoding));
			if (fileLength <= maxSize) {
				StringBuffer buf = new StringBuffer();
				String line = null;
				while((line = reader.readLine()) != null) {
					buf.append(line + "\n");
				}
				
				this.setContent(buf.toString());
			}
			else {
				char[] cbuf = new char[maxSize];
				reader.read(cbuf, 0, maxSize);
				
				this.setContent(new String(cbuf));
			}
		}
		catch (Exception e) {
			this.setContent("");
			e.printStackTrace();
		}
		finally {
			if (reader != null) {
				try {
					reader.close();
				}
				catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

}
