/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original creator or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.ws.search;

import java.util.Date;

import jp.sourceforge.webframe.compass.entity.Searchable;

/**
 * Hit
 *
 * @creator Yomei Komiya
 *
 * $Id$
 */
public class Hit {
	
	/**
	 * Document Global Identifier (e.g. URI, ISBN ...)
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String identifier = null;

	/**
	 * Document Title
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String title;
	
	/**
	 * Creator
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String creator;
	
	/**
	 * Date
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private Date date;
	
	/**
	 * Document Type
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String type = null;
	
	/**
	 * Document Copyrights
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String rights = null;
	
	/**
	 * Search Provider
	 */
	private String provider = null;
	
	/**
	 * Search Provider URL
	 */
	private String providerUrl = null;

	/**
	 * Content Size
	 */
	private long size = 0;

	/**
	 * Search Score
	 */
	private float score = 0;
	
	/**
	 * Matched Text Fragment
	 */
	private String fragment = null;
	

	/**
	 * Default Constructor
	 */
	public Hit() {
		super();
	}


	/**
	 * Constructor
	 * 
	 * @param searchable
	 */
	public Hit(Searchable searchable) {
		super();

		this.identifier = searchable.getIdentifier();
		this.title = searchable.getTitle();
		this.creator = searchable.getCreator();
		this.date = searchable.getDate();
		this.type = searchable.getType();
		this.rights = searchable.getRights();
		
		this.provider = searchable.getProvider();
		this.providerUrl = searchable.getProviderUrl();
		this.size = searchable.getSize();
		this.score = searchable.getScore();
		this.fragment = searchable.getFragment();
	}

	
	public final String getIdentifier() {
		return identifier;
	}


	public final void setIdentifier(String identifier) {
		this.identifier = identifier;
	}


	public String getTitle() {
		return this.title;
	}

	
	public void setTitle(String title) {
		this.title = title;
	}

	
	public String getCreator() {
		return this.creator;
	}

	
	public void setCreator(String creator) {
		this.creator = creator;
	}

	
	public Date getDate() {
		return this.date;
	}

	
	public void setDate(Date date) {
		this.date = date;
	}


	public final String getType() {
		return type;
	}


	public final void setType(String type) {
		this.type = type;
	}


	public final String getRights() {
		return rights;
	}


	public final void setRights(String rights) {
		this.rights = rights;
	}


	public final String getProvider() {
		return provider;
	}


	public final void setProvider(String provider) {
		this.provider = provider;
	}


	public final String getProviderUrl() {
		return providerUrl;
	}


	public final void setProviderUrl(String providerUrl) {
		this.providerUrl = providerUrl;
	}


	public final long getSize() {
		return size;
	}


	public final void setSize(long size) {
		this.size = size;
	}


	public final float getScore() {
		return score;
	}


	public final void setScore(float score) {
		this.score = score;
	}


	public final String getFragment() {
		return fragment;
	}


	public final void setFragment(String fragment) {
		this.fragment = fragment;
	}
	
}
