/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import java.io.File;

/**
 * TextFileSearchable
 *
 * @author Yomei Komiya
 * @since 0.9.1
 *
 * @version $Id$
 */
public interface TextFileSearchable {
	
	/**
	 * Load file object
	 * 
	 * @param file File object
	 * @param encoding File encoding character set name
	 * @param maxSize Max size of loading file content
	 */
	public abstract void loadFile(
			File file,
			String encoding,
			int maxSize);

}
