/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.gps;

import jp.sourceforge.webframe.blankapp.test.TestConstants;

import org.apache.log4j.BasicConfigurator;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

/**
 * CompassGpsBeanTest
 *
 * @author Yomei Komiya
 *
 * $Id$
 */
public class CompassGpsBeanTest extends
		AbstractDependencyInjectionSpringContextTests {
	
	static {
		BasicConfigurator.configure();
	}

	
	private CompassGpsBean compassGps = null;
	

	public void setCompassGps(CompassGpsBean compassGps) {
		this.compassGps = compassGps;
	}


	protected String[] getConfigLocations() {
		return TestConstants.SPRING_CONFIG_LOCATIONS;
	}

	
	/*
	 * 'jp.sourceforge.webframe.compass.gps.CompassGpsBean.index()' test method
	 */
	public void testIndex() throws Exception {
		this.compassGps.index();
	}
	
}
