/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass;

import org.apache.log4j.BasicConfigurator;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

import jp.sourceforge.webframe.blankapp.test.TestConstants;

public class IndexSearcherTest 
	extends AbstractDependencyInjectionSpringContextTests {
	
	static {
		BasicConfigurator.configure();
	}
	
	private IndexSearcher indexSearcher = null;
	

	public void setIndexSearcher(IndexSearcher indexSearcher) {
		this.indexSearcher = indexSearcher;
	}


	protected String[] getConfigLocations() {
		return TestConstants.SPRING_CONFIG_LOCATIONS;
	}

	
	public void testFind() throws Exception {
		SearchResult result;
		result = this.indexSearcher.find("2006");
		result = this.indexSearcher.find("call");
	}

	
	public void testTrimExtraOperator() {
		String expected = "keyword";
		String query = "+(keyword)";

		String actual = IndexSearcher.trimExtraOperator(query);
		assertEquals(expected, actual);
		
		query = "+(+(+(keyword)))";
		actual = IndexSearcher.trimExtraOperator(query);
		assertEquals(expected, actual);
	}
}
