/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original creator or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import java.util.Date;

/**
 * SearchableGenericEntity
 *
 * @creator Yomei Komiya
 *
 * $Id$
 */
public abstract class SearchableGenericEntity
	extends SearchableMetaDataEntity {
	
	/**
	 * Document Local Identifier
	 */
	private String localIdentifier;
	
	/**
	 * Document Title
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String title;
	
	/**
	 * Creator
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String creator;
	
	/**
	 * Date
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private Date date;
	
	/**
	 * Subject (optional)
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String subject;
	
	/**
	 * Description (optional)
	 * Dublin Core Metadata Initiative Metadata Term
	 */
	private String description;
	
	/**
	 * Document Content
	 */
	private String content;

	
	public String getTitle() {
		return this.title;
	}

	
	public void setTitle(String title) {
		this.title = title;
	}

	
	public String getLocalIdentifier() {
		return this.localIdentifier;
	}

	
	public void setLocalIdentifier(String localIdentifier) {
		this.localIdentifier = localIdentifier;
	}

	
	public String getCreator() {
		return this.creator;
	}

	
	public void setCreator(String creator) {
		this.creator = creator;
	}

	
	public Date getDate() {
		return this.date;
	}

	
	public void setDate(Date date) {
		this.date = date;
	}

	
	public String getSubject() {
		return subject;
	}


	public void setSubject(String subject) {
		this.subject = subject;
	}


	public String getDescription() {
		return description;
	}


	public void setDescription(String description) {
		this.description = description;
	}


	public String getContent() {
		return this.content;
	}

	
	public void setContent(String content) {
		this.content = content;
	}

}
