/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.document;

import java.io.ByteArrayOutputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.itscool.commons.document.AbstractDocument;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class XmlDocument
extends AbstractDocument {
    protected Document document;

    public Document getDocument() {
        return this.document;
    }

    public XmlDocument(String rootName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation domImpl = builder.getDOMImplementation();
        Document document = domImpl.createDocument("", rootName, null);
        this.init(document);
    }

    public XmlDocument(Document document) throws Exception {
        this.init(document);
    }

    protected void init(Document document) {
        String version = System.getProperty("java.version");
        if (version.indexOf("1.4") != 0) {
            System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        }
        this.document = document;
    }

    public String parseText(String encoding) throws Exception {
        DOMSource source = new DOMSource(this.document);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        if (encoding == null || encoding.length() == 0) {
            encoding = "utf-8";
        }
        Properties properties = new Properties();
        properties.setProperty("encoding", encoding);
        transformer.setOutputProperties(properties);
        transformer.transform(source, new StreamResult(os));
        return new String(os.toByteArray(), encoding);
    }

    public String parseTextIndent(String encoding) throws Exception {
        DOMSource source = new DOMSource(this.document);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        if (encoding == null || encoding.length() == 0) {
            encoding = "utf-8";
        }
        Properties properties = new Properties();
        properties.setProperty("encoding", encoding);
        transformer.setOutputProperties(properties);
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, new StreamResult(os));
        return new String(os.toByteArray(), encoding);
    }

    public String parseText() throws Exception {
        return this.parseText(null);
    }
}

