package org.itscool.weber.testcase;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import org.itscool.commons.document.BeanToXmlDocument;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.request.UploadFile;
import org.itscool.weber.action.ActionBucket;
import org.w3c.dom.Document;

/**
 * ActionBcuketNX̃bNNXł<BR>
 * ̃NXWeberTestCaseCX^Xɍ쐬܂B
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2005/08/01
 */
public class MockActionBucket implements ActionBucket{
    /** NGXgp[^ۗLIuWFNg */
    private Object form;
    
    /** ANV錠Xg */
    private HashMap roles = new HashMap();
    /** HttpServletRequestCX^X̃bNCX^Xł */
    private HashMap request = new HashMap();
    /** HttpServletSessionCX^X̃bNCX^Xł */
    private HashMap session = new HashMap();
    /** ServletContextCX^X̃bNCX^Xł */
    private HashMap context = new HashMap();
    
    private Document responseXml;
    private String responseText;
    
    /** _~[̃NG[ł */
    private String queryString;
    
    public MockActionBucket(){}
    
    /** */
    public String getRealPath(String path){
        return path;
    }
    public String getQueryString(){
        return queryString;
    }
    
    public void setQueryString(String queryString){
        this.queryString = queryString;
    }
    
    /**
     * 񃊃Xg擾܂
     * @return roles 񃊃Xg
     */
    public HashMap getRoles() {
        return roles;
    }
    /**
     * 񃊃XgZbg܂
     * @param roles 񃊃Xg
     */
    public void setRoles(HashMap roles) {
        this.roles = roles;
    }
    
    /**
     * Xgɓo^܂
     * @param roleName 
     */
    public void putRole(String roleName){
        if( roles == null ){
            roles = new HashMap();
        }
        roles.put(roleName, roleName);
    }
    /**
     * tH[IuWFNg擾܂
     * @return tH[IuWFNg
     */
    public Object getForm() {
        return form;
    }
    
    /**
     * tH[IuWFNgZbg܂
     * @param object tH[IuWFNg
     */
    public void setForm(Object object) {
        form = object;
    }
    
    /**
     * NGXgXR[vɃIuWFNgZbg܂
     * @param key p[^̃L[
     * @param val p[^
     */
    public void setAttribute(String key, Object val){
        request.put(key, val);
    }
    
    /**
     * NGXgXR[vIuWFNg擾܂
     * @param key p[^̃L[
     * @return NGXgp[^
     */
    public Object getAttribute(String key){
        return request.get(key);
    }
    
    /**
     * ZbVXR[vɃIuWFNgZbg܂
     * @param key p[^̃L[
     * @param val p[^
     */
    public void setAttributeFromSession(String key, Object val){
        session.put(key, val);
    }
    
    /**
     * ZbVXR[vIuWFNg擾܂
     * @param key p[^̃L[
     * @return NGXgp[^
     */
    public Object getAttributeFromSession(String key){
        return session.get(key);
    }
    
    /**
     * AvP[VXR[vɃIuWFNgZbg܂
     * @param key p[^̃L[
     * @param val p[^
     */
    public void setAttributeFromContext(String key, Object val){
        context.put(key, val);
    }
    
    /**
     * AvP[VXR[vIuWFNg擾܂
     * @param key p[^̃L[
     * @return NGXgp[^
     */
    public Object getAttributeFromContext(String key){
        return context.get(key);
    }
    
    /**
     * NGXgXR[vIuWFNg擾܂
     * @param key p[^̃L[
     */
    public void removeAttribute(String key){
        request.remove(key);
    }
    
    /**
     * ZbVXR[vIuWFNg擾܂
     * @param key p[^̃L[
     */
    public void removeAttributeFromSession(String key){
        session.remove(key);
    }
    
    /**
     * AvP[VXR[vIuWFNg擾܂
     * @param key p[^̃L[
     */
    public void removeAttributeFromContext(String key){
        context.remove(key);
    }
    
    /**
     * p[^Ŏw肳ꂽeLXgo͂܂
     * @param buff eLXg
     */
    public void print(String buff) throws IOException{
//		ServletInformation info = ServletInformation.getInstance();
        System.out.println(buff);
        responseText = buff;
    }
    
    /**
     * p[^Ŏw肳ꂽXMLhLgo͂܂
     * @param document XMLhLg
     * @throws Exception
     */
    public void printXml(Document document) throws Exception{
        BeanToXmlDocument beanToXml = new BeanToXmlDocument(document);
        this.responseXml = document;
        System.out.println( beanToXml.parseText());
    }
    
    public void printXml(BeanToXmlDocument beanToXml) throws Exception
    {
        Document document = beanToXml.getDocument();
        this.printXml(document);
    }
    
    public void printXml(Object bean, String rootName) throws Exception{
        BeanToXmlDocument beanToXml = new BeanToXmlDocument(rootName);
        beanToXml.addElement(bean, "bean");
        printXml(beanToXml);
    }
    
    public void print(InputStream is, String resourceName) throws IOException{
        
    }
    
    /**
     * tH[G[̍ē͏
     * NGXgp[^̒lăZbgȂ
     * @param generalForm tH[CX^X
     */
    public void setRetryInputParam(GeneralForm generalForm) {
        Set keySet = generalForm.keySet();
        Iterator it = keySet.iterator();
        
        while( it.hasNext() ){
            String paramName = (String)it.next();
            Object paramValue = generalForm.getParameter(paramName);
            if(paramValue instanceof UploadFile){
                UploadFile file = (UploadFile)paramValue;
                String value = file.getPath() + System.getProperty("file.separator")
                + file.getFileName();
                request.put(paramName, value);
            }else{
                request.put(paramName, paramValue);
            }
        }
    }
    
    public Document getResponseXml() {
        return responseXml;
    }

    public String getResponseText() {
        return responseText;
    }
}
