/*
 * WeberLogicDispatcher.java
 *
 * Created on 2007/01/28, 7:50
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.itscool.stylist.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.itscool.commons.util.FileUtil;
import org.itscool.commons.util.StringUtil;
import org.itscool.stylist.tag.HtmlRootTag;
import org.itscool.stylist.tag.HtmlTag;

/**
 * NGXgpXAANVAtH[IuWFNg
 * ANVs̑JڐURL𐶐NXł<br>
 * @author kanou
 */
public class RequestDispatcher {
    /**
     * NGXgpX
     */
    private String fullPath = "";
    /**
     * WebAvP[Ṽ[gfBNgAW[AANV
     * pX
     */
    private String etcPath = "";
    /**
     * W[iNGXgpX̍Ō̃pX)
     */
    private String moduleName = "";
    public static final String LAYOUT = "layout";
    
    /**
     * NGXgURL񂩂烂W[AANV͂܂
     * <br>
     * j Ⴆ΁Aȉ̃NGXgURL擾郂W[AANV
     * <br>
     * http://localhost/web-app-root/web-root/module_name/action_name.wb
     * <br>
     * tH[Bean=ModuleName<br>
     * ANV=ActionNameAction<br>
     * ƂȂ܂
     * @param path NGXgURL
     */
    public RequestDispatcher(String path){
        this.fullPath = path;
        StringTokenizer st = new StringTokenizer(path, "/");
        if( path.indexOf("\\") > 0){
            st = new StringTokenizer(path, "\\");
        }
        ArrayList tokens = new ArrayList();
        while(st.hasMoreElements()){
            String element = (String)st.nextElement();
            tokens.add(element);
        }
        int tokenSize = tokens.size();
        
        if(tokenSize < 2){
            //肦ȂP[X
            return;
        }else if( tokenSize == 2){
            moduleName = (String)tokens.get(0);
        }else{
            //W[擾
            moduleName = (String)tokens.get(tokenSize-2);
            //NGXgpX烂W[AANVpX擾
            for(int i=0; i<tokenSize-2; i++){
                etcPath += (String)tokens.get(i) + "/";
            }
        }
        
        if( moduleName.length() == 1 ){
            moduleName = moduleName.toUpperCase();
        }else{
            moduleName = moduleName.substring(0,1).toUpperCase() +
                    moduleName.substring(1, moduleName.length());
        }
        
        moduleName = StringUtil.cnvUnderScorNameToUpperName(moduleName);
        
    }
    
    /**
     * W[擾܂
     * @return W[
     */
    public String getModuleName() {
        return moduleName;
    }
    
    public String getTemplatePath(String templateName){
        String path = getModuleLayoutPath(templateName);
        if( path == null || path.length() == 0 ){
            return null;
        }
        //W[Pʂ̃CAEgt@C݂ꍇ
        if( path != null && FileUtil.isFile(path)){
            //return path;
            File file = new File(path);
            return file.getAbsolutePath();
        }
        path = getBaseLayoutPath(templateName);
        //VXeʂ̃CAEgt@C݂ꍇ
        if( FileUtil.isFile(path) ){
            //return path;
            File file = new File(path);
            return file.getAbsolutePath();
        }
        //throw new RequestDispatchException("_[" + templateName + "]ɑΉt@C܂ł");
        return null;
    }
    
    protected String getModuleLayoutPath(String templateName){
        String returnName = "";
        
        returnName = etcPath + StringUtil.cnvUpperNameToUnderScoreName(moduleName) + "/";
        returnName =  returnName + StringUtil.cnvUpperNameToUnderScoreName(moduleName) + "_" + templateName;
        
        return returnName + ".html";
    }
    
    protected String getBaseLayoutPath(String templateName){
        String returnName = "";
        
        returnName = etcPath + "layout/";
        returnName =  returnName + templateName;
        
        return returnName + ".html";
    }
    
    public Object[] parseLayoutTag(HtmlRootTag layoutTag){
        ArrayList partsOfHtmlList = new ArrayList();
        for(int i=0; i<layoutTag.size(); i++){
            HtmlTag child = (HtmlTag)layoutTag.get(i);
            if( child.getTagKind().equals(HtmlTag.KIND_INCLUDE )){
                String templateName = child.getAttribute("w_name");
                partsOfHtmlList.add(templateName);
//                System.out.println("HIT:"+ child.getTagName());
            }
//            System.out.println(child.getTagName());
            parseLayoutChild(partsOfHtmlList, child);
        }
        return partsOfHtmlList.toArray();
    }
    
    public void parseLayoutChild(ArrayList partsOfHtmlList, HtmlTag layoutTag){
        for(int i=0; i<layoutTag.size(); i++){
            HtmlTag child = (HtmlTag)layoutTag.get(i);
            if( child.getTagKind().equals(HtmlTag.KIND_INCLUDE )){
                String templateName = child.getAttribute("w_name");
                partsOfHtmlList.add(templateName);
//                System.out.println("HIT:"+ child.getTagName());
            }
//            System.out.println(child.getTagName());
            parseLayoutChild(partsOfHtmlList, child);
        }
    }
}
