package org.itscool.commons.logging;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

/**
 * VvȃMO[eBeBNXł<br>
 * ̃NX͎Ɉȉ̋@\񋟂܂B<br>
 * (1) O[eCg<br>
 *    o͂郍Ot@C̃TCYwTCY𒴂Ɠtt̊gq
 *    ŃÕobNAbvs܂B<br>
 *    t@CTCYmaxSizeŎw肵܂<br>
 * <br>
 * (2) Ox̐؂蕪<br>
 * ȉ̃xŃȌo̓x؂ւ鎖o܂B<br>
 * fobOFdebug
 * tH[[VFinfo<br>
 * xFwarn<br>
 * G[Ferror<br>
 * dȃG[Ffatal<br>
 * <br>
 * (3) o̓[h̐؂蕪<br>
 *   ȉ̃[hŃȌo̓[h؂ւ鎖ł܂B<br>
 * R\[óFdisp<br>
 * t@CóFfile<br>
 * R\[^t@CóFall<br>
 * <br>
 * (4) t@Cõ͎GR[hencodeŎw肵܂<br>
 * <br>
 * (5) Oo͑ΏۃNX̃p^[`<br>
 * outputClassesXgɃOo͑ΏۃNX̃p^[`܂<br>
 * p^[`Ȃꍇ͑SẴOo͑ΏۂƂȂ܂<br>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2000/03/02
 */
public class SimpleLog extends AbstractLog{
    private static SimpleLog log = null;
    
    public void trace(String msg){
        out(msg, TRACE, 3);
    }
    
    public void debug(String msg){
        out(msg, DEBUG, 3);
    }
    
    public void info(String msg){
        out(msg, INFO, 3);
    }
    
    public void warn(String msg){
        out(msg, WARN, 3);
    }
    
    public void error(String msg){
        out(msg, ERROR, 3);
    }
    
    public void fatal(String msg){
        out(msg, FATAL, 3);
    }
    
    public void trace(Exception msg){
        out(msg, TRACE);
    }
    
    public void debug(Exception msg){
        out(msg, DEBUG);
    }
    
    public void info(Exception msg){
        out(msg, INFO);
    }
    
    public void warn(Exception msg){
        out(msg, WARN);
    }
    
    public void error(Exception msg){
        out(msg, ERROR);
    }
    
    public void fatal(Exception msg){
        out(msg, FATAL);
    }
    
    public void trace(Error msg){
        out(msg, TRACE);
    }
    
    public void debug(Error msg){
        out(msg, DEBUG);
    }
    
    public void info(Error msg){
        out(msg, INFO);
    }
    
    public void warn(Error msg){
        out(msg, WARN);
    }
    
    public void error(Error msg){
        out(msg, ERROR);
    }
    
    public void fatal(Error msg){
        out(msg, FATAL);
    }
    
    /**
     * LogCX^X擾܂
     * @return LogCX^XԂ܂
     */
    public static synchronized AbstractLog getInstance(){
        if( log == null ){
            log = new SimpleLog();
        }
        return log;
    }
    
    /**
     * [yyyy/mm/dd/HH:MM:SS:mmmmmm]]level[LEVEL]class:[CLASS]method:[METHOD]msg[MSG]
     * `̃Oo͂܂B<br>
     * out\bhďoƂ̃NXThrowable().getStackTrace()\bhg
     * ďoƂ̃NXƃ\bh܂<br>
     *
     * @param logMsg O
     * @param levelNow Ȍo̓x
     */
    protected synchronized void out(String logMsg, String levelNow, int classLevel){
        //Oõ͎NX擾
        CallClass call = new CallClass(classLevel);  //3ŌŒI
        String clazz = call.getClassName();
        String func = call.getMethodName();
        int line = call.getLineNumber();
        
        //Oo͑ΏۂłȂꍇ͖o
        if(!isOutputClass(clazz, levelNow)){
            return;
        }
//        //Ȍo̓x̃`FbN
        if( this.levelInt > getLevelNum(levelNow) ){
            return;
        }
        try{
            if( mode.equals(FILE_MODE) ){
                outFile( clazz, func, logMsg, levelNow, line );
            }else if( mode.equals(DISP_MODE) ){
                outDisp( clazz, func, logMsg, levelNow, line );
            }else if( mode.equals(ALLOUT_MODE)){
                outFile( clazz, func, logMsg, levelNow, line );
                outDisp( clazz, func, logMsg, levelNow, line );
            }else{
                outDisp( clazz, func, logMsg, levelNow, line );
            }
        }catch( IOException ioe ){
            throw new LogRuntimeException(ioe.getMessage());
        }
    }
    
    /**
     * [yyyy/mm/dd/HH:MM:SS:mmmmmm]]level[LEVEL]class:[CLASS]method:[METHOD]msg[MSG]
     * `̃Oo͂܂B<br>
     * out\bhďoƂ̃NXThrowable().getStackTrace()\bhg
     * ďoƂ̃NXƃ\bh܂<br>
     *
     * @param e O
     * @param levelNow Ȍo̓x
     */
    protected synchronized void out(Exception e, String levelNow){
        if(e.getMessage()==null){
            log.out(e.getClass().getName(), levelNow, 4);
        }else{
            log.out(e.getMessage(), levelNow, 4);
        }
        StackTraceElement[] traceList = e.getStackTrace();
        for (int i = 0; i < traceList.length; i++) {
            StackTraceElement trace = traceList[i];
            out(trace.toString(), levelNow, 4);
        }
    }
    
    /**
     * [yyyy/mm/dd/HH:MM:SS:mmmmmm]]level[LEVEL]class:[CLASS]method:[METHOD]msg[MSG]
     * `̃Oo͂܂B<br>
     * out\bhďoƂ̃NXThrowable().getStackTrace()\bhg
     * ďoƂ̃NXƃ\bh܂<br>
     *
     * @param e O
     * @param levelNow Ȍo̓x
     */
    protected synchronized void out(Error e, String levelNow){
        if(e.getMessage()==null){
            log.out(e.getClass().getName(), levelNow, 4);
        }else{
            log.out(e.getMessage(), levelNow, 4);
        }
        StackTraceElement[] traceList = e.getStackTrace();
        for (int i = 0; i < traceList.length; i++) {
            StackTraceElement trace = traceList[i];
            out(trace.toString(), levelNow, 4);
        }
    }
    
//    /**
//     * [yyyy/mm/dd/HH:MM:SS:mmmmmm]]level[LEVEL]class:[CLASS]method:[METHOD]msg[MSG]
//     * `̃OINFOxŏo͂܂B<br>
//     * out\bhďoƂ̃NXThrowable().getStackTrace()\bhg
//     * ďoƂ̃NXƃ\bh܂<br>
//     *
//     * @param logMsg O
//    */
//    public static void outConsole(String logMsg){
//        CallClass call = new CallClass(1);
//        String clazz = call.getClassName();
//        String func = call.getMethodName();
//
//        outDisp( clazz, func, logMsg, Log.INFO );
//    }
    
    /**
     * Ot@Cɏo͂܂B
     *
     * @param clazz out\bhďoNX
     * @param func out\bhĂяo\bh
     * @param logMsg O
     * @param levelNow Ȍo̓x
     */
    protected void outFile(String clazz, String func, String logMsg, String levelNow, int line)
    throws IOException{
        if( maxSize <= 0 ){
            outDisp( clazz, func, logMsg, levelNow, line );
            outDisp( SimpleLog.class.getName(), "outFile()", "t@C̏o̓TCYOł", ERROR, line );
            return;
        }
        
        //Ot@C̃TCY`FbN
        sizeCheck();
        //t@CI[v
        //RandomAccessFile raf = new RandomAccessFile( logPath , "rw" );
        //t@C̍Ōֈړ
        //raf.seek( raf.length());
        //bZ[W̏
        //raf.writeBytes(Log.getMsg( clazz, func, logMsg, levelNow));
        //t@CN[Y
        //raf.close();
        Writer w = new OutputStreamWriter(new FileOutputStream(logPath, true), encode);
        w.write(SimpleLog.getMsg( clazz, func, logMsg, levelNow, line));
        w.close();
    }
    
    /**
     * OR\[ɏo͂܂B
     *
     * @param clazz out\bhďoNX
     * @param func out\bhĂяo\bh
     * @param logMsg O
     * @param levelNow Ȍo̓x
     */
    protected static void outDisp(String clazz, String func, String logMsg,
        String levelNow, int line){
        
        System.out.print(getMsg(clazz, func, logMsg, levelNow, line));
    }
    
    /**
     * bZ[WO̎擾
     * @param clazz    vZX
     * @param func     ֐
     * @param logMsg   ObZ[W
     * @param levelNow Oo̓x
     * @return log     쐬̃ObZ[W
     *
     */
    protected static String getMsg( String clazz, String func, String logMsg,
        String levelNow, int line ){
        StringBuffer log = new StringBuffer();
        log.append(SimpleLog.getNowDate());
        log.append(" ").append(getLogKind(levelNow));
        log.append(" ").append(clazz);
        log.append(" ").append(func);
        log.append("(line=").append(line).append(")");
        log.append(" (").append(logMsg).append(")");
        log.append(System.getProperty( "line.separator" ));
        return log.toString();
    }
}

