package org.itscool.commons.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * JSONƂJavaScript Object
 * Notation̗̂łBJSON`̃f[^JavaScriptŎ]
 * ieval()Ŏ]łĵłΉł\܂B
 * {Iɂ͈ȉ̌`ɂȂ܂B
 *
 *  { "vpeB" : l }
 *
 * ̃f[^ǂݍݗpɂdata = eval("("+f[^+")")Ƃƕϐdata
 * JSONŒ`ꂽvpeB̒l܂B
 * ႦΈȉ̂悤JSONt@CƂ܂B
 *
 * {
 * "userID":"ajax",
 * "userPW":"xanadu"
 * }
 *
 *
 * ̃f[^ϐdataɓǂݍ񂾂Ƃ܂BuserIDvpeB̒lǂݏoɂ
 * data.userIDƋLq܂B
 * ajax̕Ԃ܂Bldata.userPWƂxanadu̕Ԃ
 * BPɃIuWFNg.vpeB̋Lqōς݂܂B
 * vpeB̒lɂ͊֐Ȃǂ`邱Ƃł܂B
 * ɂIuWFNg.vpeB()ƂĖɃJbRtꍇɃv
 * peB̓e֐s܂B
 * ܂胁\bh`̂ƓƂɂȂ܂B
 *
 * ł͎ۂ̃f[^ǂݍݕ\Ă݂܂Bȉ̏iƂɊւf[^
 * LqꂽJSONf[^ǂݍݕ\܂
 * JSONf[^͒PȃeLXgt@CȂ̂responseTextŎ擾Kv܂B
 * 擾f[^eval()ŕ]AevpeB\΂łłB
 * ۂɂ͏iPƂƂ͂܂BȂ葽̏iXgA
 * ڂɓn͂łB
 * ̂悤ȏꍇɂ͔z𗘗pJSONf[^ƂĒ`܂B
 * ͈ȉ̂悤ɂȂ܂B
 *
 * ̃f[^܂JSONf[^
 *
 * {"item":[
 * {"itemCode":91,
 * "itemName":"[",
 * "itemPrice":300},
 *
 * {"itemCode":94,
 * "itemName":"X[",
 * "itemPrice":290},
 *
 * {"itemCode":95,
 * "itemName":"؍[",
 * "itemPrice":320}
 * ]
 * }
 *
 * ̏ꍇAϐdataɃf[^ǂݍ܂ꂽꍇAŏ̃f[^i[j
 * ANZXɂdata.item[0].itemCodê悤ɂ܂B
 * zƂĒ`Ă̂ŁÂ悤ɋLq邱ƂɂȂ܂B
 * 2Ԗڂ̃f[^łdata.item[1].itemCodeƂȂ܂B
 * Ƃ͕Kvɉăf[^̐JԂ΂悢ƂɂȂ܂B
 * L̃f[^\vO͈ȉ̂悤ɂȂ܂B
 * iۂ̃Tvsj
 *
 *
 * @version 1.00A 2006/08/23 VK쐬
 * @author kano
 *
 */
public class BeanToJsonDocument extends AbstractDocument{
    private String LINE=System.getProperty("line.separator");
    private ArrayList pBeanList = new ArrayList();
    private String rootName;
    
    /**
     * [gurootNamevŎw肵VDocumentCX^X
     * 쐬܂
     * @param rootName ̃hLg̃[gvf̖O
     * @throws Exception
     */
    public BeanToJsonDocument(String rootName) {
        this.rootName = rootName;
    }
    
    /**
     * w肳ꂽIuWFNghLgɒǉ܂<BR>
     * vf̓IuWFNg̃NXZbg܂
     * @param bean hLgɒǉIuWFNg
     * @throws Exception
     */
    public void addElement(Object bean) throws Exception{
        DocumentBean pBean = DocumentBeanParser.parseBean(bean, bean.getClass(), this);
        addElement(pBean);
    }
    
    /**
     * ListCX^Xɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param list hLgɒǉListCX^X
     * @throws Exception
     */
    public void addElement(List list) throws Exception{
        for( int i=0; i<list.size(); i++){
            Object bean = list.get(i);
            DocumentBean pBean = DocumentBeanParser.parseBean(bean, bean.getClass(), this);
            addElement(pBean);
        }
    }
    
    /**
     * MapCX^Xɓo^ĂIuWFNghLg
     * ǉ܂<BR>
     * @param map hLgɒǉMapCX^X
     * @throws Exception
     */
    public void addElement(Map map) throws Exception{
        Set set = map.keySet();
        Iterator it = set.iterator();
        while( it.hasNext()){
            Object key = it.next();
            Object bean = map.get(key);
            DocumentBean pBean = DocumentBeanParser.parseBean(bean, bean.getClass(), this);
            addElement(pBean);
        }
    }
    
    /**
     * JavaBeansWJIuWFNghLgɒǉ܂
     * @param pBean hLgɒǉParseBeanCX^X
     * @throws Exception
     */
    protected void addElement(DocumentBean pBean) throws Exception{
        pBeanList.add(pBean);
    }
    
    /**
     * DocumentBeanCX^XJSONtH[}bg𐶐܂
     * @return JSON`̃eLXg
     */
    public String parseText(){
        StringBuffer sb = new StringBuffer("{\""+rootName+"\":");
        //sb.append(LINE);
        int size = pBeanList.size();
        for(int i=0; i<size; i++){
            DocumentBean dBean = (DocumentBean)pBeanList.get(i);
            sb.append("{");
            int dBeanSize = dBean.size();
            if( dBeanSize > 1 ){
                for(int j=0; j<dBeanSize; j++){

                    DocumentBean child = (DocumentBean)dBean.get(j);
                    String value = parseText(child, child.getName());
                    sb.append(value);

                    if((j+1)<dBeanSize){
                        sb.append(",");
                        //sb.append(LINE);
                    }
                }
            }else{
                String name = dBean.getName();
                String value = (String)dBean.getValue();
                sb.append("\""+name+"\":");
                sb.append("\""+value+"\"");
            }
            sb.append("}");
            if( (i+1)<size ){
                sb.append(",");
                //sb.append(LINE);
            }
            //sb.append(LINE);
        }
        sb.append("}");
        return sb.toString();
    }
    
    /**
     * qDocumentBeanCX^XJSONtH[}bg𐶐܂
     * @param dBean qDocumentBean
     * @param parentName e̖O
     * @return JSON`̃eLXg
     */
    public String parseText(DocumentBean dBean, String parentName){
        StringBuffer sb = new StringBuffer();
        sb.append("\""+parentName+"\":");
        
        //sb.append(LINE);
        int size = pBeanList.size();
        
        int dBeanSize = dBean.size();
        if( dBeanSize > 1 ){
            sb.append("{");
            for(int j=0; j<dBeanSize; j++){
                DocumentBean child = (DocumentBean)dBean.get(j);
                String value = parseText(child, child.getName());
                sb.append(value);

                if(j<(dBeanSize-1)){
                    sb.append(",");
                    //sb.append(LINE);
                }
            }
            sb.append("}");
        }else{
            sb.append("\"").append(dBean.getValue()).append("\"");
        }
        
        
        //sb.append(LINE);
        
        return sb.toString();
    }
}



