package org.itscool.commons.dao;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import org.itscool.commons.bean.BeanUtil;

/**
 * OQƗpRecordsMp쐬NX<P>
 *
 * JavaBeans̃Ame[VǂݎAe[u}bsONXiRecordMap)
 * 𐶐郆[eBeBNXł<P>
 *
 * JavaBeansɂ͈ȉ̃NX񂪊܂܂ĂKv܂<P>
 *
 * public static final FK_TABLE_vpeBŒ`ꂽe[u
 * iȗꂽꍇ́ANXOQƐ̃e[uƂȂ܂jƃvpeB
 * ɑΉIuWFNg̐錾<BR>
 *
 * public static final FK_COLUM_vpeB_OQƃL[Œ`ꂽtB[h
 * iȗꂽꍇ,e[uɃ}bsO܂jFK_TABLE_vpeB
 * w肵OQƃe[uɑΉvpeB̐錾ĩvpeBForgine Key
 * Y܂j<BR>
 * óAJavaBeansŒ`ĂvpeBƓOgpKv
 * ܂B
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class RecordMapFkFactory extends RecordMapFactory{
    /**
     * COLUM}bsO`錾
     */
    public static final String FK_COLUM = "FK_COLUM_";
    
    /**
     * TABLE}bsO`錾
     */
    public static final String FK_TABLE = "FK_TABLE_";
    
    /**
     * Ɏw肵NXɊ֘AOQƃe[up̃}bsO쐬܂<br>
     * OQƃ}bsÕXǵiL[vpeBAlRecordMapCX^Xǰ`
     * @param className iΏۂƂȂJavaBeans̃NX
     * @return OQƃ}bsÕXgԂ܂iL[vpeBAlRecordMapCX^Xj
     */
    public static HashMap createFkRecordMaps( String className){
        try{
            Class entity = Class.forName(className);
            return createFkRecordMaps( entity );
        }catch(ClassNotFoundException e){
            e.printStackTrace();
            return null;
        }
    }
    
    /**
     * Ɏw肵NXɊ֘AOQƃe[up̃}bsO쐬܂<br>
     * OQƃ}bsÕXǵiL[vpeBAlRecordMapCX^Xǰ`
     * @param entity iΏۂƂȂJavaBeans̃NX
     * @return OQƃ}bsÕXgԂ܂iL[vpeBAlRecordMapCX^Xj
     */
    public static HashMap createFkRecordMaps( Class entity ){
        init();
        try{
            HashMap fkRecordMaps = new HashMap();
        
            fkRecordMaps = createFkRecordMaps( entity, fkRecordMaps );
            return fkRecordMaps;
        
        }catch(Exception e){
            log.error(e.getMessage());
            throw new DaoRuntimeException(e.getMessage());
        }
    }
    
    /**
     * Ɏw肵NXɊ֘AOQƃe[up̃}bsO쐬܂<br>
     * OQƃ}bsÕXǵiL[vpeBAlRecordMapCX^Xǰ`
     * @param entity iΏۂƂȂJavaBeans̃NX
     * @param fkReocrdMaps OQƃ}bsÕXgiċNĂяopj
     * @return OQƃ}bsÕXgԂ܂iL[vpeBAlRecordMapCX^Xj
     */
    public static synchronized HashMap createFkRecordMaps( Class entity, HashMap fkRecordMaps ){
        //eNX̃o瑖
        Class superClazz = entity.getSuperclass();
        if( superClazz != null ){
            fkRecordMaps = createFkRecordMaps( superClazz, fkRecordMaps );
        }
        String clazzName = entity.getName();
        //-------------------------------------------------------
        //RecordMapۗLeFieldMapCX^Xɑ΂
        //ΉJZbgĂ܂B
        //JZbgϐ"COLUM_vpeB"łKv܂
        //-------------------------------------------------------
        Field[] fields = entity.getDeclaredFields();
        for( int i=0; i<fields.length; i++){
            //JavaBeansɒ`ꂽtB[h擾܂
            Field field = fields[i];
            //tB[hModifier擾܂
            int modifier = field.getModifiers();
            try{
                String staticName = field.getName();
                int index = staticName.indexOf(FK_TABLE);
                //public static final AEq̃tB[hFK_TABLEtB[h
                if( modifier == (Modifier.PUBLIC + Modifier.STATIC + Modifier.FINAL)
                && index == 0){
                    String propertyName = staticName.substring((FK_TABLE).length(), staticName.length());
                    String propertyType = getPropertyType(entity, propertyName);
                    
                    RecordMap recordMap = RecordMapFactory.createRecordMap(propertyType);
                    setForignKey( recordMap, entity, FK_TABLE+propertyName, FK_COLUM+propertyName+"_" );
                    
                    if( propertyType != null ){
                        recordMap.setClassName(propertyType);
                        fkRecordMaps.put(propertyName, recordMap);
                    }
                }
                
            }catch(Exception e){}
            
        }
        return fkRecordMaps;
    }
    
    /**
     * 
     */
    private static void setForignKey(RecordMap recordMap, Class entity, String tableHeaderName, String columHeaderName){
        Object obj = BeanUtil.createInstance(entity.getName());
        String tableName = getTableName(entity, obj, tableHeaderName);
        //RecordMap recordMap = new RecordMap(entity.getName(), tableName);
        recordMap.setClassName(entity.getName());
        recordMap.setTableName(tableName);
        
        //-------------------------------------------------------
        //RecordMapۗLeFieldMapCX^Xɑ΂
        //ΉJZbgĂ܂B
        //JZbgϐ"COLUM_vpeB"łKv܂
        //-------------------------------------------------------
        Field[] fields = entity.getDeclaredFields();
        for( int i=0; i<fields.length; i++){
            //JavaBeansɒ`ꂽtB[h擾܂
            Field field = fields[i];
            //tB[hModifier擾܂
            int modifier = field.getModifiers();
            //FieldMapCX^X쐬܂
            try{
                String staticName = field.getName();
                int index = staticName.indexOf(columHeaderName);
                if( modifier == (Modifier.PUBLIC + Modifier.STATIC + Modifier.FINAL)
                && index == 0){
                    //FieldMap fieldMap = new FieldMap();
                    String fieldName = (String)field.get(obj);
                    fieldName = fieldName.toUpperCase();
                    String propertyName = staticName.substring((columHeaderName).length(), staticName.length());
                    FieldMap fieldMap = recordMap.getFieldByFieldName(fieldName);
                    fieldMap.setFkPropertyName(propertyName);
                    fieldMap.setForignKey(true);
                    
                }
                
            }catch(IllegalAccessException e){
                String err = "[" + obj.getClass().getName() + ":" + tableName + "]" +
                    "setForignKey() failed(" + RecordMapFkFactory.class.getName() + ") (" +
                    e.getMessage() + ")";
                throw new DaoRuntimeException(err);
            }catch(NullPointerException e){
                String err = "[" + obj.getClass().getName() + ":" + tableName + "]" +
                    "setForignKey() failed(" + RecordMapFkFactory.class.getName() + ") (" +
                    e.getMessage() + ")";
                throw new DaoRuntimeException(err);
            }
            
        }
        //-----------------------------------------------------------
        //"COLUM_o"ɑΉvpeBJavaBeansNX񂩂
        //擾܂
        //-----------------------------------------------------------
        HashMap records = recordMap.getFields();
        Set keySet = records.keySet();
        Iterator iterator = keySet.iterator();
        while( iterator.hasNext() ){
            try{
                Object key = iterator.next();
                FieldMap fieldMap = (FieldMap)records.get(key);
                String propertyName = fieldMap.getPropertyName();
                //Field field = entity.getDeclaredField(propertyName);
                Field field = BeanUtil.getField(entity, propertyName);
                if(field == null){
                    continue;
                }
                String type = field.getType().getName();
                
                fieldMap.setType(type);
            }catch(Exception e){
                e.printStackTrace();
            }
        }
    }
  
}

