/*
 * SqlMapper.java
 *
 * Created on 2007/04/12, 16:18
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.itscool.commons.dao;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.connection.*;
import org.itscool.commons.util.StringUtil;

/**
 * PraparedStatement̃bp[NXłB<br>
 * O/R}bsOp̃\bhĂ܂B
 * @author kanou
 */
public class PreparedStatementWrapper {
    /** }bsO(e[uEe[u`ƃNXŃ}bsO) */
    public static final int MAP_KIND_TABLEMANE_IS_CLASS = 0;
    /** }bsO(NG[̌ʂP̃NXŃ}bsO) */
    public static final int MAP_KIND_QUERY_ONE_CLASS = 1;
    /** }bsO(NG[ASƃNXŃ}bsO */
    public static final int MAP_KIND_ASNAME_IS_CLASS = 2;
    
    private PreparedStatement pstmt;
    
    public PreparedStatementWrapper(PreparedStatement pstmt) {
        //TransactionUtiloRŎ擾PreparedStatementCX^X
        //Connection.close()̃^C~OŎIɃN[Y
        this.pstmt = pstmt;
    }
    
    public void setValue(int id, String value){
        try{
            pstmt.setString(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, byte value){
        try{
            pstmt.setByte(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, short value){
        try{
            pstmt.setShort(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, int value){
        try{
            pstmt.setInt(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, long value){
        try{
            pstmt.setLong(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, double value){
        try{
            pstmt.setDouble(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, float value){
        try{
            pstmt.setFloat(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, byte[] value){
        try{
            pstmt.setBytes(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, InputStream value){
        try{
            pstmt.setBinaryStream(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, Blob value){
        try{
            pstmt.setBlob(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, Reader value){
        try{
            pstmt.setCharacterStream(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, java.util.Date value){
        try{
            java.sql.Date sqlValue = new java.sql.Date(value.getTime());
            pstmt.setDate(id, sqlValue);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    public void setValue(int id, Object value){
        try{
            pstmt.setObject(id, value);
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    /**
     * PreparedStatementexecuteQuery()sAʃZbgŎw肵
     * IuWFNgXgŕԂ܂
     * iOQƂ1Kw܂ŁAManyToOneAOneToOne̐Lj
     */
    public List select(Class entity){
        return select(entity, MAP_KIND_TABLEMANE_IS_CLASS);
    }
    
    /**
     * PreparedStatementexecuteQuery()sAʃZbgŎw肵
     * IuWFNgXgŕԂ܂
     *  treeMAP_KIND_QUERY_ONE_CLASS̏ꍇe[ũJ
     * entitỹvpeBɃZbg܂B
     *  treeMAP_KIND_TABLEMANE_IS_CLASS̏ꍇANX̊֘A`
     * OQƃe[ů֘AꂼΉt܂B
     *  treeMAP_KIND_ASNAME_IS_CLASS̏ꍇANG[AS
     * ie[u_AS_tB[h)ɑΉNX̃vpeBɑΉt܂B
     * 
     * 
     * ܂AentityɎw肳ꂽOQƃL[𖳎āAe[ũJAS
     * entitỹvpeBɃ}bsO܂B
     * entitỹvpeBɃ}bsOꍇAentitỹvpeB
     * J̕ʖiASjŃ}bsO܂B
     * truȅꍇAentityQƂIuWFNg𐶐AQƐ̃IuWFNgɌe[u
     * ʃZbg}bsO܂B
     * iOQƂ1Kw܂ŁAManyToOneAOneToOne̐Lj
     */
    public List select(Class entity, int tree){
        LinkedList result = new LinkedList();
        ResultSet rs = null;
        try{
            RecordMap gRecordMap = RecordMapFactory.createRecordMap(entity);
            HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
            //selects
            rs = pstmt.executeQuery();
            
            String currentTable = null;
            
            // }bsO(NG[̌ʂP̃NXŃ}bsO)ꍇ
            if( tree == MAP_KIND_QUERY_ONE_CLASS ) {
                currentTable = gRecordMap.getTableName();
            }
            List recordList = createRecordList(rs, currentTable, tree);
            
            //쐬recordListBeanɃZbg
            for( int i=0; i<recordList.size(); i++){        //R[hP
                //1R[h擾
                HashMap record = (HashMap)recordList.get(i);
                //IuWFNg쐬
                Object newBean = createBean(record, gRecordMap, tree);
                if( newBean == null ) continue;
                
                //֘ANX̍쐬
                Set keySet = fkRecordMaps.keySet();
                Iterator it = keySet.iterator();
                while(it.hasNext()){     //1R[h̏
                    String fkPropertyName = (String)it.next();
                    RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(fkPropertyName);
                    if( fkRecordMap == null ){
                        continue;
                    }
                    //֘AIuWFNg쐬
                    Object fkBean = createBean(record, fkRecordMap, tree);
                    if( fkBean != null ){
                        //fkBeanZbg
                        BeanUtil.setProperty(newBean, fkPropertyName, fkBean);
                    }
                }
                
                
                
                
                HashMap oneToManyRecordMaps = RecordMapOneToManyFactory.createOneToManyRecordMaps(entity);
                Set mKeySet = oneToManyRecordMaps.keySet();
                Iterator mIt = mKeySet.iterator();
                int childCount=0;
                while(mIt.hasNext()){
                    ArrayList childs = new ArrayList();
                    String propertyName = (String)mIt.next();
                    RecordMap oneToManyRecordMap = (RecordMap)oneToManyRecordMaps.get(propertyName);

                    for( childCount=i;childCount<recordList.size(); childCount++){
                        HashMap child = (HashMap)recordList.get(childCount);
                        Object oneToManyObj = createBean(child, oneToManyRecordMap, tree);
                        childs.add(oneToManyObj);

                        Object chkObj = createBean(child, gRecordMap, tree);
                        if( !RecordMap.isEquals(newBean, chkObj, gRecordMap)){
                            if( childCount > 1 ){
                                childCount --;
                            }
                            break;
                        }
                    }
                    BeanUtil.setProperty(newBean, propertyName, childs);
                }
                if( oneToManyRecordMaps.size() > 0 ){
                    i = childCount;
                }
                
                //IuWFNgʃXgɓo^
                result.add(newBean);
            }
            return result;
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }finally{
            if( rs != null ){
                try{
                    rs.close();
                }catch(Exception e){}
            }
        }
    }
    
    /**
     * ResultSetCX^X烌R[h擾A
     * currentTablenull̏ꍇ́Ae[uƂ̌ʃZbgListŕԂ܂<br>
     * currentTableZbgĂꍇ́ASĂ̌ʃZbgAcurrentTable
     * R[hƂč쐬܂B
     * <pre>
     * List recordList SR[h
     *   |
     *   +-- HashMap record PR[hiL[Fe[uj
     *          |
     *          +-- HashMap datasOfTable 1R[ȟʃZbge[uPʂŕێ
     *              iL[FJAlFIuWFNg
     * </pre>
     * @param rs ResultSetCX^X
     * @param currentTable ʃZbgw肳ꂽe[uŏW񂵂܂
     * @return List ʃZbgListŕԂ܂
     */
    private List createRecordList(ResultSet rs, String currentTable, int tree) throws SQLException {
        ArrayList recordList = new ArrayList();
        while ( rs.next() ) {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            HashMap record = new HashMap();
            for(int i=0;i<columnCount;i++){
                String colName = metaData.getColumnName(i+1);
                String colAsName = metaData.getColumnLabel(i+1);
                String tableName = metaData.getTableName(i+1);
                if( currentTable != null ){
                    tableName = currentTable;
                }
                //ResultSetf[^擾
                Object value = rs.getObject(i+1);
                if( tree == MAP_KIND_ASNAME_IS_CLASS ){     //NG[ASƃNXŃ}bsO
                    int tableIndex = colAsName.indexOf("_AS_");
                    if( tableIndex >= 0 ){
                        tableName = colAsName.substring(0, tableIndex);
                    }
                    
                    int colNameIndex = tableIndex + ("_AS_").length();
                    if( colAsName.length() > colNameIndex && tableIndex >= 0 ){
                        colAsName = colAsName.substring(colNameIndex, colAsName.length());
                    }
                }
                //1sӂ̃e[uɊ֘Af[^}bv
                HashMap datasOfTable = (HashMap)record.get(tableName);
                if( datasOfTable == null ){
                    //System.out.println("NEW DATAS_OF_TABLE[" + tableName + "]");
                    datasOfTable = new HashMap();
                    record.put(tableName, datasOfTable);
                }
                //System.out.println("TABLE[" + tableName + "], COLUM["+colAsName +"]");
                
                datasOfTable.put(colAsName, value);
            }
            recordList.add(record);
        }
        return recordList;
    }
    
    /**
     * ʃZbgɑΉIuWFNg𐶐܂
     * @param record 1R[ȟʃZbg
     * @param recordMap NXƃe[ů֘A
     * @return ʃZbgɑΉIuWFNg
     */
    private Object createBean(HashMap record, RecordMap recordMap, int tree){
        String entityName = recordMap.getClassName();
        String tableName = recordMap.getTableName();
        HashMap datasOfTable = (HashMap)record.get(tableName);
        if( datasOfTable == null ){
            return null;
        }
        Object newBean = BeanUtil.createInstance(entityName);
        Set datasKeySet = datasOfTable.keySet();
        Iterator datasIt = datasKeySet.iterator();
        while(datasIt.hasNext()){
            String colAsName = (String)datasIt.next();
            //IuWFNg̊eoselecťʂZbgĂ
            Object value = datasOfTable.get(colAsName);
            
            //JvpeB擾
            //String propertyName = StringUtil.cnvUnderScorNameToLowerName(colAsName);
            FieldMap field = recordMap.getFieldByFieldName(colAsName);
            String propertyName = field.getPropertyName();
            if( value instanceof java.sql.Date ){
                value = new Date(((java.sql.Date)value).getTime());
            }else if( value instanceof Timestamp ){
                Timestamp ts = (Timestamp)value;
                value = new Date(ts.getTime());
            }else if( value instanceof Blob){
                Blob blob = (Blob)value;
                Class type = BeanUtil.getReturnType(newBean, propertyName);
                if( type.isAssignableFrom(InputStream.class)){
                    try{
                        value = (InputStream)blob.getBinaryStream();
                    }catch(SQLException se){}
                }else if( type.isAssignableFrom(byte[].class )){
                    try{
                        value = (byte[])blob.getBytes((long)0, (int)blob.length());
                    }catch(SQLException se){}
                }
            }else if( value instanceof Clob ){
                Clob clob = (Clob)value;
                Class type = BeanUtil.getReturnType(newBean, propertyName);
                if( type.isAssignableFrom(Reader.class)){
                    try{
                        value = (Reader)clob.getCharacterStream();
                    }catch(SQLException se){}
                }else if( type.isAssignableFrom(String.class )){
                    try{
                        value = (String)clob.getSubString((long)0, (int)clob.length());
                    }catch(SQLException se){}
                }
                
            }
            
            BeanUtil.setProperty(newBean, propertyName, value);
        }
        return newBean;
    }
    
    /**
     * PremeredStatement.executeQuery()̎sʂRecordsCX^X
     * Ŏ擾܂B<br>
     * <pre>
     *    Records SR[h
     *       |
     *       + RecordiHashMap) 1R[h̏
     *           iL[F"e[u.J(啶)"AlFf[^)
     * </pre>
     */
    public Records select(){
        ResultSet rs = null;
        try{
            rs = executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            Records records = new Records();
            while( rs.next() ){
                Record record = new Record();
                //ʃR[h̏WHashMapō쐬
                for(int i=0;i<columnCount;i++){
                    String colName = metaData.getColumnName(i+1);
                    String colAsName = metaData.getColumnLabel(i+1);
                    String tableName = metaData.getTableName(i+1);
                    
                    //񖼂ɕʖw肳Ăꍇ͕ʖgp
                    //Wv֐̏ꍇ͕Kʖw肷ׂł
                    if(!colAsName.equals("")){
                        colName = colAsName;
                    }
                    colName = colName.toUpperCase();
                    Object value = rs.getObject(i+1);
                    
                    //L["e[u.J"Ńf[^Zbg
                    String key;
                    if( tableName != null && tableName.length() > 0 ){
                        key = tableName + "." + colName;
                    }else{
                        key = colName;
                    }
                    key = key.toUpperCase();
                    record.put(key, value);
                    //record.put(colName, value);
                }
                records.add(record);
            }
            return records;
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }finally{
            if( rs != null ){
                try{
                    rs.close();
                }catch(Exception e){}
            }
        }
    }
    
    /**
     * PraperdStatementexecuteQueryes܂
     * @retrun ResultSetCX^XԂ܂
     */
    public ResultSet executeQuery(){
        try{
            ResultSet ret = pstmt.executeQuery();
            return ret;
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
    /**
     * PraperdStatementexecuteUpdates܂
     * @return Ԃ܂
     */
    public int executeUpdate(){
        try{
            int ret = pstmt.executeUpdate();
            return ret;
        }catch(SQLException e){
            throw new TransactionException(e.getMessage());
        }
    }
    
}
