package test.org.itscool.commons.util;

import junit.framework.*;
import java.io.*;
import org.itscool.commons.util.StubGenerator;

public class StubGeneratorTest extends TestCase {

    public interface TestInterface {
        int[][] matrix();
        void vanish(String[][] world);
    }

    PrintStream orgOut;
    protected void setUp() throws Exception {
        orgOut = System.out;
    }

    protected void tearDown() throws Exception {
        System.setOut(orgOut);
    }

    public void testArrayType() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream w = new PrintStream(baos);
        System.setOut(w);
        StubGenerator gen = new StubGenerator("test.org.itscool.commons.util.StubGeneratorTest$TestInterface");
        gen.generate();
        gen.close();
        String check = baos.toString();
        assertTrue(check, check.indexOf("class StubTestInterface implements") >= 0);
        assertTrue(check, check.indexOf("public int[][] matrix()") >= 0);
        assertTrue(check, check.indexOf("(java.lang.String[][] ") >= 0);
    }
    
    public void testGenerate2() throws Exception {
        FileOutputStream baos = new FileOutputStream("test.java");
        PrintStream w = new PrintStream(baos);
        System.setOut(w);
        StubGenerator gen = new StubGenerator("java.sql.Connection");
        gen.generate();
        gen.close();
        String check = baos.toString();
    }
    
    public void testGenerate3() throws Exception {
        FileOutputStream baos = new FileOutputStream("test2.java");
        PrintStream w = new PrintStream(baos);
        System.setOut(w);
        StubGenerator gen = new StubGenerator("java.sql.PreparedStatement");
        gen.generate();
        gen.close();
        String check = baos.toString();
    }
    
    public void testGenerate4() throws Exception {
        FileOutputStream baos = new FileOutputStream("test3.java");
        PrintStream w = new PrintStream(baos);
        System.setOut(w);
        StubGenerator gen = new StubGenerator("java.sql.ResultSet");
        gen.generate();
        gen.close();
        String check = baos.toString();
    }
    
    public static void main(String[] args) {
        junit.textui.TestRunner.run(StubGeneratorTest.class);
    }
}
