/*
 * SampleEntitInfo.java
 *
 * Created on 2007/04/13, 19:49
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package test.org.itscool.commons.dao.recordmap;

import junit.framework.TestCase;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;
import org.itscool.weber.user.User;

/**
 * NX[e[uԃ}bsONX̃eXg
 * @author KANO
 */
public class RecordMapFactoryTest extends TestCase{
    /**
     * iNXɉi`iCOLUM_)ꍇ
     */
    public void testCreate1() {
        RecordMap recordMap = RecordMapFactory.createRecordMap(SampleEntity.class);
        
        //NX[e[u}bsO
        assertEquals("TABLE_NAME", "SAMPLE_ENTITY", recordMap.getTableName());
        assertEquals("CLASS_NAME", SampleEntity.class.getName(), recordMap.getClassName());
        assertEquals("CLASS_ONLY_NAME", "SampleEntity", recordMap.getClassOnlyName());
        
        //vpeB[J}bsO
        FieldMap fieldMap = recordMap.getFieldByFieldName("NAME");
        if( fieldMap == null ){
            fail("NAME IS NULL");
        }
        assertEquals("NAME", fieldMap.getColumName());
        assertEquals("SAMPLE_ENTITY_NAME", fieldMap.getColumAsName());
        assertEquals("name", fieldMap.getPropertyName());
        
        FieldMap dateMap = recordMap.getFieldByFieldName("UPDATE_DATE");
        if( dateMap == null ){
            fail("UPDATE_DATE IS NULL");
        }
        assertEquals("UPDATE_DATE", dateMap.getColumName());
        assertEquals("SAMPLE_ENTITY_UPDATE_DATE", dateMap.getColumAsName());
        assertEquals("updateDate", dateMap.getPropertyName());
        //System.out.println(recordMap.toString());
    }
    
    /**
     * iNXɉi`iCOLUM_)ꍇ
     */
    public void testCreate2(){
        RecordMap recordMap = RecordMapFactory.createRecordMap(User.class);
        //NX[e[u}bsO
        assertEquals("TABLE_NAME", "USER", recordMap.getTableName());
        assertEquals("CLASS_NAME", User.class.getName(), recordMap.getClassName());
        assertEquals("CLASS_ONLY_NAME", "User", recordMap.getClassOnlyName());
        
        //vpeB[J}bsO
        FieldMap fieldMap = recordMap.getFieldByFieldName("NAME");
        if( fieldMap == null ){
            fail("NAME IS NULL");
        }
        assertEquals("NAME", fieldMap.getColumName());
        assertEquals("USER_NAME", fieldMap.getColumAsName());
        assertEquals("name", fieldMap.getPropertyName());
        
       FieldMap roleIdMap = recordMap.getFieldByFieldName("ROLE_ID");
        if( roleIdMap == null ){
            fail("ROLE_ID IS NULL");
        }
        assertEquals("ROLE_ID", roleIdMap.getColumName());
        assertEquals("USER_ROLE_ID", roleIdMap.getColumAsName());
        assertEquals("roleId", roleIdMap.getPropertyName());
//        System.out.println(recordMap.toString());
    }
    
    /**
     * vC}[L[ZbgĂ邩
     */
    public void testPk1() {
        RecordMap recordMap = RecordMapFactory.createRecordMap(User.class);
        FieldMap fieldMap = recordMap.getFieldByFieldName("ID");
        if( fieldMap == null ) fail("ID IS NULL");
        assertEquals("primary-key", true, fieldMap.isPrimaryKey());
    }
    
    /**
     * vC}[L[ZbgĂ邩(ftHgvC}[L[)
     */
    public void testPk2() {
        RecordMap recordMap = RecordMapFactory.createRecordMap(SampleEntity.class);
        FieldMap fieldMap = recordMap.getFieldByFieldName("ID");
        if( fieldMap == null ) fail("ID IS NULL");
        assertEquals("primary-key", true, fieldMap.isPrimaryKey());
    }
    
}
