/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.itscool.commons.util.FileUtil;
import org.itscool.commons.util.StringUtil;
import org.itscool.stylist.tag.HtmlRootTag;
import org.itscool.stylist.tag.HtmlTag;

public class RequestDispatcher {
    private String fullPath = "";
    private String etcPath = "";
    private String moduleName = "";
    public static final String LAYOUT = "layout";

    public RequestDispatcher(String path) {
        this.fullPath = path;
        StringTokenizer st = new StringTokenizer(path, "/");
        if (path.indexOf("\\") > 0) {
            st = new StringTokenizer(path, "\\");
        }
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreElements()) {
            String element = (String)st.nextElement();
            tokens.add(element);
        }
        int tokenSize = tokens.size();
        if (tokenSize < 2) {
            return;
        }
        if (tokenSize == 2) {
            this.moduleName = (String)tokens.get(0);
        } else {
            this.moduleName = (String)tokens.get(tokenSize - 2);
            for (int i = 0; i < tokenSize - 2; ++i) {
                this.etcPath = this.etcPath + (String)tokens.get(i) + "/";
            }
        }
        this.moduleName = this.moduleName.length() == 1 ? this.moduleName.toUpperCase() : this.moduleName.substring(0, 1).toUpperCase() + this.moduleName.substring(1, this.moduleName.length());
        this.moduleName = StringUtil.cnvUnderScorNameToUpperName((String)this.moduleName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getTemplatePath(String templateName) {
        String path = this.getModuleLayoutPath(templateName);
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path != null && FileUtil.isFile((String)path)) {
            File file = new File(path);
            return file.getAbsolutePath();
        }
        path = this.getBaseLayoutPath(templateName);
        if (FileUtil.isFile((String)path)) {
            File file = new File(path);
            return file.getAbsolutePath();
        }
        return null;
    }

    protected String getModuleLayoutPath(String templateName) {
        String returnName = "";
        returnName = this.etcPath + StringUtil.cnvUpperNameToUnderScoreName((String)this.moduleName) + "/";
        returnName = returnName + StringUtil.cnvUpperNameToUnderScoreName((String)this.moduleName) + "_" + templateName;
        return returnName + ".html";
    }

    protected String getBaseLayoutPath(String templateName) {
        String returnName = "";
        returnName = this.etcPath + "layout/";
        returnName = returnName + templateName;
        return returnName + ".html";
    }

    public Object[] parseLayoutTag(HtmlRootTag layoutTag) {
        ArrayList<String> partsOfHtmlList = new ArrayList<String>();
        for (int i = 0; i < layoutTag.size(); ++i) {
            HtmlTag child = (HtmlTag)layoutTag.get(i);
            if (child.getTagKind().equals("include")) {
                String templateName = child.getAttribute("w_name");
                partsOfHtmlList.add(templateName);
            }
            this.parseLayoutChild(partsOfHtmlList, child);
        }
        return partsOfHtmlList.toArray();
    }

    public void parseLayoutChild(ArrayList partsOfHtmlList, HtmlTag layoutTag) {
        for (int i = 0; i < layoutTag.size(); ++i) {
            HtmlTag child = (HtmlTag)layoutTag.get(i);
            if (child.getTagKind().equals("include")) {
                String templateName = child.getAttribute("w_name");
                partsOfHtmlList.add(templateName);
            }
            this.parseLayoutChild(partsOfHtmlList, child);
        }
    }
}

