/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StubGenerator {
    PrintWriter writer;
    int nest;
    boolean closed;
    Class klass;
    String targetName;
    String packageName;
    static final Pattern PPATTERN = Pattern.compile("^(\\[+)(\\w)$");
    static final Pattern TPATTERN = Pattern.compile("^(\\[+)L(.+?);$");
    static final Map TYPE_CONV;

    public StubGenerator(String intf, String target) throws Exception {
        this(intf);
        int last = target.lastIndexOf(".") + 1;
        this.targetName = target.substring(last);
        if (last > 1) {
            this.packageName = target.substring(0, last - 1);
        }
        this.writer = new PrintWriter(new BufferedWriter(new FileWriter(this.targetName + ".java")));
    }

    public StubGenerator(String intf) throws Exception {
        this.klass = Class.forName(intf);
        this.writer = new PrintWriter(System.out);
        this.closed = true;
        int off = intf.lastIndexOf("$") >= 0 ? intf.lastIndexOf("$") : intf.lastIndexOf(".");
        this.targetName = "Stub" + intf.substring(off + 1);
    }

    public void close() throws IOException {
        this.writer.flush();
        if (!this.closed) {
            this.writer.close();
            this.closed = true;
        }
    }

    public void generate() throws IOException {
        this.prepare();
        Method[] m = this.klass.getMethods();
        for (int i = 0; i < m.length; ++i) {
            this.indent();
            this.print("public ");
            this.printType(m[i].getReturnType());
            this.print(" ");
            this.print(m[i].getName());
            this.print("(");
            this.printArgs(m[i].getParameterTypes());
            this.print(")");
            this.printExceptions(m[i].getExceptionTypes());
            this.printReturn(m[i].getReturnType());
            this.indent();
            this.println("}");
        }
        this.last();
    }

    void printArgs(Class[] p) {
        for (int i = 0; i < p.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.printType(p[i]);
            this.print(" a" + i);
        }
    }

    void printExceptions(Class[] p) {
        for (int i = 0; i < p.length; ++i) {
            if (i == 0) {
                this.println("");
                ++this.nest;
                this.indent();
                --this.nest;
                this.print(" throws ");
            } else {
                this.print(", ");
            }
            this.print(p[i].getName());
        }
        this.println(" {");
    }

    void printReturn(Class c) {
        if (c.getName().equals("void")) {
            return;
        }
        ++this.nest;
        this.indent();
        this.print("return ");
        if (c.isPrimitive()) {
            if (c.getName().equals("boolean")) {
                this.println("false;");
            } else {
                this.print("(");
                this.printType(c);
                this.println(")0;");
            }
        } else {
            this.println("null;");
        }
        --this.nest;
    }

    void prepare() {
        if (this.packageName != null) {
            this.print("package ");
            this.print(this.packageName);
            this.println(";");
            this.println("");
        }
        this.println("/**");
        this.print(" * ");
        this.print(this.klass.getName());
        this.println("\u306e\u30b9\u30bf\u30d6\u30af\u30e9\u30b9\u3002");
        this.println(" * @author StubGenerator by arton.");
        this.println(" */");
        this.print("public class ");
        this.print(this.targetName);
        this.print(" implements ");
        this.print(this.klass.getName());
        this.println(" {");
        ++this.nest;
        this.indent();
        this.print("public ");
        this.print(this.targetName);
        this.println("() {");
        this.indent();
        this.println("}");
    }

    void last() {
        this.println("}");
    }

    void printType(Class c) {
        if (!c.isArray()) {
            this.print(c.getName());
            return;
        }
        String nm = c.getName();
        Matcher m = PPATTERN.matcher(nm);
        if (m.find()) {
            this.print((String)TYPE_CONV.get(m.group(2)));
        } else {
            m = TPATTERN.matcher(nm);
            m.find();
            this.print(m.group(2));
        }
        int n = m.group(1).length();
        for (int i = 0; i < n; ++i) {
            this.print("[]");
        }
    }

    void indent() {
        for (int i = 0; i < this.nest; ++i) {
            this.writer.print("    ");
        }
    }

    void print(String string) {
        this.writer.print(string);
    }

    void println(String string) {
        this.writer.println(string);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            System.err.println("usage: java com.example.tool.StubGenerator interface [class]");
            System.exit(1);
        }
        StubGenerator gen = args.length == 1 ? new StubGenerator(args[0]) : new StubGenerator(args[0], args[1]);
        gen.generate();
        gen.close();
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("I", "int");
        map.put("Z", "boolean");
        map.put("B", "byte");
        map.put("C", "char");
        map.put("D", "double");
        map.put("F", "float");
        map.put("J", "long");
        map.put("S", "short");
        TYPE_CONV = Collections.unmodifiableMap(map);
    }
}

