/*
 * SampleCalendarTag.java
 *
 * Created on 2006/12/14, 9:47
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package weber_4_0_sample.org.itscool.customtag;

import java.util.Calendar;
import org.itscool.commons.util.DateElement;
import org.itscool.commons.util.DateFormatUtil;
import org.itscool.commons.util.MonthTable;
import org.itscool.stylist.io.HtmlConverter;
import org.itscool.stylist.tag.HtmlTag;

/**
 *
 * @author kanou
 */
public class SampleCalendarConverter extends HtmlConverter {
    
    public static void main(String[] argv){
        SampleCalendarConverter tag = new SampleCalendarConverter();
        MonthTable month = new MonthTable();
        
        System.out.println(tag.createMonthTag(month));
    }
    
    /**
     * pXHTMLf[^̍쐬Jn܂
     * @param node HtmlTagCX^X
     * @return f[^
     */
    public String convert(HtmlTag node, String tab) {
        
        MonthTable month = (MonthTable)req.getAttribute("calendar");
        if(month == null){
            month = new MonthTable();
        }
        StringBuffer sb = new StringBuffer();
        //J_[\
        sb.append(createMonthTag(month));
        
        return sb.toString();
    }
    
    protected String createMonthTag(MonthTable month){
        StringBuffer sb = new StringBuffer();
        DateElement day = month.getDay(month.getYear(), month.getMonth(), 1);
        
        sb.append("<table class=\"calendar\">").append(LINE);
        sb.append(createHeader());
        int firstYobi = day.getYobi();
        if(firstYobi != Calendar.SUNDAY){
            Calendar cal = DateFormatUtil.getLastMonthWeek(month.getYear(), month.getMonth());
            sb.append("<tr>").append(LINE);
            for(int i=1; i<firstYobi; i++, cal.add(Calendar.DAY_OF_MONTH, 1)){
                day = month.getDay(cal);
                sb.append(createDayTag(day));
            }
        }
        for(int i=0; i<month.getMaxday(); i++){
            day = month.getDay(month.getYear(), month.getMonth(), i+1);
            sb.append(createDayTag(day));
        }
        DateElement lastDay = month.getDay(month.getYear(), month.getMonth(), month.getMaxday());
        if(lastDay.getYobi() != Calendar.SATURDAY){
            Calendar cal = Calendar.getInstance();
            cal.set(Calendar.YEAR, month.getYear());
            cal.set(Calendar.MONTH, month.getMonth()-1);
            cal.set(Calendar.DAY_OF_MONTH, month.getMaxday());
            cal.add(Calendar.DAY_OF_MONTH, 1);
            for(int i=lastDay.getYobi(); i<Calendar.SATURDAY; i++, cal.add(Calendar.DAY_OF_MONTH, 1)){
                day = month.getDay(cal);
                sb.append(createDayTag(day));
            }
            if( day.getYobi() != Calendar.SATURDAY ){
                 sb.append("</tr>").append(LINE);
            }else{
                sb.append(LINE);
            }
        }
        sb.append("</table>");
        return sb.toString();
    }
    
    protected String createDayTag(DateElement day){
        StringBuffer sb = new StringBuffer();
        if(day.getYobi() == Calendar.SUNDAY){
            sb.append("<tr>").append(LINE);
        }
        if( day.isHoliday() ){
            sb.append(TAB).append("<td class=\"holiday\" align=\"center\">");
        }else if(day.getYobi() == Calendar.SUNDAY){
            sb.append(TAB).append("<td class=\"sunday\" align=\"center\">");
        }else if(day.getYobi() == Calendar.SATURDAY){
            sb.append(TAB).append("<td class=\"saturday\" align=\"center\">");
        }else{
            sb.append(TAB).append("<td class=\"day\" align=\"center\">");
        }
        sb.append(day.getDay());
        
        sb.append("</td>").append(LINE);
        if( day.getYobi() == Calendar.SATURDAY ){
             sb.append("</tr>").append(LINE);
        }
        return sb.toString();
    }
    
    /**
     * J_[e[ũwb_쐬
     * @return J_[e[ũwb_
     */
    protected String createHeader(){
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        sb.append(LINE);
        StringBuffer td = new StringBuffer();
        td.append(TAB);
        td.append("<td class=\"header\">");
        
        sb.append(td.toString()).append("").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("").append("</td>");
        sb.append(LINE);
        sb.append(td.toString()).append("y").append("</td>");
        sb.append(LINE);
        sb.append("</tr>").append(LINE);
        return sb.toString();
    }
    
}
