package org.itscool.weber.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.util.InputCheckUtil;
import org.itscool.weber.mapping.MessageMappings;
import org.itscool.weber.mapping.ValidationMapping;

/**
 * ̓`FbNNX<BR>
 * weber-config.xml̃ANVvfɈȉ̗vfǉ邱ƂɂA
 * NGXgp[^̓̓`FbNsƂł܂<BR>
 * <pre>
 *      &lt;action
 *         path="/tutorial2/input.do"
 *         type="tutorial2.InputAction"
 *         name="tutorial2.AskData"&gt;
 *         &lt;!-- NGXgp[^̓̓`FbN --&gt;
 *         &lt;param name="name"&gt;
 *             &lt;!-- K{`FbN --&gt;
 *             &lt;validate type="requird" msgkey="E0001" /&gt;
 *         &lt;/param&gt;
 *         &lt;param name="id"&gt;
 *             &lt;!-- K{`FbN --&gt;
 *             &lt;validate type="requird" msgkey="E0002" /&gt;
 *             &lt;!-- pl`FbN --&gt;
 *             &lt;validate type="digit" msgkey="E0003" /&gt;
 *         &lt;/param&gt;
 *         &lt;param name="score"&gt;
 *             &lt;!-- K{`FbN --&gt;
 *             &lt;validate type="requird" msgkey="E0004" /&gt;
 *             &lt;!-- pp`FbN --&gt;
 *             &lt;validate type="eisu" msgkey="E0005" /&gt;
 *             &lt;!-- l͈̓`FbN --&gt;
 *             &lt;validate type="digit_length" msgkey="E0006" min="0" max="100" /&gt;
 *         &lt;/param&gt;
 *
 *         &lt;forward name="org.itscool.weber.action.INPUT_ERROR" path="/html/tutorial2/input.html"/&gt;
 *         &lt;forward name="success" path="/html/tutorial2/confirm.html"/&gt;
 *     &lt;/action&gt;
 * </pre>
 * paramvfɂ́A̓`FbN̑ΏۂƂȂ郊NGXgp[^̘_w肵܂<BR>
 * paramvfzvalidatevfɃ`FbNڂw肵܂<BR>
 * validatevfɎw肷鑮͈ȉ̒ʂł<BR>
 * <table border="1">
 * 	<tr>
 * 		<td></td><td>K{</td><td></td>
 *  </tr>
 * 	<tr>
 * 		<td>type</td><td>K{</td>
 * 		<td>
 * 			`FbNeI܂<br>
 * 			typeɎw\ȃL[͈ȉ̒ʂł<BR>
 * 			<li>requird K{̓`FbN
 * 			<li>zenkaku	Sp`FbN
 * 			<li>hankaku	p`FbN
 * 			<li>digit	pl`FbN
 * 			<li>eisu	pp`FbN(pXy[X)
 * 			<li>eiji	pp`FbN(pXy[X)
 * 			<li>hankaku_kana	pJi`FbN
 * 			<li>str_length	̌`FbNiȉminAmaxK{j
 * 			<li>digit_length l͈̔̓`FbNiȉminAmaxK{j
 *
 * 		</td>
 *  </tr>
 * 	<tr>
 * 		<td>msgkey</td><td>msgbodyw肵Ȃꍇ͕K{</td>
 * 		<td>̓`FbNŃG[ɂȂƂɏo͂郁bZ[Wmessage-config.xml
 * 		ɓo^Ă郁bZ[WIDŎw肵܂</td>
 *  </tr>
 * 	<tr>
 * 		<td>msgbody</td><td>msgkeyw肵Ȃꍇ͕K{</td>
 * 		<td>̓`FbNŃG[ɂȂɏo͂郁bZ[Ww肵܂</td>
 *  </tr>
 * 	<tr>
 * 		<td>min</td><td>typestr_lengthdigit_lengthw肵ƂK{</td>
 * 		<td>̍ŏ邢͐l̍ŏlw肵܂</td>
 *  </tr>
 * 	<tr>
 * 		<td>max</td><td>typestr_lengthdigit_lengthw肵ƂK{</td>
 * 		<td>̍ő包邢͐l̍őlw肵܂</td>
 *  </tr>
 * </table>
 * @author kanou
 *
 */
public class Validation {
    private static Validation instance = new Validation();
    public final static String ZENKAKU = "zenkaku";
    public final static String HANKAKU = "hankaku";
    public final static String DIGIT = "digit";
    public final static String EISU = "eisu";
    public final static String EIJI = "eiji";
    public final static String HANKAKU_KANA = "hankaku_kana";
    public final static String DIGIT_LENGTH = "digit_length";
    public final static String STR_LENGTH = "str_length";
    public final static String REQUIRD = "requird";
    public final static String MAIL = "mail";
    public final static String TEL = "tel";
    public final static String POST = "post";
    public final static String URL = "url";
    
    public static Validation getInstance(){
        return instance;
    }
    
    public HashMap isValidate(List validates, GeneralForm request){
        HashMap errList = new HashMap();
        if(validates == null){
            return errList;
        }
        int size = validates.size();
        for(int i=0; i<size; i++){
            ValidationMapping validation = (ValidationMapping)validates.get(i);
            String paramName = validation.getParamName();
            if(validation == null){
                continue;
            }
            Object value = request.getParameter(paramName);
            if( !(value instanceof String) ){
                continue;
            }
            validate(errList, paramName, validation, (String)value);
            
        }
        return errList;
    }
    
    protected void validate( HashMap errList, String paramName,
        ValidationMapping validation, String value ){
        String type = validation.getType();
        String msgkey = validation.getMsgkey();
        String msgbody = validation.getMsgbody();
        double max = validation.getMax();
        double min = validation.getMin();
        int length = validation.getLength();
        
        boolean ret = true;
        
        if(type.equals(ZENKAKU)){
            ret = InputCheckUtil.checkFullSize(value);
        }else if(type.equals(HANKAKU)){
            ret = InputCheckUtil.checkHalfSize(value);
        }else if(type.equals(DIGIT)){
            ret = InputCheckUtil.checkDigit(value);
        }else if(type.equals(EISU)){
            ret = InputCheckUtil.checkDigitAlphabet(value);
        }else if(type.equals(EIJI)){
            ret = InputCheckUtil.checkAlphabet(value);
        }else if(type.equals(HANKAKU_KANA)){
            ret = InputCheckUtil.checkHankakuKana(value);
        }else if(type.equals(DIGIT_LENGTH)){
            ret = InputCheckUtil.checkDigitLength(value, min, max);
        }else if(type.equals(STR_LENGTH)){
            ret = InputCheckUtil.checkStrLength(value, (int)min, (int)max);
        }else if(type.equals(REQUIRD)){
            ret = InputCheckUtil.checkRequerd(value);
        }else if(type.equals(MAIL)){
            ret = InputCheckUtil.checkMailAddr(value);
        }else if(type.equals(TEL)){
            ret = InputCheckUtil.checkTelNo(value);
        }else if(type.equals(POST)){
            ret = InputCheckUtil.checkPostCode(value);
        }else if(type.equals(URL)){
            ret = InputCheckUtil.checkUrl(value);
        }else{
            String errmsg = "Input Check Type Error [" + type + "]";
            putMessage( errList, msgkey, errmsg);
        }
        if(!ret){
            putMessage( errList, msgkey, msgbody);
        }
    }
    
    /**
     * G[R[hǉ܂
     * @param key G[肷邽߂̃j[NL[
     * @param msg G[bZ[W
     */
    protected void putMessage( HashMap errList, Object key, Object msg){
        if( key != null ){
            putMessage(errList, key);
        }else{
            errList.put(msg, msg);
        }
    }
    
    /**
     * G[R[hǉ܂<BR>
     * G[L[(key)Ŏw肳ꂽbZ[WMessageResourcesCX^X
     * 擾A擾G[bZ[WƃG[L[G[Xgɒǉ܂
     * @param key G[肷邽߂̃j[NL[
     */
    protected void putMessage(HashMap errList, Object key ){
        MessageMappings messages = MessageMappings.getInstance();
        String message = (String)messages.get(key);
        errList.put(key, message);
    }
    
}
