package org.itscool.commons.util;

import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

/**
 * GR[fBOɊւ郆[eBeBNXł
 * @author kano
 */
public class StringUtil {
    
    
    /**
     * ̑Ő(pESp)폜֐
     * @param strData Ώۂ̕
     * @return ̑Ő󔒕폜Ԃ
     */
    public static String trimSpace( String strData ){
        int iStart = 0;
        int iEnd   = 0;
        // ̐擪Sp󔒂łȂJnʒu肷
        for ( iStart=0; iStart < strData.length()-1 ; iStart++ ) {
            if ( ( strData.charAt(iStart) != '@' ) && ( strData.charAt(iStart) != ' ' ) ) break;
        }
        // ̏I[Sp󔒕łȂIʒu肷
        for ( iEnd=strData.length()-1; iEnd>=iStart; iEnd-- ) {
            if ( ( strData.charAt( iEnd ) != '@' ) && ( strData.charAt(iEnd) != ' ' ) )break;
        }
        if( iStart <= iEnd ) {
            // JnʒuIʒu܂ł̕𔲂o
            strData = strData.substring( iStart, iEnd + 1 );
        } else {
            strData = "";
        }
        return strData;
    }
    
    /**
     * Unicode`̕u\\uE16iv`̕ɕϊ܂
     * @param str ϊΏۂƂȂ镶w肵Ă
     * @return u\\uE16iv`̕Ԃ܂
     */
    public static String encodeHex(String str){
        char[] buf1 = str.toCharArray();
        String buf2 = new String("");
        
        for (int i = 0; i < buf1.length; i++) {
            buf2 += "\\u" + (Integer.toString(buf1[i], 16)).toUpperCase();
        }
        return buf2;
    }
    
    /**
     * u\\uE16iv`̕Unicode`̕ɕϊ܂
     * @param unicodeStr ϊΏۂƂȂ镶w肵Ă
     * @return Unicode`̕̕Ԃ܂
     */
    public static String decodeHex(String unicodeStr){
        StringTokenizer st = new StringTokenizer(unicodeStr, "\\u");
        int tokenNum = st.countTokens();
        if(unicodeStr.indexOf("\\u") == -1){
            //HexŖ
            return unicodeStr;
        }
        char[] chars = new char[tokenNum];
        for( int i=0; i<tokenNum; i++ ){
            String str = st.nextToken();
            if( str == null || str.length() == 0 ){
                continue;
            }
            /* 16i쐬 */
            Integer integer = Integer.decode("0x" + str);
            chars[i] = (char)integer.intValue();
        }
        String newStr = new String(chars);
        return newStr;
    }
    
    /**
     * Unicode`̕u\\uE16iv`̕ɕϊ܂
     * @param byteData ϊΏۂƂȂ镶̃oCgf[^w肵Ă
     * @param encode GR[fBOw肵ĉ
     * @return u\\uE16iv`̕Ԃ܂
     */
    public static String encodeHex(byte[] byteData, String encode){
        String str = "";
        try{
            str = new String(byteData, encode);
        }catch(UnsupportedEncodingException uee ){
            uee.printStackTrace();
        }
        char[] buf1 = str.toCharArray();
        String buf2 = new String("");
        
        for (int i = 0; i < buf1.length; i++) {
            buf2 += "\\u" + (Integer.toString(buf1[i], 16)).toUpperCase();
        }
        return buf2;
    }
    
    /**
     * u\\uE16iv`̕Unicode`̕ɕϊ܂
     * @param unicodeStr ϊΏۂƂȂ镶w肵Ă
     * @return Unicode`̕̕Ԃ܂
     */
    public static byte[] decodeHex(String unicodeStr, String encode){
        byte[] byteData = null;
        String strData = decodeHex(unicodeStr);
        try{
            byteData = strData.getBytes("ISO-8859-1");
        }catch(UnsupportedEncodingException uee ){
            return null;
        }
        return byteData;
    }
    
    /**
     * w肳ꂽw肳ꂽGR[fBOɕϊ܂
     * @param str ϊΏۂƂȂ镶w肵Ă
     * @param encode GR[fBOw肵ĉ
     * @return ϊ̕
     */
    public static String convEncode(String str, String encode){
        try{
            str = new String(str.getBytes("ISO-8859-1"), encode);
        }catch(Exception e){
            
        }
        return str;
    }
    
    public static String convEncode(byte[] byteData, String encode){
        String str = new String(byteData);
        try{
            str = new String(byteData, encode);
        }catch(UnsupportedEncodingException uee){
            uee.printStackTrace();
        }
        return str;
    }
    
    
    public static boolean isLowerChar(char c){
        if ( 'a' <= c && c <= 'z'){        //At@xbg
            return true;
        }else{
            return false;
        }
    }
    
    public static boolean isUpperChar(char c){
        if('A' <= c && c <= 'Z' ) {       //啶At@xbg
            return true;
        }else{
            return false;
        }
    }
    
    /**
     * 啶܂܂镶ɕϊAԂ"_"}֐ł<br>
     * ) HelloKitty -> hello_kitty<br>
     * 啶Aꍇ<br>
     * ) HTTPprotocol -> http_protocol
     * 
     */
    public static String cnvUpperNameToUnderScoreName(String str){
        if( str == null || str.length() == 0){
            return str;
        }
        char[] chars  = str.toCharArray();
        StringBuffer sb = new StringBuffer("");
        int len = chars.length;
        //啶AtO
        boolean oomojiRenzokuFg = false;
        for(int i=0; i<len; i++){
            if(i==0){
                sb.append(Character.toLowerCase(chars[i]));
                continue;
            }
            if(Character.isUpperCase(chars[i])){
                //啶ꍇ
                if( (i+1) < len && Character.isUpperCase(chars[i+1])){
                    sb.append(Character.toLowerCase(chars[i]));
                    sb.append(Character.toLowerCase(chars[i+1]));
                    i++;
                    oomojiRenzokuFg = true;
                }else{
                    //啶AĂꍇ
                    if( oomojiRenzokuFg == true ){
                        //啶AtO
                        oomojiRenzokuFg = false;
                        sb.append(Character.toLowerCase(chars[i]));
                        //݂̕ꍇ
                        if( i < len ){
                            sb.append("_");
                        }
                    }else{
                        sb.append("_");
                        sb.append(Character.toLowerCase(chars[i]));
                    }
                }
            }else{
                sb.append(chars[i]);
            }
        }
        return sb.toString();
    }
    
    /**
     * 擪啶ɕϊAA_[XRA(_)܂܂镶񂩂
     * A_[XRAǍɑ1啶ɕϊ܂
     */
    public static String cnvUnderScorNameToUpperName(String str){
        if( str == null || str.length() == 0){
            return str;
        }
        char[] chars  = str.toCharArray();
        StringBuffer sb = new StringBuffer("");
        int len = chars.length;
        for(int i=0; i<len; i++){
            if( i==0 ){
                sb.append(Character.toUpperCase(chars[i]));
                continue;
            }
            if( chars[i] == '_' ){
                if( (i+1) < len ){
                    sb.append(Character.toUpperCase(chars[i+1]));
                    i++;
                }else{
                    sb.append(Character.toLowerCase(chars[i]));
                }
            }else{
                sb.append(Character.toLowerCase(chars[i]));
            }
        }
        return sb.toString();
    }
    
    /**
     * 擪ɕϊAA_[XRA(_)܂܂镶񂩂
     * A_[XRAǍɑ1ɕϊ܂
     */
    public static String cnvUnderScorNameToLowerName(String str){
        if( str == null || str.length() == 0){
            return str;
        }
        char[] chars  = str.toCharArray();
        StringBuffer sb = new StringBuffer("");
        int len = chars.length;
        for(int i=0; i<len; i++){
            if( i==0 ){
                sb.append(Character.toLowerCase(chars[i]));
                continue;
            }
            if( chars[i] == '_' ){
                if( (i+1) < len ){
                    sb.append(Character.toUpperCase(chars[i+1]));
                    i++;
                }else{
                    sb.append(Character.toLowerCase(chars[i]));
                }
            }else{
                sb.append(Character.toLowerCase(chars[i]));
            }
        }
        return sb.toString();
    }
    
    public static void main(String[] argv){
        System.out.println(StringUtil.cnvUpperNameToUnderScoreName("HelloShowActionSuccess"));
        System.out.println(StringUtil.cnvUpperNameToUnderScoreName("HTTPprotocol"));
        
        System.out.println(cnvUnderScorNameToUpperName("hello_good_by"));
        System.out.println(cnvUnderScorNameToUpperName("HELLO_GOOD_BY2"));
        System.out.println(cnvUnderScorNameToLowerName("HELLO_GOOD_BY_TABLE"));
        System.out.println(cnvUnderScorNameToUpperName("h_"));
        System.out.println(cnvUnderScorNameToUpperName("_"));
    }
    
}
