package org.itscool.commons.connection;

import java.util.HashMap;

/**
 * TransactioňʂێNXłB<br>
 * ̃NXێp[^STransaction
 * ʂɂĎ擾ꂽp[^̂PR[hɑ܂
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class Record extends HashMap{
    
    /**
     * p[^nameŎw肳ꂽtB[hl
     * short^Ŏ擾܂B
     * @param name tB[h
     * @return tB[hɃZbgꂽlԂ܂
     */
    public Object getObject(String name){
        if(name ==null || name.length()==0){
            throw new TransactionException("field name is null");
        }
        return get(name.toUpperCase());
    }
    
    /**
     * p[^nameŎw肳ꂽtB[hl
     * short^Ŏ擾܂B
     * @param name tB[h
     * @return tB[hɃZbgꂽlԂ܂
     */
    public boolean getBoolean(String name){
        boolean ret = false;
        if(name ==null || name.length()==0){
            throw new TransactionException("field name is null");
        }
        try{
            Object obj = get(name.toUpperCase());
            if( obj == null ) return ret;
            String str = obj.toString();
            ret = (new Boolean(str)).booleanValue();
        }catch( NumberFormatException nfe ){
            return ret;
        }
        return ret;
    }
    
    /**
     * p[^nameŎw肳ꂽtB[hl
     * short^Ŏ擾܂B
     * @param name tB[h
     * @return tB[hɃZbgꂽlԂ܂
     */
    public byte getByte(String name){
        byte ret = 0;
        if(name ==null || name.length()==0){
            throw new TransactionException("field name is null");
        }
        try{
            Object obj = get(name.toUpperCase());
            if( obj == null ) return ret;
            String str = obj.toString();
            ret = (new Byte(str)).byteValue();
        }catch( NumberFormatException nfe ){
            return ret;
        }
        return ret;
    }
    
    /**
     * p[^nameŎw肳ꂽtB[hl
     * short^Ŏ擾܂B
     * @param name tB[h
     * @return tB[hɃZbgꂽlԂ܂
     */
    public short getShort(String name){
        short ret = 0;
        if(name ==null || name.length()==0){
            throw new TransactionException("field name is null");
        }
        try{
            Object obj = get(name.toUpperCase());
            if( obj == null ) return ret;
            String str = obj.toString();
            ret = (new Short(str)).shortValue();
        }catch( NumberFormatException nfe ){
            return ret;
        }
        return ret;
    }
    
    /**
     * p[^nameŎw肳ꂽtB[hl
     * int^Ŏ擾܂B
     * @param name tB[h
     * @return tB[hɃZbgꂽlԂ܂
     */
    public int getInt(String name){
        int ret = 0;
        if(name ==null || name.length()==0){
            throw new TransactionException("field name is null");
        }
        try{
            Object obj = get(name.toUpperCase());
            if( obj == null ) return ret;
            String str = obj.toString();
            ret = (new Integer(str)).intValue();
        }catch( NumberFormatException nfe ){
            return ret;
        }
        return ret;
    }
    
    /**
     * p[^nameŎw肳ꂽtB[hl
     * long^Ŏ擾܂B
     * @param name tB[h
     * @return tB[hɃZbgꂽlԂ܂
     */
    public long getLong(String name){
        long ret = 0;
        if(name ==null || name.length()==0){
            throw new TransactionException("field name is null");
        }
        try{
            Object obj = get(name.toUpperCase());
            if( obj == null ) return ret;
            String str = obj.toString();
            ret = (new Long(str)).longValue();
        }catch( NumberFormatException nfe ){
            return ret;
        }
        return ret;
    }
    
    /**
     * p[^nameŎw肳ꂽtB[hl
     * String^Ŏ擾܂B
     * @param name tB[h
     * @return tB[hɃZbgꂽlԂ܂
     */
    public float getFloat(String name){
        float ret = 0;
        if(name ==null || name.length()==0){
            throw new TransactionException("field name is null");
        }
        try{
            Object obj = get(name.toUpperCase());
            if( obj == null ) return ret;
            String str = obj.toString();
            ret = (new Float(str)).longValue();
        }catch( NumberFormatException nfe ){
            return ret;
        }
        return ret;
    }
    
    /**
     * p[^nameŎw肳ꂽtB[hl
     * double^Ŏ擾܂B
     * @param name tB[h
     * @return tB[hɃZbgꂽlԂ܂
     */
    public double getDouble(String name){
        double ret = 0.0;
        if(name ==null || name.length()==0){
            throw new TransactionException("field name is null");
        }
        try{
            Object obj = get(name.toUpperCase());
            if( obj == null ) return ret;
            String str = obj.toString();
            ret = (new Double(str)).doubleValue();
        }catch( NumberFormatException nfe ){
            return ret;
        }
        return ret;
    }
    
    /**
     * p[^nameŎw肳ꂽtB[hl
     * String^Ŏ擾܂B
     * @param name tB[h
     * @return tB[hɃZbgꂽlԂ܂
     */
    public String getString(String name){
        String ret = null;
        if(name ==null || name.length()==0){
            throw new TransactionException("field name is null");
        }
        Object obj = get(name.toUpperCase());
        if( obj == null ) return ret;
        ret = obj.toString();
        
        return ret;
    }
    
    /**
     * p[^nameŎw肳ꂽtB[hl
     * Date^Ŏ擾܂B
     * @param name tB[h
     * @return tB[hɃZbgꂽlԂ܂
     */
    public java.util.Date getDate(String name){
        if(name ==null || name.length()==0){
            throw new TransactionException("field name is null");
        }
        java.sql.Date ret = (java.sql.Date)get(name.toUpperCase());
        if( ret == null )return null;
        java.util.Date date = new java.util.Date(ret.getTime());
        return date;
    }
}
