package test.org.itscool.weber.io;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.itscool.commons.document.XmlConfigReader;
import org.itscool.weber.io.ActionConfigReader;
import org.itscool.weber.mapping.ActionMapping;

/**
 * @author kano
 */
public class ActionConfigReaderTest  extends TestCase{
    public void testCreateActionConfigReader(){
        XmlConfigReader reader = new ActionConfigReader();;
        if( reader == null ){
            fail("reader is null");
            return;
        }
        if( !(reader instanceof ActionConfigReader) ){
            fail("instance is not ActionConfigReader");
        }
    }
    
    public void testCreateMap(){
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        URL weberUrl = parent.getResource("test/org/itscool/weber/io/test-config1.xml");
        HashMap map = new HashMap();
        String path = weberUrl.getPath();
        
        XmlConfigReader actionReader = new ActionConfigReader();
        
        
        //creatẽeXg
        if( actionReader == null ){
            fail("reader is null");
            return;
        }
        if( !(actionReader instanceof ActionConfigReader) ){
            fail("instance is not ActionConfigReader");
        }
        
        //ActionMappingcreateeXg
        try{
            actionReader.create(path, map);
        }catch( IOException ioe ){
            fail(ioe.getMessage());
        }
        
        //index.doɊւ̌
        ActionMapping action1 = (ActionMapping)map.get("index.do");
        if( action1 == null ){
            fail("index.do's ActionMapping is null");
        }
        if( !action1.getType().equals("org.itscool.weber.action.NoOpAction")){
            fail("index.do's type is matched");
        }
        if( !action1.getForward("success").equals("/jsp/login.jsp") ){
            fail("index.do's forward[success] is matched");
        }
        
        //index.dorolě
        HashMap roles = action1.getRoles();
        String guest = (String)roles.get("guest");
        if( !guest.equals("guest") ){
            fail("/top/login.do's role is not match [" + guest + "]");
        }
        String admin = (String)roles.get("admin");
        if( !admin.equals("admin") ){
            fail("/top/login.do's role is not match [" + admin + "]");
        }
        
        ///top/login.doɊւ̌
        ActionMapping action2 = (ActionMapping)map.get("/top/login.do");
        if( action2 == null ){
            fail("/top/login.do's ActionMapping is null");
        }
        if( !action2.getType().equals("org.itscool.weber.action.LoginAction")){
            fail("/top/login.do's type is matched");
        }
        if( !action2.getName().equals("org.itscool.weber.user.User")){
            fail("/top/login.do's name is matched");
        }
        
    }
    
    /**
     * ̒`t@CǍރeXg
     */
    public void testCreateMap2(){
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        URL weberUrl = parent.getResource("test/org/itscool/weber/io/test-config1.xml");
        URL weberUrl2 = parent.getResource("test/org/itscool/weber/io/test-config2.xml");
        
        HashMap map = new HashMap();
        String path = weberUrl.getPath();
        String path2 = weberUrl2.getPath();
        XmlConfigReader actionReader = new ActionConfigReader();
        
        //ActionMappingcreateeXg
        try{
            actionReader.create(path, map);
            actionReader.create(path2, map);
        }catch( IOException ioe ){
            fail(ioe.getMessage());
        }
        
        //index.doɊւ̌
        ActionMapping action1 = (ActionMapping)map.get("index.do");
        if( action1 == null ){
            fail("index.do's ActionMapping is null");
        }
        if( !action1.getType().equals("org.itscool.weber.action.NoOpAction")){
            fail("index.do's type is matched");
        }
        if( !action1.getForward("success").equals("/jsp/login.jsp") ){
            fail("index.do's forward[success] is matched");
        }
        
        //index.dorolě
        HashMap roles = action1.getRoles();
        String guest = (String)roles.get("guest");
        if( !guest.equals("guest") ){
            fail("/top/login.do's role is not match [" + guest + "]");
        }
        String admin = (String)roles.get("admin");
        if( !admin.equals("admin") ){
            fail("/top/login.do's role is not match [" + admin + "]");
        }
        
        ///top/login.doɊւ̌
        ActionMapping action2 = (ActionMapping)map.get("/top/login.do");
        if( action2 == null ){
            fail("/top/login.do's ActionMapping is null");
        }
        if( !action2.getType().equals("org.itscool.weber.action.LoginAction")){
            fail("/top/login.do's type is matched");
        }
        if( !action2.getName().equals("org.itscool.weber.user.User")){
            fail("/top/login.do's name is matched");
        }
        
        ///regist/input.dǒ
        ActionMapping regstViewAction = (ActionMapping)map.get("/regist/input.do");
        if( regstViewAction == null ){
            fail("/regist/input.do's ActionMapping is null");
        }
        if( !regstViewAction.getType().equals("org.itscool.weber.test.InputAction")){
            fail("/regist/input.do's type is matched "+regstViewAction.getType());
        }
        if( !regstViewAction.getName().equals("org.itscool.weber.test.InputForm")){
            fail("/regist/input.do's name is matched "+regstViewAction.getName());
        }
        if( !regstViewAction.getForward("success").equals("/jsp/input.jsp") ){
            fail("/regist/input.do's forward[success] is matched "+regstViewAction.getForward("success"));
        }
    }
    
    public void testCreateMapFail(){
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        URL weberUrl = parent.getResource("test/org/itscool/weber/io/test-config1.xml");
        HashMap map = new HashMap();
        String path = weberUrl.getPath();
        XmlConfigReader reader= new ActionConfigReader();;
        
        try{
            reader.create(path, map);
        }catch(IOException ioe){
            //Ӑ}OLb`
            //System.out.println("Ӑ}OLb`["+ ioe.getMessage() + "]");
        }catch( Exception e){
            fail("Ӑ}ȂException⑫[" + e.getMessage() + "]");
        }
        
//        if( map.size() != 0 ){
//            fail("݂Ă size=" + map.size());
//        }
    }
    
    public void testCreateMapFail2(){
        HashMap map = new HashMap();
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        URL weberUrl = parent.getResource("test/org/itscool/weber/io/test-failconfig2.xml");
        String path = weberUrl.getPath();
        XmlConfigReader reader= new ActionConfigReader();;
        
        try{
            reader.create(path, map);
        }catch(IOException ioe){
            //Ӑ}OLb`
            //System.out.println("Ӑ}OLb`["+ ioe.getMessage() + "]");
        }catch( Exception e){
            fail("Ӑ}ȂException⑫[" + e.getMessage() + "]");
        }
        
        if( map.size() != 0 ){
            fail("݂Ă");
        }
    }
    
    public void testCreateMapFail3(){
        HashMap map = new HashMap();
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        URL weberUrl = parent.getResource("test/org/itscool/weber/io/test-failconfig3.xml");
        String path = weberUrl.getPath();
        XmlConfigReader reader= new ActionConfigReader();;
        
        try{
            reader.create(path, map);
        }catch(IOException ioe){
            //Ӑ}OLb`
            //System.out.println("Ӑ}OLb`["+ ioe.getMessage() + "]");
        }catch( Exception e){
            fail("Ӑ}ȂException⑫[" + e.getMessage() + "]");
        }
        
        if( map.size() != 0 ){
            fail("݂Ă");
        }
    }
    
    public static Test suite() {
        return new TestSuite(ActionConfigReaderTest.class);
    }
}
