package test.org.itscool.commons.util;

import junit.framework.TestCase;

import org.itscool.commons.util.NumberFormatUtil;

public class NumberFormatUtilTest extends TestCase{
	public void testEncodeMoneyString(){
		assertEquals("\\99,999" , NumberFormatUtil.encodeMoneyString("99999"));
//		System.out.println(NumberFormatUtil.encodeMoneyString("99999"));
	}
	
	public void testEncodeMoneyString2(){
		assertEquals("\\100.2", NumberFormatUtil.encodeMoneyString("100.2"));
	}
	
	public void testEncodeMoneyFail(){
		assertEquals("aaa", NumberFormatUtil.encodeMoneyString("aaa"));
	}
	
	public void testEncodeMoneyFail2(){
		assertEquals(null, NumberFormatUtil.encodeMoneyString(null));
	}
	
	public void testEncodeMoneyString3(){
		assertEquals("\\1,234", NumberFormatUtil.encodeMoneyString("1234"));
	}
	
	public void testEncodeMoneyString4(){
		assertEquals("\\123,456,789", NumberFormatUtil.encodeMoneyString("123456789"));
	}
	
	public void testEncodeMoneyString5(){
		assertEquals("\\123,456,789.1234567", NumberFormatUtil.encodeMoneyString("123456789.1234567"));
	}
	
	public void testDecodeMoneyString(){
		assertEquals("9999", NumberFormatUtil.decodeMoneyString("\\9,999"));
	}
	
	public void testDecodeMoneyString2(){
		assertEquals("9999999999.999", NumberFormatUtil.decodeMoneyString("\\9,999,999,999.999"));
	}
	
	public void testConvZeroPadding(){
		assertEquals("0100", NumberFormatUtil.convZeroPadding(100, 4));
	}
	
	public void testConvZeroPadding2(){
		assertEquals("0000000100", NumberFormatUtil.convZeroPadding(100, 10));
	}
	
	public void testConvZeroPadding3(){
		assertEquals("100", NumberFormatUtil.convZeroPadding(100, 2));
			
		
	}
}
