package test.org.itscool.commons.dao3;

import java.util.List;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.PreparedStatementWrapper;
import org.itscool.weber.testcase.WeberDbTestCase;

public class DataTypeDaoTest extends WeberDbTestCase{
    public void setUp(){
        try{
            this.clearTables();
            this.initTables("test/org/itscool/commons/dao3/test-db-data.xml");
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    
    public void testInsert(){
        DataTypeBean bean = new DataTypeBean();
        byte[] byteArray = new byte[2];
        byteArray[0] = 10;
        byteArray[1] = 20;
        
        bean.setId(1);
        bean.setByteArray(byteArray);
        
        String sql = "insert into DATA_TYPE_BEAN (ID, BYTE_ARRAY) values (?, ?)";
        PreparedStatementWrapper mapper = TransactionUtil.getPreparedStatementWrapper(sql);
        mapper.setValue(1, bean.getId());
        mapper.setValue(2, byteArray);
        int result = 0;
        try{
            result = mapper.executeUpdate();
        }catch(Exception e){
            e.printStackTrace();
            fail(e.getMessage());
        }
        assertEquals("insert num", 1, result);
        
    }
    
    public void testSelect(){
        DataTypeBean bean = new DataTypeBean();
        byte[] byteArray = new byte[2];
        byteArray[0] = 30;
        byteArray[1] = 40;
        
        bean.setId(2);
        bean.setByteArray(byteArray);
        
        String sql = "insert into DATA_TYPE_BEAN (ID, BYTE_ARRAY) values (?, ?)";
        PreparedStatementWrapper mapper = TransactionUtil.getPreparedStatementWrapper(sql);
        mapper.setValue(1, bean.getId());
        mapper.setValue(2, byteArray);
        int result = 0;
        try{
            result = mapper.executeUpdate();
        }catch(Exception e){
            e.printStackTrace();
            fail(e.getMessage());
        }
        TransactionUtil.commitTransaction();
        
        String sql2 = "select * from DATA_TYPE_BEAN";
        PreparedStatementWrapper mapper2 = TransactionUtil.getPreparedStatementWrapper(sql2);
        try{
            List list = mapper2.select(DataTypeBean.class);
            assertEquals("select num", 1, list.size());
            DataTypeBean bean2 = (DataTypeBean)list.get(0);
            byte[] byteData = bean2.getByteArray();
            assertEquals("byte1", 30, byteData[0]);
            assertEquals("byte2", 40, byteData[1]);
            
        }catch(Exception e){
            e.printStackTrace();
            fail(e.getMessage());
        }
    }
    
}
