/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.bean;

import [Ljava.lang.Boolean;;
import [Ljava.lang.Byte;;
import [Ljava.lang.Double;;
import [Ljava.lang.Float;;
import [Ljava.lang.Integer;;
import [Ljava.lang.Long;;
import [Ljava.lang.Object;;
import [Ljava.lang.Short;;
import [Ljava.lang.String;;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.itscool.commons.bean.BeanUtilRuntimeException;

public class BeanUtil {
    public static Object getInstance(String className) {
        Object obj = null;
        try {
            Class<?> cls = Class.forName(className);
            Method method = cls.getMethod("getInstance", null);
            obj = method.invoke(null, null);
        }
        catch (Exception e) {
            String err = "[" + className + ":" + "getInstance" + "]" + "getProperty() failed (" + BeanUtil.class.getName() + ") (" + e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        return obj;
    }

    public static Object createInstance(String className) throws BeanUtilRuntimeException {
        Object obj = null;
        try {
            Class<?> cls = Class.forName(className);
            obj = cls.newInstance();
        }
        catch (InstantiationException ie) {
            String err = "[" + className + "]" + "InstantiationException (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        catch (IllegalAccessException iae) {
            String err = "[" + className + "]" + "IllegalAccessExceptio (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        catch (ClassNotFoundException cnfe) {
            String err = "[" + className + "]" + "ClassNotFoundException (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        catch (Exception e) {
            String err = "[" + className + "]" + e.getClass().getName() + " (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        return obj;
    }

    public static Object createInstance(String className, String[] argTypes, Object[] argValues) throws BeanUtilRuntimeException {
        Object obj = null;
        try {
            Class<?> cls = Class.forName(className);
            Class[] arg_classes = new Class[argTypes.length];
            for (int i = 0; i < argTypes.length; ++i) {
                arg_classes[i] = Class.forName(argTypes[i]);
            }
            Constructor<?> constructor = cls.getConstructor(arg_classes);
            obj = constructor.newInstance(argValues);
        }
        catch (InstantiationException ie) {
            String err = "[" + className + "]" + "InstantiationException (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        catch (ClassNotFoundException cnfe) {
            String err = "[" + className + "]" + "ClassNotFoundException (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        catch (IllegalAccessException iae) {
            String err = "[" + className + "]" + "IllegalAccessExceptio (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        catch (NoSuchMethodException e) {
            String err = "[" + className + "]" + "NoSuchMethodException (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        catch (InvocationTargetException e) {
            String err = "[" + className + "]" + "InvocationTargetException (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        catch (Exception e) {
            String err = "[" + className + "]" + e.getClass().getName() + " (" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        return obj;
    }

    public static int getIntValue(Object obj, String propertyName) throws BeanUtilRuntimeException {
        int value = (Integer)BeanUtil.getProperty(obj, propertyName);
        return value;
    }

    public static long getLongValue(Object obj, String propertyName) throws BeanUtilRuntimeException {
        long value = (Long)BeanUtil.getProperty(obj, propertyName);
        return value;
    }

    public static double getDoubleValue(Object obj, String propertyName) throws BeanUtilRuntimeException {
        double value = (Double)BeanUtil.getProperty(obj, propertyName);
        return value;
    }

    public static float getFloatValue(Object obj, String propertyName) throws BeanUtilRuntimeException {
        float value = ((Float)BeanUtil.getProperty(obj, propertyName)).floatValue();
        return value;
    }

    public static short getShortValue(Object obj, String propertyName) throws BeanUtilRuntimeException {
        short value = (Short)BeanUtil.getProperty(obj, propertyName);
        return value;
    }

    public static boolean getBooleanValue(Object obj, String propertyName) throws BeanUtilRuntimeException {
        boolean value = (Boolean)BeanUtil.getProperty(obj, propertyName);
        return value;
    }

    public static Object getProperty(Object obj, String propertyName) throws BeanUtilRuntimeException {
        Object[] property = null;
        String getterName = BeanUtil.getGetterName(propertyName);
        if (getterName == null) {
            return null;
        }
        try {
            Method method = obj.getClass().getMethod(getterName, null);
            if (method.getReturnType().isArray()) {
                if (method.getReturnType().isAssignableFrom(Object;.class)) {
                    Object[] collection;
                    property = collection = (Object[])method.invoke(obj, null);
                } else if (method.getReturnType().isAssignableFrom(Byte;.class)) {
                    Byte[] collection = (Byte[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom([B.class)) {
                    byte[] collection = (byte[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom(Integer;.class)) {
                    Integer[] collection = (Integer[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom([I.class)) {
                    int[] collection = (int[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom(Short;.class)) {
                    Short[] collection = (Short[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom([S.class)) {
                    short[] collection = (short[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom(Long;.class)) {
                    Long[] collection = (Long[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom([J.class)) {
                    long[] collection = (long[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom(Double;.class)) {
                    Double[] collection = (Double[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom([D.class)) {
                    double[] collection = (double[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom(Float;.class)) {
                    Float[] collection = (Float[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom([F.class)) {
                    float[] collection = (float[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom(Boolean;.class)) {
                    Boolean[] collection = (Boolean[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom([Z.class)) {
                    boolean[] collection = (boolean[])method.invoke(obj, null);
                    property = collection;
                } else if (method.getReturnType().isAssignableFrom(String;.class)) {
                    String[] collection = (String[])method.invoke(obj, null);
                    property = collection;
                } else {
                    Object[] collection;
                    property = collection = (Object[])method.invoke(obj, null);
                }
            } else {
                property = method.invoke(obj, null);
            }
        }
        catch (Exception e) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + "getProperty() failed (" + BeanUtil.class.getName() + ") (" + e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        return property;
    }

    public static Object setProperty(Object obj, String propertyName, Object property) {
        Class[] propertyTypes = new Class[1];
        Method chkMethod = BeanUtil.getMethod(obj, propertyName);
        if (chkMethod == null) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "\u3000no getterMethod]" + "setProperty() failed(" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        propertyTypes[0] = chkMethod.getReturnType();
        String setterName = BeanUtil.getSetterName(propertyName);
        if (setterName == null) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "\u3000no setterMethod]" + "setProperty() failed(" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        try {
            Method method = obj.getClass().getMethod(setterName, propertyTypes);
            Object[] properties = null;
            property = BeanUtil.getNullData(property, chkMethod.getReturnType().getName());
            if (property == null) {
                return property;
            }
            if (chkMethod.getReturnType().equals(Integer.TYPE) || chkMethod.getReturnType().equals(Integer.class)) {
                properties = new Integer[1];
                if (property == null || property.toString().length() == 0) {
                    properties[0] = new Integer(0);
                } else {
                    try {
                        properties[0] = Integer.valueOf(property.toString());
                    }
                    catch (NumberFormatException e) {
                        double chkDbl = Double.parseDouble(property.toString());
                        int chkInt = (int)chkDbl;
                        properties[0] = new Integer(chkInt);
                    }
                }
            } else if (chkMethod.getReturnType().equals(Long.TYPE) || chkMethod.getReturnType().equals(Long.class)) {
                properties = new Long[1];
                if (property == null || property.toString().length() == 0) {
                    properties[0] = new Long(0L);
                } else {
                    try {
                        properties[0] = Long.valueOf(property.toString());
                    }
                    catch (NumberFormatException e) {
                        double chkDbl = Double.parseDouble(property.toString());
                        long chkInt = (long)chkDbl;
                        properties[0] = new Long(chkInt);
                    }
                }
            } else if (chkMethod.getReturnType().equals(Double.TYPE) || chkMethod.getReturnType().equals(Double.class)) {
                properties = new Double[1];
                properties[0] = property == null || property.toString().length() == 0 ? new Double(0.0) : Double.valueOf(property.toString());
            } else if (chkMethod.getReturnType().equals(Float.TYPE) || chkMethod.getReturnType().equals(Float.class)) {
                properties = new Float[1];
                properties[0] = property == null || property.toString().length() == 0 ? new Float(0.0f) : Float.valueOf(property.toString());
            } else if (chkMethod.getReturnType().equals(Short.TYPE) || chkMethod.getReturnType().equals(Short.class)) {
                properties = new Short[1];
                if (property == null || property.toString().length() == 0) {
                    properties[0] = new Short("0");
                } else {
                    try {
                        properties[0] = Short.valueOf(property.toString());
                    }
                    catch (NumberFormatException e) {
                        double chkDbl = Double.parseDouble(property.toString());
                        short chkInt = (short)chkDbl;
                        properties[0] = new Short(chkInt);
                    }
                }
            } else if (chkMethod.getReturnType().equals(Boolean.TYPE) || chkMethod.getReturnType().equals(Boolean.class)) {
                properties = new Boolean[1];
                properties[0] = property == null || property.toString().length() == 0 ? new Boolean(false) : (property.equals("on") ? new Boolean(true) : Boolean.valueOf(property.toString()));
            } else {
                properties = new Object[]{property};
            }
            method.invoke(obj, properties);
        }
        catch (NoSuchMethodException e) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + "setProperty() failed(" + BeanUtil.class.getName() + ") (" + e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        catch (IllegalAccessException e) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + "setProperty() failed(" + BeanUtil.class.getName() + ") (" + e.getMessage() + ") value = " + property;
            throw new BeanUtilRuntimeException(err);
        }
        catch (InvocationTargetException e) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + "setProperty() failed(" + BeanUtil.class.getName() + ") (" + e.getMessage() + ") value = " + property;
            throw new BeanUtilRuntimeException(err);
        }
        catch (Exception e) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + e.getClass().getName() + " (" + BeanUtil.class.getName() + ") value = " + property;
            throw new BeanUtilRuntimeException(err);
        }
        return property;
    }

    public static Class getReturnType(Object obj, String propertyName) throws BeanUtilRuntimeException {
        Class[] propertyTypes = new Class[1];
        Method chkMethod = BeanUtil.getMethod(obj, propertyName);
        if (chkMethod == null) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "\u3000no getterMethod]" + "setProperty() failed(" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        propertyTypes[0] = chkMethod.getReturnType();
        String setterName = BeanUtil.getSetterName(propertyName);
        if (setterName == null) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "\u3000no setterMethod]" + "setProperty() failed(" + BeanUtil.class.getName() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        try {
            return chkMethod.getReturnType();
        }
        catch (Exception e) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + "setProperty() failed(" + BeanUtil.class.getName() + ") (" + e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }
    }

    private static Object getNullData(Object property, String clazzType) {
        Object ret;
        if (property != null) {
            return property;
        }
        if (clazzType.equals(Integer.TYPE.getName()) || clazzType.equals(Long.TYPE.getName()) || clazzType.equals(Double.TYPE.getName()) || clazzType.equals(Float.TYPE.getName())) {
            ret = new Integer("0");
        } else if (clazzType.equals(Boolean.TYPE.getName())) {
            ret = new Boolean("false");
        } else if (clazzType.equals(String.class.getName())) {
            ret = new String("");
        } else {
            return null;
        }
        return ret.toString();
    }

    public static String getGetterName(String propertyName) {
        String methodName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1, propertyName.length());
        methodName = "get" + methodName;
        return methodName;
    }

    public static String getSetterName(String propertyName) {
        String methodName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1, propertyName.length());
        methodName = "set" + methodName;
        return methodName;
    }

    private static Method getMethod(Object obj, String propertyName) throws BeanUtilRuntimeException {
        Method method = null;
        String getterName = BeanUtil.getGetterName(propertyName);
        if (getterName == null) {
            return null;
        }
        try {
            method = obj.getClass().getMethod(getterName, null);
        }
        catch (Exception e) {
            String err = "[" + obj.getClass().getName() + ":" + propertyName + "]" + "getMethod() failed (" + BeanUtil.class.getName() + ") (" + e.getMessage() + ")";
            throw new BeanUtilRuntimeException(err);
        }
        return method;
    }

    public static Object copyInstance(Object dst, String srcClassName) {
        Object src = BeanUtil.createInstance(srcClassName);
        Field[] fields = src.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifier = field.getModifiers();
            if (2 != modifier && 4 != modifier) continue;
            String propertyName = field.getName();
            Field chkField = null;
            chkField = BeanUtil.getField(dst.getClass(), propertyName);
            if (chkField == null) continue;
            Object property = BeanUtil.getProperty(dst, propertyName);
            BeanUtil.setProperty(src, propertyName, property);
        }
        return src;
    }

    public static Field getField(Class clazz, String propertyName) {
        Field chkField = null;
        try {
            chkField = clazz.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException nsfe) {
            // empty catch block
        }
        if (chkField == null) {
            Class superClazz = clazz.getSuperclass();
            if (superClazz == null) {
                return null;
            }
            chkField = BeanUtil.getField(superClazz, propertyName);
        }
        return chkField;
    }

    public static Object invoke(String className, String funcName, Object[] args) {
        try {
            Class<?> cls = Class.forName(className);
            Object obj = cls.newInstance();
            Method method = BeanUtil.findMethod(cls, funcName, args);
            Object result = method.invoke(obj, args);
            return result;
        }
        catch (Exception r) {
            throw new BeanUtilRuntimeException("Failed invoke class:" + className + ", funcName:" + funcName + ", err:" + r.getMessage());
        }
    }

    public static Method findMethod(Class clazz, String funcName, Object[] args) throws Exception {
        Method[] methods = clazz.getMethods();
        int size = methods.length;
        for (int i = 0; i < size; ++i) {
            Class<?>[] types;
            Method method = methods[i];
            if (!method.getName().equals(funcName) || (types = method.getParameterTypes()).length != args.length) continue;
            int typeSize = types.length;
            boolean ret = true;
            for (int j = 0; j < typeSize; ++j) {
                Class<?> type = types[j];
                Object arg = args[j];
                if (type.isPrimitive()) {
                    Constable value;
                    if (type.equals(Integer.TYPE)) {
                        try {
                            value = new Integer(arg.toString());
                            args[j] = value;
                            continue;
                        }
                        catch (Exception e) {
                            ret = false;
                            break;
                        }
                    }
                    if (type.equals(Long.TYPE)) {
                        try {
                            value = new Long(arg.toString());
                            args[j] = value;
                            continue;
                        }
                        catch (Exception e) {
                            ret = false;
                            break;
                        }
                    }
                    if (type.equals(Double.TYPE)) {
                        try {
                            value = new Double(arg.toString());
                            args[j] = value;
                            continue;
                        }
                        catch (Exception e) {
                            ret = false;
                            break;
                        }
                    }
                    if (type.equals(Float.TYPE)) {
                        try {
                            value = new Float(arg.toString());
                            args[j] = value;
                            continue;
                        }
                        catch (Exception e) {
                            ret = false;
                            break;
                        }
                    }
                    if (type.equals(Short.TYPE)) {
                        try {
                            value = new Short(arg.toString());
                            args[j] = value;
                            continue;
                        }
                        catch (Exception e) {
                            ret = false;
                            break;
                        }
                    }
                    if (type.equals(Byte.TYPE)) {
                        try {
                            value = new Byte(arg.toString());
                            args[j] = value;
                            continue;
                        }
                        catch (Exception e) {
                            ret = false;
                            break;
                        }
                    }
                    if (!type.equals(Boolean.TYPE)) continue;
                    try {
                        value = new Boolean(arg.toString());
                        args[j] = value;
                        continue;
                    }
                    catch (Exception e) {
                        ret = false;
                        break;
                    }
                }
                if (arg == null || type.isInstance(arg)) continue;
                ret = false;
                break;
            }
            if (!ret) continue;
            return method;
        }
        return null;
    }

    public static String supressQuate(String str) {
        if (str.indexOf("\"") == 0 && str.lastIndexOf("\"") == str.length() - 1) {
            return str.substring(1, str.length() - 1);
        }
        if (str.indexOf("'") == 0 && str.lastIndexOf("'") == str.length() - 1) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static boolean isJavaType(Class type) {
        String name = type.getName();
        if (name.equals("byte")) {
            return true;
        }
        if (name.equals("short")) {
            return true;
        }
        if (name.equals("boolean")) {
            return true;
        }
        if (name.equals("int")) {
            return true;
        }
        if (name.equals("long")) {
            return true;
        }
        if (name.equals("double")) {
            return true;
        }
        if (name.equals("float")) {
            return true;
        }
        if (name.equals("char")) {
            return true;
        }
        if (name.equals("java.lang.Byte")) {
            return true;
        }
        if (name.equals("java.lang.Short")) {
            return true;
        }
        if (name.equals("java.lang.Boolean")) {
            return true;
        }
        if (name.equals("java.lang.Double")) {
            return true;
        }
        if (name.equals("java.lang.Float")) {
            return true;
        }
        if (name.equals("java.lang.Character")) {
            return true;
        }
        if (name.equals("java.lang.String")) {
            return true;
        }
        if (name.equals("java.lang.Integer")) {
            return true;
        }
        if (name.equals("java.lang.Long")) {
            return true;
        }
        return name.equals("java.util.Date");
    }

    public static boolean isPrimitive(String value) {
        boolean ret = false;
        if (value == null) {
            return ret;
        }
        try {
            Long.parseLong(value);
            return true;
        }
        catch (Exception e) {
            try {
                Double.parseDouble(value);
                return true;
            }
            catch (Exception e2) {
                try {
                    if (value.equals("true") || value.equals("false")) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ret;
            }
        }
    }
}

