/*
 * 쐬: 2005/07/18
 * 쐬: KANO
 */
package org.itscool.weber.user;

import java.util.List;

import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;

/**
 * UserIuWFNg̃f[^ANZXpNXł
 *
 * @author KANO
 * @version 1.00
 */
public class UserDao extends BaseDao {
    
    /**
     * e[uS[U擾܂
     * @return [ÜꗗListŕԂ܂
     */
    public List getAllData(){
        Criteria crt = new Criteria(User.class);
        List lst = select(crt);
        return lst;
    }
    
    /**
     * w肳ꂽ[Ũ[U擾܂
     * @param name [U
     * @return User [U
     */
    public User getUser(Role role, String name){
        Criteria crt = new Criteria(User.class);
        crt.eq(User.TABLE+"."+User.COLUM_name, name);
        crt.and();
        crt.eq(Role.TABLE+"."+Role.PK_COLUM_id, role.getId());
        
        List lst = select(crt);
        if(lst != null && lst.size() > 0){
            return (User)lst.get(0);
        }else{
            return null;
        }
    }
    
    /**
     * w肳ꂽ[Ũ[U擾܂
     * @param name [U
     * @return User [U
     */
    public User getUser(String roleName, String name){
        Criteria crt = new Criteria(User.class);
        crt.eq(User.TABLE+"."+User.COLUM_name, name);
        crt.and();
        crt.eq(Role.TABLE+"."+Role.COLUM_name, roleName);
        
        List lst = select(crt);
        if(lst != null && lst.size() > 0){
            return (User)lst.get(0);
        }else{
            return null;
        }
    }
    
    /**
     * w肳ꂽ[Ũ[U擾܂
     * @param id [UID
     * @return User [U
     */
    public User getUser(int id){
        Criteria crt = new Criteria(User.class);
        crt.eq(User.TABLE+"."+User.PK_COLUM_id, id);
        
        List lst = select(crt);
        if(lst != null && lst.size() > 0){
            return (User)lst.get(0);
        }else{
            return null;
        }
    }
    /**
     * w肳ꂽ[U[ŨXg擾܂
     * @param name [U
     * @return [ŨXg
     */
    public List getUsers(String name){
        Criteria crt = new Criteria(User.class);
        crt.eq(User.TABLE+"."+User.COLUM_name, name);
        
        List lst = select(crt);
        return lst;
    }
    
    /**
     * w肳ꂽ[ŨXg擾܂
     * @param role 
     * @return [ŨXg
     */
    public List getUsers(Role role){
        Criteria crt = new Criteria(User.class);
        crt.eq(User.TABLE+"."+User.COLUM_roleId, role.getId());
        
        List lst = select(crt);
        return lst;
    }
    
    /**
     * [UINSERTs܂
     * @param user [U
     * @return Integer o^̎L[lԂ
     */
    public int save(User user){
        Criteria crt = new Criteria(User.class);
        int id = getNewId(User.TABLE, User.PK_COLUM_id);
        user.setId(id);
        
        this.insert(crt, user);
        return id;
    }
    
    /**
     * [UUPDATEs܂
     * @param user [U
     */
    public void update(User user){
        Criteria crt = new Criteria(User.class);
        crt.eq(User.TABLE+"."+User.PK_COLUM_id, user.getId());
        crt.and();
        crt.eq(User.TABLE+"."+User.COLUM_roleId, user.getRoleId());
        
        this.update(crt, user);
    }
    
    /**
     * [UDELETEs܂
     * @param user [U
     */
    public void delete(User user){
        Criteria crt = new Criteria(User.class);
        crt.eq(User.TABLE + "." + User.PK_COLUM_id, user.getId());
        crt.and();
        crt.eq(User.TABLE+"."+User.COLUM_roleId, user.getRoleId());
        
        this.delete(crt);
        
//		String line = System.getProperty("line.separator");
//		StringBuffer sb = new StringBuffer();
//		sb.append("DELETE FROM ").append(User.TABLE).append(line);
//		sb.append("WHERE ").append(line).append("    ");
//		sb.append(User.COLUM_name).append("='").append(user.getName()).append("'").append(line);
//		sb.append("    AND ");
//		sb.append(User.COLUM_roleId).append("=").append(user.getRoleId()).append(line);
//		this.getTransaction().execute(sb.toString());
    }
    
}
