package org.itscool.weber.testcase;

import java.net.URL;
import junit.framework.TestCase;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.weber.action.Action;
import org.itscool.weber.controller.Globals;
import org.itscool.weber.user.RoleException;
import org.itscool.weber.user.User;

/**
 * <p>
 * JUnitgWebert[[NpeXgNXł<br/>
 * </p>
 *
 * <p>
 * WeberTestCaseNX́Aorg.itscool.weber.action.ActionNX
 * pč쐬ꂽANVNXdoExecute()\bh
 * doValidate()\bh̒P̃eXgs߂̒ۃeXgNXł<br/>
 * </p>
 *
 * <p>
 * ̃NX̓Reiˑł邽߁AJUnitCuJava̎s
 * ΁AP̃eXg̎{\łB<br/>
 * ȉɃeXgP[X̃Tv܂B<br/>
 * </p>
 *
 * <p>eXgP[X̃Tv<hr></p>
 * <PRE>
 * import org.itscool.weber.testcase.WeberTestCase;
 *
 * public class TestSampleAction extends WeberTestCase{
 *     public void testDoExecute(){
 *         //NCAg|XgꂽʐtH[
 *         //CX^X𐶐܂
 *         SampleForm form = new SampleForm();
 *         form.setId(1);
 *         form.setName("hogehoge");
 *
 *         //WeberTestCaseNXɂ́AÖكIuWFNgƂ
 *         //MockActionBucketCX^X񋟂Ă܂B
 *         //̃CX^XɐقǍ쐬tH[CX
 *         //^XZbg܂B
 *         bucket.setForm(form);
 *
 *         //eXgΏۂƂȂANVCX^X𐶐܂
 *         SampleAction action = new SampleAction();
 *
 *         //ANVNXdoExecute؂܂
 *         assertDoExecute(action, form, "success");
 *     }
 *
 *     public void testDoValidate(){
 *         //doValidate()؂ꍇrequestIuWFNgɃp[^
 *         //ZbgȂ΂Ȃ܂B
 *         //̏ꍇ́AMockPostGereralFormCX^Xgp܂B
 *         //WeberTestCaseNXɂ́AÖكIuWFNgƂ
 *         //requestCX^Xgp邱Ƃł܂B
 *         request.addParameter("id", "lȊÕIuWFNgZbg");
 *
 *         //eXgΏۂƂȂANVCX^X𐶐܂
 *         SampleAction action = new SampleAction();
 *
 *         //ANVNXdoValidate\bh؂܂
 *         assertValidate(action, "org.itscool.weber.INPUT_ERROR");
 *     }
 * }
 * </PRE>
 *
 * <p>
 * WeberTestCase𗘗peXgsꍇAʓrJUnitNXCu
 * Kvł
 * </p>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2005/08/01
 */
public abstract class WeberTestCase extends TestCase{
    
    protected BeanFactory factory = BeanFactory.getInstance();
    /**
     * ActionBucket̃bNIuWFNg𐶐
     */
    protected MockActionBucket bucket = new MockActionBucket();
    /**
     * AbstractPostRequest̃bNIuWFNg𐶐
     */
    protected MockGeneralForm request = new MockGeneralForm();
    
    protected static AbstractLog log = SimpleLog.getInstance();
    
    public WeberTestCase(){
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL diconfigUrl = parent.getResource("di-config.xml");
        
        String configFwName;
        //System.out.println("di-config.xml path use = " + diconfigUrl.getPath());
        if(diconfigUrl == null ){
            String err = "di-config.xml path is null.";
            fail(err);
            log.error(err);
            return;
        }else{
            configFwName = diconfigUrl.getPath();
        }
        BeanFactory factory = BeanFactory.getInstance();
        try{
            if(!log.isInit()){
                log = (AbstractLog)factory.createInstance("Log");
            }
        }catch(Exception ioe){}
        try{
            factory.create(configFwName);
            ConnectionManager mgr = (ConnectionManager) factory.createInstance("ConnectionManager");
            mgr.init();
        }catch(Exception e){}
    }
    
    /**
     * ANVdoExecute\bh؂܂B
     * @param action Action ANVIuWFNg
     * @param form Form tH[IuWFNg
     * @param forward ANV̎sʂ̗\l
     */
    public void assertDoExecute(Action action, Object form, String forward) throws Exception{
        //doExcecute\bh̃eXg{
        String result = "";
        try{
            bucket.setForm(form);
            action.init(bucket, request);
//moidfy 2007/03/26 kano start ɋƖWbN݂̂ɃeXgΏۂƂ
//            result = action.beforeExecute();
//            if( result.equals(Globals.RET_SUCCESS)){
//                result = action.doExecute(bucket);
//            }
            result = action.doExecute(bucket);
//modify 2007/03/26 kano end
            
//add 2007/02/01 kano Weber4.x Ή start
        }catch(RoleException re){
            throw re;
//add 2007/02/01 kano Weber4.x Ή end
        }
        assertEquals("doExcecute", forward, result);
    }
    
    /**
     * ANVcheckUserRole\bh؂܂B<BR>
     * f[^x[X̍XVsꂽꍇ̓R~bg/[obNs܂B
     * @param action Action ANVIuWFNg
     * @param user [UIuWFNg
     * @param ret [U`FbN
     */
    public void assertCheckUserRole(Action action, User user, boolean ret){
        
        //doExcecute\bh̃eXg{
        try{
            bucket.setAttributeFromSession(Globals.REQ_PARAM_USER, user);
            action.init(bucket, request);
            action.beforeCheckRole();
            boolean isUser = action.checkRole(bucket);
            assertEquals("checkUserRole",ret, isUser);
//add 2007/02/01 kano Weber4.x Ή start
        }catch(RoleException re){
            assertEquals("checkUserRole",ret, false);
            //throw re;
//add 2007/02/01 kano Weber4.x Ή end
        }
    }
    
    /**
     * ANVvalidate\bh؂܂B
     * @param action Action ANVIuWFNg
     * @param form Form tH[IuWFNg
     * @param forward ANV̎sʂ̗\l
     */
    //public void assertValidate(Action action, Object form, String forward){
    public void assertValidate(Action action, String forward) throws Exception{
        //bucket.setForm(form);
        action.setGeneralForm(request);
        
        //doExcecute\bh̃eXg{
        String ret = action.validate(bucket);
        assertEquals("validate", forward, ret);
    }
    
    
//    public static void main(String[] argv) throws Exception{
//    	String rootPath = System.getProperty("user.dir");
//    	String path = rootPath + "/WEB-INF/web.xml";
//    	HashMap map = new HashMap();
//    	WebReader reader = new WebReader();
//    	reader.create(path, map);
//
//    	Set set = map.keySet();
//    	Iterator it = set.iterator();
//    	while(it.hasNext()){
//    		Object key = it.next();
//    		String value = (String)map.get(key);
//    		System.out.println(key+"->"+value);
//    	}
//    }
}
