/*
 * DateFormat.java
 *
 * Created on 2007/03/17, 13:25
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.itscool.stylist.function;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * tpEL֐
 * @author KANO
 */
public class DateC {
    public static void main(String[] argv){
        DateC d = new DateC();
        String dateStr = "Sun Mar 11 00:00:00 JST 2007";
        System.out.println(d.format(dateStr, "yyyy/MM/dd"));
        String dateStr2 = (new Date()).toString();
        System.out.println(d.format(dateStr, "yyyy/MM/dd"));
        
    }
    /**
     * t^(EEE MMM dd HH:mm:ss 'JST' yyyy`)w̃tH[}bgɕϊ܂
     * @param dateStr Date^toString()w肵܂
     * @param fmt Zʂ̃tH[}bgw肵܂
     * @param kind ZΏۂw肵܂iyFNAMFAdFAhFԁAmFAsFbj
     * @return tH[}bgꂽԂ܂
     */
    public String add(String dateStr, String fmt, String kind, int num) {
        if( dateStr == null || dateStr.length() == 0 ){
            Date dft = new Date();
            dateStr = dft.toString();
        }
        DateFormat sdf1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        
        try{
            String str = format(dateStr);
            Date date = sdf1.parse(str);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if( kind.equals("y")){
                cal.add(Calendar.YEAR, num);
            }else if( kind.equals("M")){
                cal.add(Calendar.MONTH, num);
            }else if( kind.equals("d")){
                cal.add(Calendar.DAY_OF_MONTH, num);
            }else if( kind.equals("h")){
                cal.add(Calendar.HOUR, num);
            }else if( kind.equals("m")){
                cal.add(Calendar.MINUTE, num);
            }else if( kind.equals("s")){
                cal.add(Calendar.SECOND, num);
            }
            SimpleDateFormat sdf2 = new SimpleDateFormat(fmt);
            dateStr = sdf2.format(cal.getTime());
        }catch(Exception e){
            e.printStackTrace();
        }
        
        return dateStr;
    }
    
    /**
     * t^(EEE MMM dd HH:mm:ss 'JST' yyyy`)w̃tH[}bgɕϊ܂
     * @param dateStr Date^toString()w肵܂
     * @param fmt tH[}bgw肵܂
     * @return tH[}bgꂽԂ܂
     */
    public String format(String dateStr, String fmt) {
        if( dateStr == null || dateStr.length() == 0 ){
            Date dft = new Date();
            dateStr = dft.toString();
        }
        DateFormat sdf1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        
        try{
            String str = format(dateStr);
            Date date = sdf1.parse(str);
            SimpleDateFormat sdf2 = new SimpleDateFormat(fmt);
            dateStr = sdf2.format(date);
        }catch(Exception e){
            e.printStackTrace();
        }
        
        return dateStr;
    }
    
    /**
     * t^(EEE MMM dd HH:mm:ss 'JST' yyyy`)yyyy/MM/dd hh:mm:ss`ɕϊ܂
     * @param dateStr Date^toString()w肵܂
     * @return tH[}bgꂽԂ܂
     */
    public static String format(String dateStr){
        if( dateStr == null || dateStr.length() == 0 ){
            Date dft = new Date();
            dateStr = dft.toString();
        }
        String MMM = dateStr.substring(4, 7);
        String dd = dateStr.substring(8, 10);
        String hhmmss = dateStr.substring(11, 19);
        String yyyy = dateStr.substring(24, 28);
        
        return yyyy + "/" + cnvMMMtoMM(MMM) + "/" + dd + " " + hhmmss;
    }

    /**
     * MMMMMɕϊ܂
     * @param MMM JUN/FEB...Ƃw
     * @return 0112܂ł̌Ԃ܂
     */
    public static String cnvMMMtoMM(String MMM){
        if(MMM.equals("Jan")){
            return "01";
        }else if(MMM.equals("Feb")){
            return "02";
        }else if(MMM.equals("Mar")){
            return "03";
        }else if(MMM.equals("Apr")){
            return "04";
        }else if(MMM.equals("May")){
            return "05";
        }else if(MMM.equals("Jun")){
            return "06";
        }else if(MMM.equals("Jul")){
            return "07";
        }else if(MMM.equals("Aug")){
            return "08";
        }else if(MMM.equals("Sep")){
            return "09";
        }else if(MMM.equals("Oct")){
            return "10";
        }else if(MMM.equals("Nov")){
            return "11";
        }else if(MMM.equals("Dec")){
            return "12";
        }else{
            return "  ";
        }
    }
}
