/*
 * FuncRegex.java
 *
 * Created on 2007/03/16, 21:54
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.itscool.stylist.el;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;

/**
 * ELWJNXł
 * @author KANO
 */
public class BaseElRegex {
    public static final String DEFAULT_PKG = "org.itscool.stylist.function";
    private String orgPkg = DEFAULT_PKG;
    
    /**
     * ELɋLqꂽ֐AY֐s܂<br>
     * ֐́ApbP[Worg.itscool.stylist.functionɓo^Ă
     * ftHg֐ƈorgPkgɎw肳ꂽpbP[W̒A
     * Y֐܂B<br>
     * ƂHTML(srcStr)̒Ɉȉ̂悤EL`Ăꍇ<br>
     *
     * <pre>
     *   sʂ${clazz.functionA(1, 2)łB
     * </pre>
     *
     * (1) org.itscool.stylist.function.Clazz.functionA(...)T܂<br>
     * (2) (1)Ŋ֐ȂꍇorgPkgpbP[WFunctionA.functionA
     * T܂B<br>
     * (3) Y֐sA֐̎sʂ𕶎srcStrɖߍ݂܂<br>
     * ֐͕K߂lKvł<br>
     * @param orgPkg [gpbP[W
     * @param srcStr EL܂܂Ă镶
     * @return ֐̎sʂ܂܂镶i֐݂ȂꍇsrcStrԂ܂j
     */
    public String replaceFunction(String orgPkg, String srcStr) {
        Pattern pattern;
        Matcher matcher;
        
        if( srcStr == null ){
            return "";
        }
        this.orgPkg = orgPkg;
        
        /* ̒u(X) */
        pattern = Pattern.compile("\\$\\{\\s*[A-Za-z_0-9|(|\\)]*\\.[A-Za-z_0-9|(|\\)]*\\b\\(([A-Za-z_0-9|\\s|\\+|\\-|\"|\\'|/|:|.|,|\\(|\\)\\s]*)\\s*\\)\\s*}");
        matcher = pattern.matcher(srcStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String el = matcher.group();
            el = el.trim();
            String value = parseFunction(el);
            if( value == null )value = "";
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
    
    /**
     * ${֐`}ɒ`Ă֐`WJ܂
     * @param srcStr ֐`
     * @return ֐̎sʂԂ܂
     */
    public String parseFunction(String srcStr){
        Pattern pattern;
        Matcher matcher;
        
        /* ̒u(X) */
        pattern = Pattern.compile("\\s*[A-Za-z_0-9|(|\\)]*\\.[A-Za-z_0-9|(|\\)]*\\b\\(([A-Za-z_0-9|\\s|\\+|\\-|\"|\\'|/|:|.|,|\\(|\\)\\s]*)\\s*\\)\\s*");
        matcher = pattern.matcher(srcStr);
        if (matcher.find()) {
            String functionStr = matcher.group();
            functionStr = functionStr.trim();
            ElementFunc func = ElementFunc.createFuncList(functionStr);
            String result = getFunctionResult(func);
//            if(result == null){
//                return null;
//            }else{
//                return result;
//            }
            return result;
        }
        return "";
    }
    
    /**
     * srcStr̕񂩂${}WJ܂
     * @param srcStr EL܂ޕ
     * @return ELWJʂԂ܂
     */
    public String replaceEl(String srcStr) {
        Pattern pattern;
        Matcher matcher;
        if( srcStr == null ){
            return "";
        }
        /* ̒u(X) */
        pattern = Pattern.compile("\\$\\{\\s*\\b([A-Za-z_0-9|.|\\(|\\)]*)\\s*\\}");
        matcher = pattern.matcher(srcStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String el = matcher.group();
            String value = parseObj(el);
            if( value == null ) value = "";
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
    
    /**
     * srcStr̕񂩂${}WJ܂
     * @param dstStr EL܂ޕ
     * @return ELWJʂԂ܂
     */
    public String parseObj(String dstStr){
        StringBuffer sb2 = new StringBuffer();
        Pattern pattern2;
        Matcher matcher2;
        
        /* ^O̒g */
        pattern2 = Pattern.compile("\\s*\\b([A-Za-z_0-9|.]*)\\s*");
        matcher2 = pattern2.matcher(dstStr);
        if( !matcher2.find() ){
            return null;
        }
        String tag = matcher2.group();
        
        ElementList elems = ElementList.createElementList(tag);
        String attr = getAttribute(elems);
        return attr;
    }
    
    /**
     * 擪"./"Ŏn܂pXɃT[ubg̃ReLXgpX
     * u܂B<br>
     * ̃\bhł́Aȉ̃^OΏۂɃpX̕ϊs܂B
     * <br>
     * <li>img^O
     * <li>link srcAlink href^O
     * <li>script^O
     * <li>form action^O
     * @param dstStr ϊƂ̃pX
     * @return T[ubg̃ReLXgpXtʂԂ܂
     */
    public StringBuffer parsePath(final String dstStr, final String replace) {
        Pattern pattern;
        Matcher matcher;
        StringBuffer criteria = new StringBuffer();
        criteria.append("<a.*href\\s*=\\s*\".*\"");
        criteria.append("|<img.*src\\s*=\\s*\".*\"");
        criteria.append("|<link.*src\\s*=\\s*\".*\"");
        criteria.append("|<link.*href\\s*=\\s*\".*\"");
        criteria.append("|<script.*src\\s*=\\s*\".*\"");
        criteria.append("|<.*background\\s*=\\s*\".*\"");
        criteria.append("|<form.*action\\s*=\\s*\".*\"");
        
        pattern = Pattern.compile(criteria.toString());
        matcher = pattern.matcher(dstStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            StringBuffer sb2 = new StringBuffer();
            String element = matcher.group();
            boolean flg = false;
            Pattern pattern2 = Pattern.compile("\"\\./");
            Matcher matcher2 = pattern2.matcher(element);
            while( matcher2.find() ){
                String path = matcher2.group();
                
                matcher2.appendReplacement(sb2, replace);
                flg = true;
            }
            matcher2.appendTail(sb2);
            String tag = sb2.toString();
            if( flg == true){
                tag = supressPath(tag);
            }
            matcher.appendReplacement(sb, tag);
        }
        matcher.appendTail(sb);
        return sb;
    }
    
    public static String supressPath(String tag){
        Pattern pattern;
        Matcher matcher;
        
        pattern = Pattern.compile("\\.\\./");
        matcher = pattern.matcher(tag);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
    
    protected String getAttribute( ElementList elems) {
        return elems.getTagString();
    }
    
    protected String getFunctionResult(ElementFunc func){
        String funcName = func.getFuncName();
        String clazz = func.getClassName();
        String clazzName = orgPkg + "." + clazz;
        
        try{
            clazzName = DEFAULT_PKG + "." + clazz;
            Class.forName(clazzName);
        }catch(Exception e){
            clazzName = orgPkg + "." + clazz;
        }catch(Error e){
            clazzName = orgPkg + "." + clazz;
        }
        try{
            Class.forName(clazzName);
        }catch(ClassNotFoundException e){
            throw new ElRegexException("No Function Class = "+clazzName +" Func = " + funcName);
        }catch(Error e){
            throw new ElRegexException("No Function Class = "+clazzName +" Func = " + funcName);
        }
        
        Object[] argList = convertArgument(func);
        try{
            Object result = BeanUtil.invoke(clazzName, funcName, argList);
            return result.toString();
        }catch(BeanUtilRuntimeException e){
            throw new ElRegexException(e.getMessage());
        }
    }
    
    protected Object[] convertArgument(ElementFunc func){
        LinkedList srcArgList = func.getArgList();
        int size = srcArgList.size();
        LinkedList dstArgList = new LinkedList();
        for(int i=0; i<size; i++){
            ElementList elementList = (ElementList)srcArgList.get(i);
            String arg = this.getAttribute(elementList);
            if(arg==null){
                dstArgList.add(elementList.getTagString());
            }else{
                dstArgList.add(arg);
            }
        }
        return dstArgList.toArray();
    }
}
