package org.itscool.commons.util;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.request.GeneralForm;

/**
 * ^OCűʊ֐`NXłB
 * @author KANO
 * @since jdk1.4.1
 */
public class ServletTagUtil extends TagUtil{
    
    /**
     * ServletContextCX^Xw肳ꂽBean擾܂B
     * @param servletContext ServletContextCX^Xw肵܂B
     * @param req HttpServletRequestCX^Xw肵܂
     * @param name servletContextɃZbgꂽBean̖Ow肵܂B
     * @param scope BeañXR[vw肵܂B
     * @return IuWFNgԂ܂
     */
    public static Object findObject(ServletContext servletContext,
        HttpServletRequest req, String name, String scope){
        Object obj = lookup(servletContext, req, name, scope);
        
        return obj;
        
    }
    
    /**
     * ServletContextCX^Xw肳ꂽBeañvpeB擾܂B
     * @param servletContext ServletContextCX^Xw肵܂B
     * @param req HttpServletRequestCX^Xw肵܂
     * @param name servletContextɃZbgꂽBean̖Ow肵܂B
     * @param property servletContextɃZbgꂽBeañvpeBw肵܂B
     * @param scope BeañXR[vw肵܂B
     * @return vpeBԂ܂
     */
    public static Object findProperty(ServletContext servletContext, HttpServletRequest req,
        String name, String property, String scope) {
        Object pObj = null;
        Object obj = null;
        
        if(name != null && name.length() != 0){
            obj = lookup(servletContext, req, name, scope);
        }
        
        if( obj != null && property != null){
//modify 2006.02.12 GeneralFormΉ start
            if( obj instanceof GeneralForm ){
                pObj = ((GeneralForm)obj).getParameter(property);
//add 2006.03.14 HashΉ start
            }else if(obj instanceof Map ){
                pObj = ((Map)obj).get(property);
            }else if(obj instanceof Hashtable ){
                pObj = ((Hashtable)obj).get(property);
//add 2006.03.14 HashΉ end
            }else{
                pObj = BeanUtil.getProperty(obj, property);
            }
//modify 2006.02.12 GeneralFormΉ end
        }else if( obj == null && property != null ){
            pObj = lookup(servletContext, req, property, scope);
            
        }else if( obj != null && property == null ){
            pObj = obj;
        }
        
        if(pObj == null){
            pObj = new String("");
        }
        
        return pObj;
    }
    
    /**
     * ̏nameɎw肳ꂽIuWFNg̃XR[v܂<BR>
     * request, session, application̏
     * @param servletContext ServletContextCX^Xw肵܂
     * @param req HttpServletRequestCX^Xw肵܂
     * @param name ServletContextCX^XɃZbgĂBeanw肵܂
     * @return XR[vԂ܂
     */
    public static String findScope(ServletContext servletContext,
        HttpServletRequest req, String name){
        Object obj = null;
        
        
        obj = req.getAttribute(name);
        if( obj != null ){
            return SCOPE_REQUEST;
        }
        
        obj = req.getSession().getAttribute(name);
        if( obj != null ){
            return SCOPE_SESSION;
        }
        
        obj = servletContext.getAttribute(name);
        if( obj != null){
            return SCOPE_APPLICATION;
        }
        
        return null;
        
    }
    
    /**
     * ServletContextCX^Xw肳ꂽBean擾܂B<BR>
     * scopew肳ĂȂꍇ́ȀŃIuWFNg܂B<BR>
     * request, session, context̏
     * @param servletContext ServletContextCX^Xw肵܂B
     * @param req HttpServletRequestCX^Xw肵܂
     * @param name servletContextɃZbgꂽBean̖Ow肵܂B
     * @param scope BeañXR[vw肵܂B
     * @return IuWFNgԂ܂
     */
    protected static Object lookup(ServletContext servletContext,
        HttpServletRequest req, String name, String scope) {
        Object obj = null;
        
        if(scope == null){
            //scopew肳ĂȂꍇ͎̏ŃIuWFNg܂B
            // request, session, context
            obj = lookup(servletContext,req, name);
            
            return obj;
        }
        
        if( scope.equals(SCOPE_APPLICATION) ){
            obj = servletContext.getAttribute(name);
            
        }else if( scope.equals(SCOPE_SESSION) ){
            obj = req.getSession().getAttribute(name);
            
        }else if( scope.equals(SCOPE_REQUEST) ){
            obj = req.getAttribute(name);
            
        }
        
        return obj;
    }
    
    /**
     * ̏ServletContextCX^Xw肳ꂽBean擾܂B<BR>
     * request, session, context̏
     * @param servletContext ServletContextCX^Xw肵܂B
     * @param req HttpServletRequestCX^Xw肵܂
     * @param name servletContextɃZbgꂽBean̖Ow肵܂B
     * @return IuWFNgԂ܂
     */
    protected static Object lookup(ServletContext servletContext,
        HttpServletRequest req, String name){
        Object obj = null;
        
        obj = req.getAttribute(name);
        if( obj != null ){
            return obj;
        }
        
        obj = req.getSession().getAttribute(name);
        if( obj != null ){
            return obj;
        }
        
        obj = servletContext.getAttribute(name);
        if( obj != null ){
            return obj;
        }
        
        return obj;
        
    }
    
//    /**
//     * [ value="value" ]`̃^O쐬܂
//     * @param servletContext ServletContextCX^Xw肵܂
//     * @param name   ServletContextCX^XɕێĂIuWFNg̘_
//     *             w肵܂
//     * @param property IuWFNg̃vpeBw肵܂
//     * @param scope IuWFNgServletContextCX^XɕێĂXR[v
//     *              w肵܂B
//     * @param value valueɎw肷lw肵܂<BR>
//     *              valuenull̏ꍇ̓IuWFNgɃZbgĂlgp
//     *              ܂
//     * @return ^OԂ܂
//    */
//    public static String createAttribute(ServletContext servletContext, HttpServletRequest req,
//    String name, String property, String scope, String key, String value ) {
//        StringBuffer inputTag = new StringBuffer();
//
//        if( property == null || property.length() == 0 ){
//            inputTag.append("");
//
//        }else{
//            Object result = TagUtil2.findProperty(servletContext, req, name, property, scope);
//            if( value != null && value.toString().length() > 0){
//
//                //ELΉo[W
//            	value = TagUtil2.findValue(servletContext, req, value, scope).toString();
//
//            	//Valuew肳Ăꍇ
//                //Valueo͂
//                inputTag.append(" " + key + "=\"").append(value).append("\" ");
//            }else if( result == null || result.toString().length() == 0 ){
//                //BeanZbgĂȂꍇ́AvpeBṔinamej
//                //ŒlZbgĂȂmFB
//                //̓G[ł̃y[Wɖ߂ėꍇ͈ȉ̃vpeB
//                //ZbgB
//            	result = (String)req.getAttribute(property);
//                if( result != null && result.toString().length() > 0 ){
//                    inputTag.append(" "+ key + "=\"").append(result).append("\" ");
//
//                //vpeBZbgĂȂꍇ̓ftHgij
//                //o͂
//                }else{
//                    //inputTag.append(name).append("\" ");
//                    inputTag.append("");
//
//                }
//            }else{
//                //BeanZbgĂꍇBeanɃZbgĂ
//                //vpeBo͂
//
//                inputTag.append(" " + key + "=\"").append(result).append("\" ");
//            }
//        }
//
//        return inputTag.toString();
//    }
    
//    /**
//     * [ ${tagName}="${tagValue}" ]`̃^O쐬܂
//     * @param tagName w肵܂
//     * @param tagValue ɃZbglw肵܂
//     * @return ^OԂ܂
//    */
//    public static String createAttribute(String tagName, String tagValue){
//        StringBuffer inputTag = new StringBuffer(" ").append(tagName);
//        inputTag.append("=\"");
//        inputTag.append(tagValue).append("\" ");
//
//        if( tagName == null || tagName.length() == 0 ||
//        tagValue == null || tagValue.length() == 0){
//        	return "";
//        }else{
//        	return inputTag.toString();
//        }
//    }
    
//	/**
//	 * [ ${tagName}="${tagValue(true/false)}" ]`̃^O쐬܂
//	 * @param tagName w肵܂
//	 * @param tagValue ɃZbglw肵܂
//	 * @return ^OԂ܂
//	*/
//	public static String createBoolAttribute(String tagName, String tagValue){
//		StringBuffer inputTag = new StringBuffer(" ").append(tagName);
//
//		if( tagName == null || tagName.length() == 0 || tagValue == null ){
//			return "";
//		}else if(tagValue.toLowerCase().equals("true") ){
//			inputTag.append(createAttribute(tagName, "true"));
//			return inputTag.toString();
//		}else{
//			inputTag.append(createAttribute(tagName, "false"));
//			return inputTag.toString();
//		}
//	}
    
//    /**
//     * ^OɎw肳ꂽlBeanɃZbgꂽlł邩`FbN܂<br>
//     * @param beanVal IuWFNgɃZbgĂvpeBl
//     * @param value ^OɎw肳ꂽl
//     * @return ^OɎw肳ꂽlBeanɃZbgꂽlꍇtrueԂ܂
//     *
//    */
//    public static boolean isCheckedValue(Object beanVal, String value){
//        boolean ret = false;
//        if( beanVal == null || value == null || value.length() == 0){
//            return ret;
//        }
////add 2006/03/07 Mr.sawamura start
//        if ( beanVal instanceof List ) {
//            List al = (List)beanVal;
//            for (int i = 0; i < al.size(); i++) {
//            	Object bv = al.get(i);
//            	boolean b = isCheckedValue(bv, value);
//                if (b) {
//                     ret = true;
//                     break;
//                  }
//              }
//       }
////add 2006/03/07 Mr.sawamura end
//       else if( beanVal instanceof Boolean ){
//            Boolean chkVal = new Boolean(value);
//
//            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
//                ret = true;
//            }
//        }else if( beanVal instanceof String ){
//            String chkVal = new String(value);
//
//            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
//                ret = true;
//            }
//        }else if( beanVal instanceof Integer ){
//            Integer chkVal = new Integer(value);
//
//            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
//                ret = true;
//            }
//        }else if( beanVal instanceof Double ){
//            Double chkVal = new Double(value);
//
//            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
//                ret = true;
//            }
//        }else if( beanVal instanceof Float ){
//            Float chkVal = new Float(value);
//
//            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
//                ret = true;
//            }
//        }else if( beanVal instanceof Long ){
//            Long chkVal = new Long(value);
//
//            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
//                ret = true;
//            }
//        }else{
//            String chkVal = new String(value);
//
//            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
//                ret = true;
//            }
//        }
//        return ret;
//    }
    
//    /**
//     * HTMLLq`̕񂩂w肳ꂽ^O̕擾܂
//     *
//     * @param html HTMLLq̕
//     * @param tag ^Ow肵܂ibodyAheadAtitleȂǁj
//     * @return TagInfoCX^XԂ܂
//     *          HTMLLqsȏꍇNULLԂ܂
//     */
//    public static TagInfo createTagInfo(String html, String tag){
//        int startIndex = html.indexOf("<"+ tag);
//        int endIndex = html.indexOf("</" + tag + ">");
//
//        if( startIndex == -1 || endIndex == -1){
//            return null;
//        }
//
//        String body = html.substring(startIndex, endIndex + ("</" + tag + ">").length());
//
//        int startBodyIndex = body.indexOf(">") + 1;
//        int endBodyIndex = body.indexOf("</" + tag + ">");
//
//        if( endBodyIndex == -1 ){
//            return null;
//        }
//
//        String bodyIn = body.substring(startBodyIndex, endBodyIndex);
//
//        TagInfo tagInfo = new TagInfo();
//        tagInfo.setDataInTag(bodyIn);
//        tagInfo.setStartTag(body.substring(0, startBodyIndex));
//        tagInfo.setEndTag(body.substring(endBodyIndex, body.length()));
//
//        return tagInfo;
//    }
    
    /**
     * vpeBIuWFNg̃vpeB擾AʂNG[ŕԂ܂B
     * <BR>
     * vpeBXgɂ͈ȉ̏łKv܂B
     * <P>
     * IuWFNg:IuWFNg擾̃vpeBiȗ\):gslkɏo͂Ƃ̃vpeBiȗ\),
     * IuWFNg2:vpeB2,gslkɏo͂Ƃ̃vpeB2iȗ\),(ȍ~p[^JԂ)
     *
     * <p>
     *  vpeBȗꍇ̓IuWFNgŎ擾IuWFNgtoString()Ԃ܂
     * @param servletContext ServletContextCX^X
     * @param req HttpServletRequestCX^Xw肵܂
     * @param properties vpeBXg
     * @param scope XR[v
     * @return NG[Ԃ܂
     */
    public static String createQueryString(ServletContext servletContext,
        HttpServletRequest req, String properties, String scope) {
        if(properties==null || properties.length() == 0){
            return "";
        }
        StringTokenizer dataSt = new StringTokenizer(properties, ",");
        StringBuffer sb = new StringBuffer("");
        if(dataSt.hasMoreTokens()){
            sb.append("?");
        }
        while (dataSt.hasMoreTokens()) {
            String data = dataSt.nextToken().trim();
            StringTokenizer propertySt = new StringTokenizer(data, ":");
            //IuWFNg̎擾
            String name = propertySt.nextToken();
            if( name==null){
                throw new RuntimeException("name is null query="+properties);
            }else{
                name = name.trim();
            }
            //vpeB̎擾
            String property = null;
            if( propertySt.hasMoreTokens() ){
                property = propertySt.nextToken();
            }
            //HTMLɏo͂vpeB̎擾
            String htmlName = null;
            if( propertySt.hasMoreTokens() ){
                htmlName = propertySt.nextToken().trim();
            }
            Object value = null;
            if( property == null ){
                value = findObject(servletContext, req, name, scope);
            }else{
                property = property.trim();
                value = findProperty(servletContext, req, name, property, scope);
            }
            if( htmlName != null ){
                sb.append(htmlName).append("=");
            }else if( property == null ){
                sb.append(name).append("=");
            }else{
                sb.append(property).append("=");
            }
            if( value != null){
                sb.append(value.toString());
            }
            if(dataSt.hasMoreTokens()){
                sb.append("&");
            }
            //println(st.nextToken());
        }
        return sb.toString();
    }
    
//    /**
//     * value擾܂B<BR>
//     * value̒^ŕ\ꍇAw肳ꂽϐXR[v
//     * ܂<BR>
//     * <p>
//     * value̒^F${IuWFNg.vpeB}<br>
//     * <p>
//     * ^ɊYȂꍇ́Avaluel̂܂ܕԂ܂<BR>
//     *
//     * @param servletContext ServletContextCX^Xw肵܂B
//     * @param req HttpServletRequestCX^Xw肵܂
//     * @param value value
//     * @param scope BeañXR[vw肵܂B
//     * @return valuěʂԂ܂
//     */
//    public static Object findValue(ServletContext servletContext,
//    	HttpServletRequest req, String value, String scope){
//        if( value == null ){
//        	return "";
//        }else if(value.length() < 3 ){
//    		return value;
//    	}
//    	String topKey = value.substring(0,1);
//    	String stKakko = value.substring(1,2);
//    	String edKakko = value.substring(value.length()-1,value.length());
//
//    	if(!topKey.equals("$")){
//    		return value;
//    	}
//    	StringTokenizer propertySt = new StringTokenizer(value, ".");
//    	String name = propertySt.nextToken().trim();
//    	name = name.substring(2, name.length());
//    	String property = null;
//        if(propertySt.hasMoreTokens()){
//        	property = propertySt.nextToken().trim();
//        	property = property.substring(0, property.length()-1);
//        }else{
//        	name = name.substring(0, name.length()-1);
//        }
////        System.out.print("[" + name +"]");
////        System.out.println("["+property+"]");
//
//        Object result = findProperty(servletContext, req, name, property, scope);
//        if( result == null){
//        	return "";
//        }else{
//        	return result;
//        }
//    }
    
    /**
     * value擾܂B<BR>
     * value̒^ŕ\ꍇAw肳ꂽϐXR[v
     * ܂<BR>
     * <p>
     * value̒^F${IuWFNg.vpeB}<br>
     * <p>
     * ^ɊYȂꍇ́Avaluel̂܂ܕԂ܂<BR>
     *
     * @param servletContext ServletContextCX^Xw肵܂B
     * @param req HttpServletRequestCX^Xw肵܂
     * @param value value
     * @param scope BeañXR[vw肵܂B
     * @return valuěʂԂ܂
     */
    public static Object findValue(ServletContext servletContext,
        HttpServletRequest req, String value, String scope){
        if( value == null ){
            return "";
        }else if(value.length() < 3 ){
            return value;
        }
        
        ElementList elems = parseEl(value);
        int size = elems.size();
        if( size == 0 ){
            return value;
        }else if( size == 1 ){
            String name = elems.getElement(0);
            Object obj = findObject(servletContext, req, name, scope);
            return obj;
        }else{
            String name = elems.getElement(0);
            String property = elems.getElement(1);
            Object obj = findProperty(servletContext, req, name, property, scope);
            if( size > 2 ){
                for( int i=2; i<size; i++ ){
                    property = elems.getElement(i);
                    obj = BeanUtil.getProperty(obj, property);
//					obj = getProperty(obj, property);
                }
            }
            return obj;
        }
    }
    
    public static ElementList parseEl(String value){
        ElementList elems = new ElementList();
        String property = null;
        if( value == null || value.equals("")){
            return elems;
        }else if(value.length() < 3 ){
            return elems;
        }
        int startIndex = value.indexOf("${");
        int lastIndex = value.lastIndexOf("}");
        
        if(startIndex < 0 || lastIndex < 0){
            return elems;
        }
        property=value.substring(startIndex+2, lastIndex);
        if(property != null && property.length() > 0){
            property = property.trim();
        }
//    	System.out.print(property + " ==> ");
        StringTokenizer propertySt = new StringTokenizer(property, ".");
        while(propertySt.hasMoreTokens()){
            property = propertySt.nextToken().trim();
            property = property.substring(0, property.length());
            elems.add(property);
        }
//        System.out.println(elems.toString());
        return elems;
    }
}

class ElementList extends LinkedList{
    public static final String LINE=System.getProperty("line.separator");
    public String toString(){
        StringBuffer sb = new StringBuffer();
        int listSize = this.size();
        for(int i=0; i<listSize; i++ ){
            String str = (String)this.get(i);
            sb.append(str);
            if( (i+1) < listSize ){
                sb.append(", ");
            }
        }
        
        return sb.toString();
    }
    
    public String getElement(int index){
        return (String)this.get(index);
    }
}
