/*
 * 쐬: 2005/07/18
 * 쐬: KANO
 */
package org.itscool.commons.dao;

import java.util.List;
import org.itscool.commons.connection.Record;
import org.itscool.commons.connection.Records;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;

/**
 * AutoNumberIuWFNg̃f[^ANZXpNXł<BR>
 * ̃NX́AiNXe[uɓo^ہAj[NIDl𐶐邽߂
 * f[^ANZXNXł<BR>
 * IDl𐶐邽߂ɂ́A炩߃f[^x[XIDp̈ȉ̃e[u쐬
 * ĂȂ΂Ȃ܂<P>
 *
 * e[uFAUTONUMBER<BR>
 * tB[hFTABLE_NAME(255) iL[)<BR>
 * tB[hFNEXT_NUMBER(Integer)
 *
 * @author KANO
 * @version 1.00
 */
public class AutoNumberDao extends BaseDao {
    
    /**
     * we[ũvC}[ID𐶐܂
     * @param tableName e[u
     * @return vC}[ID
     */
    public int getNext(String tableName){
        int id = 0;
        Criteria crt = new Criteria(AutoNumber.class);
        crt.eq(AutoNumber.TABLE+"."+AutoNumber.PK_COLUM_tableName, tableName);
        List lst = select(crt);
        if(lst != null && lst.size() > 0){
            AutoNumber autoNumber = (AutoNumber)lst.get(0);
            id = nextAutoNumber(tableName, autoNumber);
        }else{
            id = newAutoNumber(tableName);
        }
        return id;
    }
    
    /**
     * we[ũvC}[ID擾܂
     * @param tableName e[u
     * @param autoNumber
     * @return ̔ԂꂽID
     */
    protected int nextAutoNumber(String tableName, AutoNumber autoNumber){
        int id = autoNumber.getNextNumber()+1;
        autoNumber.setNextNumber(id);
        Criteria crt = new Criteria(AutoNumber.class);
        crt.eq(AutoNumber.TABLE+"."+AutoNumber.PK_COLUM_tableName, tableName);
        this.update(crt, autoNumber);
        return id;
    }
    
    /**
     * AUTO_NUMBERe[uɃe[uo^AvC}[ID擾܂
     * @param tableName e[u
     * @return vC}[ID
     */
    protected int newAutoNumber(String tableName){
        int id = getCount(tableName);
        if( id < 1 ){
            id = 1;
        }else{
            id ++;
        }
        
        AutoNumber autoNumber = new AutoNumber();
        autoNumber.setTableName(tableName);
        autoNumber.setNextNumber(id);
        Criteria crt = new Criteria(AutoNumber.class);
        
        insert(crt, autoNumber);
        
        return id;
        
        
    }
    
    public int getCount(String tableName){
        String sql = "SELECT COUNT(*) AS DATA_NUM FROM " + tableName;
        Transaction trn = TransactionUtil.getTransaction();
        Records records = trn.select(sql);
        Record record = (Record)records.get(0);
        int dataNum = record.getInt("DATA_NUM");
        
        return dataNum;
    }
    
}
