package test.org.itscool.weber.user;

import java.util.List;

import org.itscool.commons.connection.TransactionUtil;
import org.itscool.weber.testcase.WeberDbTestCase;
import org.itscool.weber.user.Role;
import org.itscool.weber.user.RoleDao;

public class UserRoleDaoTest extends WeberDbTestCase{
    
    public void setUp(){
        this.initTables("test-db-data.xml");
    }
    
    public void testAllData(){
    	RoleDao roleDao = new RoleDao();
    	List list = roleDao.getAllData();
    	
    	assertNotNull(list);
    	
    	if( list.size() > 0){
    		if(!(list.get(0) instanceof Role)){
    			fail("UserRoleDao.getAllData()Ŏ擾CX^XUser^łȂ");
    		}
    	}
    }
    
    public void testGetUserRole(){
    	RoleDao roleDao = new RoleDao();
    	Role role = roleDao.getRole("test_role");
    	
    	assertEquals("test_role", role.getName());
    	assertEquals(1, role.getId());
    }
    
    public void testSave(){
    	RoleDao roleDao = new RoleDao();
    	Role role = new Role();
    	role.setName("test-role-10");
    	roleDao.save(role);
    	
    	try{
    		TransactionUtil.commitTransaction();
    	}catch(Exception e){
    		fail(e.getMessage());
    	}
    }
    
    public void testUpdate(){
    	RoleDao roleDao = new RoleDao();
    	Role role = roleDao.getRole("test_role");
    	
    	role.setName("test-role-11");
    	roleDao.update(role);
    	
    	try{
    		TransactionUtil.commitTransaction();
    	}catch(Exception e){
    		fail(e.getMessage());
    	}
    }
    
    public void testDelete(){
    	RoleDao roleDao = new RoleDao();
    	Role role = new Role();
    	role.setName("test-role-12");
    	roleDao.save(role);
    	
    	try{
    		TransactionUtil.commitTransaction();
    	}catch(Exception e){
    		fail(e.getMessage());
    	}
    	
    	roleDao.delete(role);
    	try{
    		TransactionUtil.commitTransaction();
    	}catch(Exception e){
    		fail(e.getMessage());
    	}
    }
}
