package test.org.itscool.commons.dao3;

import java.util.List;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.commons.dao.LockVersionException;
import org.itscool.weber.testcase.WeberDbTestCase;

public class VersionDaoTest extends WeberDbTestCase{
    public void setUp(){
        this.clearTables();
        this.initTables("test/org/itscool/commons/dao3/test-db-data.xml");
    }
    
    public void testUpdateString(){
        VersionBean company = new VersionBean();
        company.setId(100);
        company.setName("hoge com");
        company.setLockVersion(1);
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(VersionBean.class);
        crt.eq(VersionBean.TABLE+"."+VersionBean.PK_COLUM_id, company.getId());
        System.out.println(crt.toUpdateString(company));
    }
    
    public void testVersionString(){
        VersionBean company = new VersionBean();
        company.setId(100);
        company.setName("hoge com");
        company.setLockVersion(1);
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(VersionBean.class);
        crt.eq(VersionBean.TABLE+"."+VersionBean.PK_COLUM_id, company.getId());
        System.out.println(crt.toSelectLockVersionString());
    }
    
    public void testVersionString2(){
        DateBean company = new DateBean();
        company.setId(100);
        company.setName("hoge com");
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(VersionBean.class);
        crt.eq(VersionBean.TABLE+"."+VersionBean.PK_COLUM_id, company.getId());
        System.out.println(crt.toSelectLockVersionString());
    }
    
    public void testInsert(){
        VersionBean company = new VersionBean();
        company.setId(10);
        company.setName("hoge com");
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(VersionBean.class);
        int recNum = dao.insert(crt, company);
        
        TransactionUtil.getTransaction().commit();
        
        assertEquals(1, recNum);
    }
    
    public void testUpdate(){
        VersionBean company = new VersionBean();
        company.setId(1);
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(VersionBean.class);
        crt.eq(VersionBean.TABLE+"."+VersionBean.PK_COLUM_id, company.getId());
        List list = dao.select(crt);
        VersionBean bean = (VersionBean)list.get(0);
        
        assertEquals(1, bean.getLockVersion());
        int beforeVer = bean.getLockVersion();
        
        int recNum = dao.update(crt, bean);
        list = dao.select(crt);
        VersionBean next = (VersionBean)list.get(0);
        
        assertEquals(bean.getLockVersion()+1, next.getLockVersion());
        assertEquals(beforeVer+1, next.getLockVersion());
        assertEquals(1, recNum);
        
    }
    
    public void testUpdateLock(){
        VersionBean company = new VersionBean();
        company.setId(2);
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(VersionBean.class);
        crt.eq(VersionBean.TABLE+"."+VersionBean.PK_COLUM_id, company.getId());
        List list = dao.select(crt);
        VersionBean bean = (VersionBean)list.get(0);
        List list2 = dao.select(crt);
        VersionBean bean2 = (VersionBean)list2.get(0);
        
        assertEquals(1, bean.getLockVersion());
        int beforeVer = bean.getLockVersion();
        
        int recNum = dao.update(crt, bean);
        try{
            int recNum2 = dao.update(crt, bean2);
            fail("???? yϓIbNs");
        }catch(LockVersionException e){
            //OK
        }
        list = dao.select(crt);
        VersionBean next = (VersionBean)list.get(0);
        
        assertEquals(beforeVer+1, next.getLockVersion());
        assertEquals(bean.getLockVersion()+1, next.getLockVersion());
        assertEquals(1, recNum);
         TransactionUtil.getTransaction().commit();
        
    }
    
}
