/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.pool.ObjectPool;
import org.itscool.commons.pool.ObjectPoolEventListener;

public class JdbcConnectionManager
implements ConnectionManager,
ObjectPoolEventListener {
    private static JdbcConnectionManager instance = null;
    private ObjectPool pool;
    private String drvname;
    private String pwd;
    private String url;
    private String user;
    private int timeout;
    private boolean initFlg = false;
    private int initSize = 0;
    private int maxSize = 1;
    private boolean mode = false;
    private boolean showSql = false;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Driver Name:").append(this.drvname);
        sb.append(", ");
        sb.append("timeout:").append(this.timeout);
        sb.append(", ");
        sb.append("initSize:").append(this.initSize);
        sb.append(", ");
        sb.append("maxSize:").append(this.maxSize);
        sb.append(", ");
        sb.append("mode:").append(this.mode);
        sb.append(", ");
        sb.append("showSql:").append(this.showSql);
        return sb.toString();
    }

    public static JdbcConnectionManager getInstance() {
        if (instance == null) {
            instance = new JdbcConnectionManager();
        }
        return instance;
    }

    public void init(String url, String user, String pwd, String drvname, int initSize, int maxSize, boolean mode, int timeout, boolean showSql) throws TransactionException {
        this.pool = new ObjectPool(this, initSize, maxSize);
        this.url = url;
        this.user = user;
        this.pwd = pwd;
        this.mode = mode;
        this.drvname = drvname;
        this.timeout = timeout;
        this.showSql = showSql;
        this.initSize = initSize;
        this.maxSize = maxSize;
        int i = 0;
        while (i < initSize) {
            this.pool.addNewElement(this.newTransaction());
            ++i;
        }
        this.initFlg = true;
    }

    public void init() {
        this.pool = new ObjectPool(this, this.initSize, this.maxSize);
        int i = 0;
        while (i < this.initSize) {
            this.pool.addNewElement(this.newTransaction());
            ++i;
        }
    }

    private Transaction newTransaction() throws TransactionException {
        Connection con = null;
        Transaction trn = null;
        try {
            Class.forName(this.drvname);
            con = DriverManager.getConnection(this.url, this.user, this.pwd);
            con.setAutoCommit(this.mode);
            trn = new Transaction(con);
            trn.setShowSql(this.showSql);
        }
        catch (ClassNotFoundException e) {
            throw new TransactionException(e);
        }
        catch (SQLException se) {
            throw new TransactionException(se);
        }
        return trn;
    }

    public boolean isInit() {
        return this.initFlg;
    }

    public Transaction getTransaction() {
        if (this.timeout > 0) {
            return (Transaction)this.pool.getElement(this.timeout);
        }
        return (Transaction)this.pool.getElement();
    }

    public void returnTransaction(Transaction trn) {
        if (trn == null) {
            trn = this.newTransaction();
        } else if (trn.isClosed()) {
            trn = this.newTransaction();
        }
        this.pool.returnElement(trn);
    }

    public void destroy() {
        if (this.pool != null) {
            this.pool.release();
        }
        this.pool = null;
    }

    public Object doMissingElementEvent() {
        Transaction trn = this.newTransaction();
        return trn;
    }

    public void doReleaseElementEvent(Object obj) {
        Transaction trn = (Transaction)obj;
        try {
            trn.close();
        }
        catch (TransactionException e) {
            throw new TransactionException(e);
        }
    }

    public int getPoolSize() {
        if (this.pool != null) {
            return this.pool.getPoolSize();
        }
        return -1;
    }

    public int getInitSize() {
        return this.initSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setDrvname(String drvname) {
        this.drvname = drvname;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setInitSize(int initSize) {
        this.initSize = initSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public String getDrvname() {
        return this.drvname;
    }

    public boolean isInitFlg() {
        return this.initFlg;
    }

    public boolean getMode() {
        return this.mode;
    }

    public String getPwd() {
        return this.pwd;
    }

    public boolean getShowSql() {
        return this.showSql;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }
}

