package org.itscool.weber.user;

import org.itscool.commons.property.HexPropertyFile;
import org.itscool.commons.util.AngouUtil;
import org.itscool.commons.util.DataInUtil;

/**
 * [U`t@C쐬ׂ̃R}hNXł<p>
 *
 * yR}h̏z<p>
 *
 * java org.itscool.weber.tool.CreateUser |[-c][-d][-l]| [PATH] [USER] <p>
 *
 * yp[^̉z<p>
 *
 * PATH F t@C̏o͐w肵܂(K{)<br>
 * L̂ꂩw肷(K{)<br>
 * -u   F t@CɃ[Uǉ܂<br>
 * -c   F t@CɃ[UVKɍ쐬܂<br>
 *         t@C݂΂͏㏑܂<br>
 *         (w肵Ȃꍇ͒ǉ܂)<br>
 * -d   F w肳ꂽ[U폜܂<br>
 * -l   F t@Cɓo^Ă郆[Üꗗ\܂<br>
 * USER F [Uw肵܂(K{)<br>
 * 
 * <p>
 * [U`t@Cɓo^pX[h͈Í܂B<br/>
 * </p>
 * 
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class CreateUser {
    /** R}hIvVi[U̒ǉj*/
    static final String OPTION_UP = "-u";
    /** R}hIvVi[Ȕ㏑j*/
    static final String OPTION_NEW = "-c";
    /** R}hIvVi[U̍폜j*/
    static final String OPTION_DEL = "-d";
    /** R}hIvVi[UXg̕\j*/
    static final String OPTION_LIST = "-l";
    
    /**
     * CreateUserR}hs܂
     * @param argv R}hC
    */
    public static void main(String[] argv)throws Exception{
        boolean append = true;
        String user ="";
        String path ="";
        //`FbN
        if( argv.length < 2){
            showParamError();
            return;
        }
        
        //R}hp[^̎擾
        if( argv[0].equals(CreateUser.OPTION_NEW)){
            append = false;
        }
        
        path = argv[1];
        if( argv[0].equals(CreateUser.OPTION_NEW) ||
            argv[0].equals(CreateUser.OPTION_UP)){
            user = argv[2];
            createUser(path, user, append);
        }else if( argv[0].equals(CreateUser.OPTION_DEL) ){
            user = argv[2];
            deleteUser(path, user);
        }else if( argv[0].equals(CreateUser.OPTION_LIST) ){
            showUserList(path);
        }else{
            showParamError();
            return;
        }
    }
    
    /**
     * w肳ꂽpXɌǉ܂<br>
     * pX[h͈Í܂<br>
     * Í̌J̓[Ugp܂
     * @param path t@C̃pX
     * @param user [U
     * @param append ǋL[hBfalsȅꍇ͏㏑܂
    */
    public static void createUser(String path, String user, boolean append)
    throws Exception{
        //String key = DataIn.askString("J͂Ă");
        String pwd = DataInUtil.askString("pX[h͂Ă");
        if( !DataInUtil.askString("ēx͂Ă").equals(pwd) ){
            System.out.println("pX[hႢ܂");
            return;
        }
        //Ƃ肠̓[UƌJ𓯂ɂ
        byte[] pwdAngou = AngouUtil.encrypt(user, pwd);
        HexPropertyFile pFile = new HexPropertyFile(path);
        if( pFile.writeHex(user, pwdAngou, append) ){
            System.out.println("[U1ǉ܂");
        }else{
            System.out.println("̃[U͊ɑ݂܂");
        }
    }
    
    /**
     * w肳ꂽpX猠폜܂<br>
     * @param path t@C̃pX
     * @param user [U
    */
    public static void deleteUser(String path, String user)
    throws Exception{
        boolean ret = DataInUtil.askBoolean("[" + user + "] 폜ĂłH[y/n]", "y");
        if( !ret ){
            System.out.println("𒆎~܂");
            return;
        }
        HexPropertyFile pFile = new HexPropertyFile(path);
        if( pFile.delete(user) ){
            System.out.println("[U1폜܂");
        }else{
            System.out.println("̃[U݂͑܂");
        }
    }
    
    /**
     * w肳ꂽpX猠\܂<br>
     * @param path t@C̃pX
    */
    public static void showUserList(String path)
    throws Exception{
        
        HexPropertyFile pFile = new HexPropertyFile(path);
        System.out.println("[[Uꗗ]");
        System.out.println(pFile.toString());
    }
    
    public static void showParamError(){
        System.out.println("R}hp[^Ⴂ܂");
        System.out.println("");
        System.out.println("yR}h̏");
        System.out.println("");
        System.out.println(" java org.itscool.weber.tool.CreateUser " + 
            "|[-u][-c][-d][-l]| [PATH] [USER]");
        System.out.println("");
        System.out.println(" yp[^̉");
        System.out.println("");
        System.out.println("  PATH F t@C̏o͐w肵܂(K{)");
        System.out.println("  -u   F t@CɃ[Uǉ܂");
        System.out.println("  -c   F t@CɃ[UVKɍ쐬܂");
        System.out.println("          t@C݂΂͏㏑܂");
        System.out.println("          (w肵Ȃꍇ͒ǉ܂)");
        System.out.println("  -d   F w肳ꂽ[U폜܂");
        System.out.println("  -l   F t@Cɓo^Ă郆[Üꗗ\܂");
        System.out.println("  USER F [Uw肵܂(K{)");
        System.out.println("");
    }
}
