package org.itscool.weber.testcase;

import java.io.IOException;
import java.util.LinkedList;

import org.itscool.commons.document.XmlConfigReader;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * eXgf[^`t@C͂NXł
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class DbTestConfigReader extends XmlConfigReader{
    
    /**
     * XMLt@C&lt;table&gt;vf͂܂<br>
     * ͌ʂdataListɃZbg܂<br>
     * @param dataList XML̉͌
    */
    protected void doCreate(LinkedList dataList) throws IOException{
        /* [g^O擾 */
        Element root = document.getDocumentElement();
        if( root == null ){
            String err = "Can not root element at weber-message.xml(" + 
                getClass().getName()+")";
            throw new IOException(err);
        }
        /* action-mappings ̎擾*/
        NodeList rolesList = root.getElementsByTagName("table");
        for( int i = 0; i < rolesList.getLength(); i++) {
            Node roles = rolesList.item(i);
        	NamedNodeMap nodeMap = roles.getAttributes();
        	Node name = nodeMap.getNamedItem("name");
        	String tableName = name.getNodeValue();
        	TableData tableData = new TableData();
        	tableData.setTableName(tableName);
        	createRecordList(roles, tableData);
        	dataList.add(tableData);
        }
    }
    
    /**
     * &lt;record&gt;vf͂܂
     * @param table &lt;massages&gt;vf
     * @param dataList ͌&lt;record&gt;vfǉm[hXg
     * @param tableName e[u
     * @throws Exception
     */
    protected void createRecordList(Node table, TableData tableData){
        NodeList rolesChilds = table.getChildNodes();
        
        for( int i = 0; i < rolesChilds.getLength(); i++) {
        	
            Node message = rolesChilds.item(i);
            if( message.getNodeName().equals("record")){
            	RecordData recordData = new RecordData();
            	
                createFieldList(message, recordData);
                tableData.addRecordData(recordData);
            }
            
        }
    }
    
    /**
     * &lt;record&gt;vf̑͂܂
     * @param record &lt;record&gt;vf
     * @param recordList ͌&lt;record&gt;vfǉm[hXg
     * @throws Exception
     */
    protected void createFieldList(Node record, RecordData recordList){
        NamedNodeMap attributes = record.getAttributes();
        for(int i=0; i<attributes.getLength(); i++)
        {
	        Node name = attributes.item(i);
	        String fieldName = name.getNodeName();
	        String value = name.getNodeValue();
	        
	        FieldData fieldMap = new FieldData();
	        fieldMap.setName(fieldName);
	        fieldMap.setValue(value);
	        
	        //recordMap.put( fieldName, fieldMap );
	        recordList.addFieldData(fieldMap);
        }
    }
}
