package org.itscool.weber.tagex;

import java.io.IOException;
import java.util.Calendar;

import javax.servlet.jsp.JspException;

import org.itscool.commons.util.JspTagUtil;

/**
 * TʃJ_[R|[lg
 */
public class WeeklyCalendarTag extends CalendarTag {
	/**
	 * J_[e[u̕`揈s܂
	 * @throws IOException
	 */
	protected void render() throws IOException, JspException{
		Calendar cal = null;
		MonthTable mTable = null;
		if(calendar != null && calendar.length() > 0 ){
			cal = (Calendar)JspTagUtil.findObject(pageContext, calendar, scope);
		}
		if(cal == null){
			mTable = new MonthTable();
			cal = Calendar.getInstance();
			cal.set(Calendar.YEAR, mTable.getYear());
			cal.set(Calendar.MONTH, mTable.getMonth()-1);
			cal.set(Calendar.DAY_OF_MONTH, 1);
		}else{
			int year = cal.get(Calendar.YEAR);
			int month = cal.get(Calendar.MONTH) + 1;
			mTable = new MonthTable(year, month);
		}
		StringBuffer sb = new StringBuffer();
		sb.append("<TABLE");
		int width = Integer.parseInt(celWidth);
		if( width > 0 ){
			sb.append(" WIDTH=").append( width * 8 + 20);
		}
		sb.append(" border=1 cellSpacing=0 cellPadding=0 >");
		sb.append(LINE);
		//sb.append(createHeader());
		//挎󔒂ŃpfBO
		DateElement date = mTable.getDay(mTable.getYear(), mTable.getMonth(), 1);
		
		//̏T̐擪Zbg
		cal.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
		int firstYear = cal.get(Calendar.YEAR);
		int firstMonth = cal.get(Calendar.MONTH) + 1;
		int firstDay = cal.get(Calendar.DAY_OF_MONTH);
		
		sb.append("<TR HEIGHT=").append(26).append(">");
		sb.append(LINE);
		sb.append(TAB).append("<TD ");
		sb.append(" ALIGN=").append(align);
		sb.append(" VALIGN=").append(valign);
		sb.append(" WIDTH=").append(width);
		sb.append(" STYLE=\"").append(dataStyle).append("\"");
		sb.append(">@</TD>");
		sb.append(LINE);
		
		for(int i=Calendar.SUNDAY; i<=Calendar.SATURDAY; i++, cal.add(Calendar.DAY_OF_MONTH, 1)){
			date = mTable.getDay(cal);
			sb.append(createHeader(mTable, date));
			sb.append(LINE);
		}
		sb.append("</TR>").append(LINE);
		if(drawObj != null){
			sb.append(drawObj.doPaint(mTable, firstYear, firstMonth, firstDay));
		}
		sb.append("</TABLE>");
		sb.append(LINE);
		
		pageContext.getOut().print(sb.toString());
	}
	
//	/**
//	 * [U`֐<BR>
//	 * 1Tԕ̃f[^ʂō쐬ꍇɂ̃\bhTuNXŎgp܂B
//	 * @param mTable MonthTableCX^X
//	 * @param firstYear JnN
//	 * @param firstMonth Jn
//	 * @param firstDay Jn
//	 * @return 1Tԕ̃f[^𕶎ŕԂ܂
//	 */
//	public String doAddRecordData(MonthTable mTable, int firstYear, int firstMonth, int firstDay){
//		return "";
//	}
//	
	/**
	 * J_[e[u1̃f[^쐬
	 * @param mTable 
	 * @param day 
	 * @return J_[e[u1̃f[^Ԃ
	 */
	protected String createHeader(MonthTable mTable, DateElement date) throws JspException{
		StringBuffer sb = new StringBuffer();
		
//		if( date.getYobi() == Calendar.SUNDAY){
//			sb.append("<TR HEIGHT=").append(celHeight).append(">");
//			sb.append(LINE);
//		}
		
		StringBuffer td = new StringBuffer();
		td.append(TAB);
		td.append("<TD ");
		td.append(" HEIGHT=20");
		td.append(" ALIGN=\"center\"");
		td.append(" VALIGN=\"center\"");
		if( date.isToday() ){
			td.append(" STYLE=").append(todayStyle);
		}else if( date.isHoliday() ){
			td.append(" STYLE=").append(holidayStyle);
		}else if( date.getYobi() == Calendar.SUNDAY || date.getYobi() == Calendar.SATURDAY ){
			td.append(" STYLE=").append(donichiStyle);
		}else{
			td.append(" STYLE=").append(dataStyle);
		}
		td.append(">");
		
		sb.append(td.toString());
		
//		if( enable == true && path != null && path.length() > 0 ){
//			sb.append(createHrefData(date));
//		}else{
//			sb.append(date.getDay());
//			sb.append(doCreateData(date));
//		}
		sb.append(date.getDay());
		sb.append(" (").append(date.getYobiNa()).append(")");
		td.append(LINE).append(TAB);
		sb.append("</TD>");
		sb.append(LINE);
//		if( date.getYobi() == Calendar.SATURDAY ){
//			sb.append("</TR>").append(LINE);
//		}
		return sb.toString();
	}
	
}
