package org.itscool.weber.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;
import org.itscool.commons.bean.InitParamMap;
import org.itscool.commons.dao.DaoConfigReader;
import org.itscool.commons.dao.DaoInfoMapping;
import org.itscool.commons.document.XmlConfigReader;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.request.GeneralFormFactory;
import org.itscool.commons.request.UploadFile;
import org.itscool.weber.io.ActionConfigReader;
import org.itscool.weber.io.ExceptionConfigReader;
import org.itscool.weber.io.MessageConfigReader;
import org.itscool.weber.mapping.ActionMapping;
import org.itscool.weber.mapping.ActionMappings;
import org.itscool.weber.mapping.ExceptionMapping;
import org.itscool.weber.mapping.ExceptionMappings;
import org.itscool.weber.mapping.MessageMappings;
import org.itscool.weber.user.RoleManager;

/**
 * FrontControllerp^[ɊÂFrontServletNXł<BR>
 * NCAg甭NGXǵA܂Controller̋@\𐿂
 * FrontServlet󂯎܂B<br>
 * FrontServletMVCfC̖R|[lgłB<BR>
 * ̃t[[Nł́AЂƂ̃AvP[VňFrontServlet
 * NXSẴNGXg܂B<BR>
 * FrontServlet͂̃t[[NŎgpeR|[lgAg
 * AvP[VŜ̐sR|[lgłAJ҂͌Ƃ
 * ڈKv͂܂B<BR>
 * <p>
 *yFrontServletƊ֘ANXz<BR>
 * <table border="1" width="500">
 *     <tr><td>
 *     <font face="lr SVbN" size="3">
 *     <br>
 *     @+--------+ (1)@+------------+@@@+----------+<br>
 *     @|@@@@|----->|@Front @@| (2)@|@Action@|<br>
 *     @|@Web @| (7)@|@Servlet @|----->|@Mapping |<br>
 *     @|@@@@|<-----|@@@@@@|@@@|@@@@@|<br>
 *     @+--------+@@@+------------+@@@+----------+<br>
 *     @@@@@@@@@@@A @|@|<br>
 *     @@@@@@@@@@@| @|@|@@@@@@@@@@<br>
 *     @@@@@@@@@@@| @|@|(3)+------------+<br>
 *     @@@@@@@@@@@| @|@+-->|@@@@@@|<br>
 *     @@@@@@@@@@@| @|@@@|@ Bean@ @|<---+   <br>
 *     @@@@@@@@@@@| @|@@@|@@@@@@|@@|   <br>
 *     @@@@@@@@@@@| @|@@@+------------+@@|   <br>
 *     @@@@@@@@@@@| @|@@@@@@@@@@@@|(5)<br>
 *     @@@@@@@@@@@| @| (4)@+------------+@@|   <br>
 *     @@@@@@@@@@@| @+----->|@@@@@@|@@|   <br>
 *     @@@@@@@@@@@| @@(6)@|@ Action @|----+   <br>
 *     @@@@@@@@@@@+----------|@@@@@@|<br>
 *     @@@@@@@@@@@@@@@@ +------------+<br>
 *     </font>
 * <br>
 * </td></tr>
 * </table>
 * <p>
 *y̐z<br>
 * <table border="1" width="500">
 *     
 *     <tr>
 *         <td width="40" align="center">No</td><td></td>
 *     </tr>
 *     <tr>
 *         <td align="center">1</td>
 *         <td>
 *         NCAg甭NGXgFrontServletNX󂯎܂
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">2</td>
 *         <td>
 *         FrontServlet̓NCAg󂯎NGXgURIActionMapping
 *         擾܂<br>
 *         ActionMappingɂ̓NGXgURIɊ֘AActionNXyуtH[Bean
 *         o^Ă܂
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">3</td>
 *         <td>
 *         FrontServletNXActionMappingNXBeanIuWFNg𐶐A
 *         NCAg̃NGXgp[^BeanIuWFNgɃZbg܂
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">4</td>
 *         <td>
 *         FrontServletNXActionMappingNXAction𐶐܂B<br>
 *         ɐActionɑ΂execute\bhs܂B<BR>
 *         execute\bḧɂ́AtH[Bean̑HttpServletReqeust
 *         CX^XHttpServletResponceCX^X܂܂܂
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">5</td>
 *         <td>
 *         ActionNX̓NCAg̃NGXgp[^BeanIuWFNg
 *         擾܂
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">6</td>
 *         <td>
 *         NGXgp[^ɏ]āArWlXWbN܂<br>
 *         Action̎sʂFrontServletɕԋp܂<br>
 *         </td>
 *     </tr>
 *     <tr>
 *         <td align="center">7</td>
 *         <td>
 *         FrontServletAction̎sʂJSPy[W쐬A
 *      NCAgɕԋp܂
 *         </td>
 *     </tr>
 * </table> 
 * <p>
 * 
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 * @version 1.10A 2004/12/11 Include@\ǉ
 * @version 1.11A 2005/05/20 Include@\폜iStylistƂ̕j
 * @version 1.20A 2005/05/29 FileUploadΉ
 */
public class FrontServlet extends HttpServlet {
	private AbstractLog log;
	
	/** 
	 * FrontServlet̏
	 * @see javax.servlet.GenericServlet#init()
	 */
	public void init(ServletConfig config) throws ServletException {
		BeanFactory factory = BeanFactory.getInstance();
		if( !factory.isInit() ){
			try{
        		factory.createForUrl("di-config.xml");
        	}catch(Exception ex){
        		ex.printStackTrace();
            	throw new ServletException(ex.getMessage());
        	}    
		}
		ActionMappings actionMappings = ActionMappings.getInstance();
		ExceptionMappings exception = ExceptionMappings.getInstance();
        MessageMappings messages = MessageMappings.getInstance();
        DaoInfoMapping daoMapping = DaoInfoMapping.getInstance();
        
//modify 2006/03/12 kano start
        try{
			log = (AbstractLog)factory.getInstance("Log");
        	if(!log.isInit()){
        		log = (AbstractLog)factory.createInstance("Log");
        	}
        }catch(Exception ioe){
        	log = SimpleLog.getInstance();
        	log.info(ioe.getMessage());
        }
//modify 2006/03/12 kano end
        
        try{
			InitParamMap params = (InitParamMap)factory.createInstance("InitParams");
			String weberConf=params.getParam("weber-config");
			String msgConf=params.getParam("message-config");
			String daoConf=params.getParam("dao-config");
			XmlConfigReader actionReader = new ActionConfigReader();
			actionReader.setConfigName(weberConf);
			actionReader.create(actionMappings);
			
			try{
				XmlConfigReader exceptionReader = new ExceptionConfigReader();
				exceptionReader.setConfigName(weberConf);
		        exceptionReader.create(exception);
			}catch(Exception ioe){
	        	log.info("ExceptionConfigReader͎s܂");
	        }
			
			try{
				XmlConfigReader messageReader = new MessageConfigReader();
				messageReader.setConfigName(msgConf);
		        messageReader.create(messages);
			}catch(Exception ioe){
	        	log.info("MessageConfigReader͎s܂");
	        }
			try{
				XmlConfigReader daoReader = new DaoConfigReader();
		        daoReader.setConfigName(daoConf);
				daoReader.create(daoMapping);
			}catch(Exception ioe){
				log.info("DaoConfigReader͎s܂");
	        }
			try{
				RoleManager roleManager = (RoleManager)factory.createInstance("RoleManager");
		        roleManager.init();
			}catch(Exception ioe){
				log.info("RoleManager͎s܂");
	        }
		
        }catch(Exception e){
        	String name1 = e.getClass().getName();
			String name2 = Exception.class.getName();
			StackTraceElement[] traceList = e.getStackTrace();
	        log.error(getStackTrace(traceList));
			throw new ServletException(e.getMessage());
        }
	}

	/**
	 * doGet܂
	 * @see javax.servlet.http.HttpServlet#doGet(
	 *         javax.servlet.http.HttpServletRequest, 
	 *         javax.servlet.http.HttpServletResponse)
	 */
	public void doGet(HttpServletRequest arg0, HttpServletResponse arg1)
		throws ServletException, IOException {
		execute(arg0, arg1);
	}

	/**
	 * doPost܂
	 * @see javax.servlet.http.HttpServlet#doPost(
	 *         javax.servlet.http.HttpServletRequest, 
	 *         javax.servlet.http.HttpServletResponse)
	 */
	public void doPost(HttpServletRequest arg0, HttpServletResponse arg1)
		throws ServletException, IOException {
		execute(arg0, arg1);
	}
	
	/**
	 * doGet()AdoPost()\bh̏s邽߂execute\bhĂт܂<br>
	 * executes̓\bh߂lɃZbgꂽJSPɑJڂ܂B<BR>
	 * VXeOꍇexception\bhĂяo܂B
	 * @param req HttpNGXgCX^X
	 * @param res HttpX|XCX^X
	*/
	protected void execute(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {
		try {
	        String jsp = process(req, res);
//			if( jsp == null){
//				throw new ServletException("no such a jps file["+jsp+"]");
//			}
			if(jsp.equals(Globals.RET_NOFORWARD)){
				return;
			}
	        //==========================================================================================
	        //jspԐM
	        //==========================================================================================
			//** servlet̏init()ōsꍇ͂
			//ServletContext sc = this.getServletContext();
			//RequestDispatcher rd = sc.getRequestDispatcher(jsp);
			//rd.forward(req, res);
			//** servlet̏init(ServletConfig config)ōsꍇ͂
			RequestDispatcher rd = req.getRequestDispatcher(jsp);
			rd.forward(req, res);
			//getServletContext().getRequestDispatcher(jsp).forward(req, res);
	        
		} catch (IOException e) {
			String name1 = e.getClass().getName();
			String name2 = IOException.class.getName();
			if (!exception(req, res, name1, name2, e)) {
				throw e;
			}
		} catch (ServletException e) {
			String name1 = e.getClass().getName();
			String name2 = ServletException.class.getName();
			if (!exception(req, res, name1, name2, e)) {
				throw e;
			}
		} catch (NullPointerException e) {
			String name1 = e.getClass().getName();
			String name2 = NullPointerException.class.getName();
			if (!exception(req, res, name1, name2, e)) {
				throw e;
			}
		} catch (RuntimeException e) {
			String name1 = e.getClass().getName();
			String name2 = RuntimeException.class.getName();
			if (!exception(req, res, name1, name2, e)) {
				throw e;
			}
		} catch (Exception e) {
			String name1 = e.getClass().getName();
			String name2 = Exception.class.getName();
			if (!exception(req, res, name1, name2, e)) {
				throw new ServletException(e.getMessage());
			}
		} catch (Error e){
			String name1 = e.getClass().getName();
			String name2 = Exception.class.getName();
			if (!exception(req, res, name1, name2, e)) {
				throw new ServletException(e.getMessage());
			}
		}
	}

	/**
	 * doGet()AdoPost()\bh̏s܂                          <BR>
	 * FrontServletNX́A󂯎NGXgpXw̃ANV
	 * tH[BeanCX^X𐶐܂B                               <BR>
	 * NGXgpXƃANVyуtH[BeanƂ̊t
	 * /WEB-INF/itscool-config.xml<action-mappings>vfŒ`܂B     <BR>
	 * 
	 *                                                                      <P>
	 * y`t@C̋Lqz                                             <BR>
	 * <font size="2">                                                      <BR>
	 * &lt;action-mappings&gt;                                              <BR>
	 * @&lt;!-- OCANV --&gt;                                  <BR>
	 * @&lt;action                                                         <BR>
	 * @@&lt;-- OCs̃NGXgpXw肵܂B --&gt;       <BR>
	 * @@path="/login.do"                                                 <BR>
	 * @@&lt;-- NGXgɑΉANVNXݒ --&gt;         <BR>
	 * @@type="org.itscoolSample.action.LoginAction"&gt;                  <BR>
	 * @@&lt;-- tH[ɃZbgp[^`FbN                <BR>
	 * @@@@@NXݒ ---&gt;                                   <BR>
	 * @@&lt;-- tH[h̑Jڐݒ --&gt;                           <BR>
	 * @@&lt;forward name="success" path="/input.jsp"/&gt;                <BR>
	 * @@&lt;forward name="fail" path="/fail.jsp"/&gt;                    <BR>
	 * @@&lt;/action&gt;                                                  <BR>
	 *                                                                      <BR>
	 * @@&lt;-- [̓ANV --&gt;                                 <BR>
	 * @@&lt;action                                                       <BR>
	 * @@@@path="/input.do"                                             <BR>
	 * @@@@type="org.itscoolSample.action.InputAction" &gt;             <BR>
	 * @@@@&lt;forward name="success" path="/confirm.jsp"/&gt;          <BR>
	 * @@@@&lt;forward name="fail" path="/fail.jsp"/&gt;                <BR>
	 * @@&lt;/action&gt;                                                  <BR>
	 * &lt;/action-mappings&gt;                                             <BR>
	 * </font>                                                              <BR>
	 *                                                                      <BR>
	 * 
	 * @param req HttpNGXgCX^X
	 * @param res HttpX|XCX^X
	 * @return ̑JڐJSPԂ܂
	 * @throws Exception proecessɎsƗOExceptionX[܂B
	 */
	private String process( HttpServletRequest req, HttpServletResponse res )
	throws Exception{
		Action action = createAction(req, res);
        String name = action.execute();
        
        //sʂuʑJږv̏ꍇ
        if(name.equals(Globals.RET_NOFORWARD)){
        	return Globals.RET_NOFORWARD;
        }
        
        //==========================================================================================
        //rWlXWbŇʂ擾
        //==========================================================================================
        String jsp = action.getForward(name);
        
        if (jsp == null) {
			String err =
				"["
					+ "ACTION:" + action.getClass().getName()
					+ "NAME:" + name
					+ "]"
					+ "Can not found forward ("
					+ FrontServlet.class.getName()
					+ ")";
			throw new ServletException(err);
		}
        return jsp;
	}
	
	/**
	 * NGXgɑΉActionCX^X𐶐܂
	 * @param req HttpNGXgCX^X
	 * @param res HttpX|XCX^X
	 * @return NGXgɑΉActionCX^XԂ܂
	 * @throws Exception
	 */
	public Action createAction( HttpServletRequest req, HttpServletResponse res )
	throws ServletException, IOException{
		//WebuEU痈镶R[hw
		InitParamMap info = InitParamMap.getInstance();
	
		//==========================================================================================
        //GR[fBO
        //==========================================================================================
	    String encode = (String) info.getParam("encoding");
	    try {
			req.setCharacterEncoding(encode);
		} catch (java.io.UnsupportedEncodingException uee) {
			throw new ServletException(uee);
		}
		
		//==========================================================================================
        //t@C]ʏPOST
        //t@C]̏ꍇ̓ftHgMultipartPostItemsCX^Xԋp
        //ʏPOSTȂSimplePostRequestԋp
        //==========================================================================================
		GeneralFormFactory factory = GeneralFormFactory.getInstance();
        GeneralForm hgForm = factory.create(req, encode);
        
	    String path = req.getServletPath();
		//add 2005/11/10 kano start
	    //pathInfo͒P̃eXgpɎgp
	    String pathInfo = req.getPathInfo();
		if(pathInfo != null){
			path = pathInfo;
		}
		//System.out.println(pathInfo);
		//System.out.println(path);
		//add 2005/11/10 kano end
		
	    log.debug("---------- servlet infomation!!! --------------- ");
	    log.debug("[ServerName]" + req.getServerName() );
	    log.debug("[ContextPath]" + req.getContextPath());
	    log.debug("[ServletPath]" + req.getServletPath());
	    log.debug("[PathInfo]" + req.getPathInfo());
	    log.debug("[QueryString]" + req.getQueryString());
	    log.debug("[RequestURI]" + req.getRequestURI());
	    log.debug("[RequestURL]" + req.getRequestURL());
		
		//input.dosave.dõpXAction擾
		Action action = getAction(req, path);
		if (action == null) {
			String err =
				"["
					+ path
					+ "]"
					+ "Can not found action ("
					+ FrontServlet.class.getName()
					+ ")";
			throw new ServletException(err);
		}
        		
        //======================================================================================
        //NGXgp[^̃Zbg
        //======================================================================================
        Object bean = getForm(path);
    
        if (bean == null) {
//modify 2006/01/19 kano start 
        	//GereralFormΉ(Vv[c)
        	bean = (GeneralForm)hgForm;
//modify 2006/01/19 kano end
        //tH[Bean݂ꍇBeanIuWFNgɃp[^Zbg
        }else{
            setRequestParam(bean, hgForm);
        }
        
        //======================================================================================
        //[U擾
        //======================================================================================
        HashMap roles = getRoles(path);

        //======================================================================================
        //rWlXWbNs
        //======================================================================================
        action.init(this, req, res, bean, roles, hgForm);
        
        return action;
	}
	
//	/**
//     * NGXgp[^̌؏s܂
//     * 
//	 * @param req HttpNGXgCX^X
//	 * @param res HttpX|XCX^X
//	 * @param postReq NGXgp[^ێCX^X
//	 * @param action ActionCX^X
//	 * @param bean tH[IuWFNg
//	 * @param roles Xg
//	 * @return String ANVsʂ̘_
//	 * @throws Exception
//	 */
//	protected HashMap doValidate(Action action, HttpGeneralForm postReq) throws Exception{
//	    HashMap errList = action.validate(postReq);
//	    return errList;
//	}
//	
//	/**
//	 * ANVs
//	 * 
//	 * @param req HttpNGXgCX^X
//	 * @param res HttpX|XCX^X
//	 * @param postReq NGXgp[^ێCX^X
//	 * @param action ActionCX^X
//	 * @param bean tH[IuWFNg
//	 * @param roles Xg
//	 * @return String ANVsʂ̘_
//	 * @throws Exception
//	 */
//	protected String doExecute(HttpServletRequest req, HttpServletResponse res, HttpGeneralForm postReq,
//	        Action action, Object bean, HashMap roles)
//		throws Exception {
//		
//	    //======================================================================================
//        //rWlXWbNs
//        //======================================================================================
//        String name = action.execute(this, req, res, bean, roles);
//        
//        return name;
//	}
//    
//    /**
//     * tH[G[̍ē͏
//     * NGXgp[^̒lăZbgȂ
//     * @param req HttpServletRequestCX^X
//     */
//	protected static void setRetryInputParam(HttpServletRequest req, HttpGeneralForm postReq) {
//        Set keySet = postReq.keySet();
//        Iterator it = keySet.iterator();
//
//        while( it.hasNext() ){
//            String paramName = (String)it.next();
//            Object paramValue = postReq.get(paramName);
//            if(paramValue instanceof UploadFile){
//                UploadFile file = (UploadFile)paramValue;
//                String value = file.getPath() + System.getProperty("file.separator")
//                    + file.getFileName();
//                req.setAttribute(paramName, value);
//            }else{
//                req.setAttribute(paramName, paramValue);
//            }
//        }
//	}
	
	protected String getStackTrace(StackTraceElement[] traceList){
		String LINE = System.getProperty("line.separator");
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < traceList.length; i++) {
			StackTraceElement trace = traceList[i];
			sb.append(trace.toString()).append(LINE);
		}
		return sb.toString();
	}
	
	/**
	 * Oo͂܂<BR
	 * Õ͔NXŃLb`ČďoƂ̃NXthrow
	 * ƂɂAÕg[XǐՂ鎖ł܂<BR>
	 * Õg[XJDK1.4œꂽException.getStackTrace()
	 * \bhgėOg[XĂ܂
	 * @param e ExceptionCX^X
	 * @return G[y[WɑJڂꍇtrueԂ܂
	 */
	protected boolean exception(
		HttpServletRequest req,
		HttpServletResponse res,
		String exceptionName1,
		String exceptionName2,
		Exception e)
		throws IOException, ServletException {
		String msg = e.getMessage();
        if( msg == null ){
            msg =e.getClass().getName();
        }
        log.error(msg);
        StackTraceElement[] traceList = e.getStackTrace();
        log.error(getStackTrace(traceList));
//		StackTraceElement[] traceList = e.getStackTrace();
//		for (int i = 0; i < traceList.length; i++) {
//			StackTraceElement trace = traceList[i];
//			log.error(trace.toString());
//		}

		//---------------------
		//G[y[W̑Jڔ
		//---------------------
		ExceptionMappings mapping = ExceptionMappings.getInstance();
        ExceptionMapping exception = mapping.get(e);
		
		if (exception != null) {
            String jsp = exception.getPath();
			req.setAttribute(Globals.REQ_PARAM_SYSTEM_ERR_MSG, msg);
			req.setAttribute(Globals.REQ_PARAM_SYSTEM_ERR, traceList);
			//getServletContext().getRequestDispatcher(path).forward(req, res);
			RequestDispatcher rd = req.getRequestDispatcher(jsp);
			rd.forward(req, res);
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * Oo͂܂<BR
	 * Õ͔NXŃLb`ČďoƂ̃NXthrow
	 * ƂɂAÕg[XǐՂ鎖ł܂<BR>
	 * Õg[XJDK1.4œꂽException.getStackTrace()
	 * \bhgėOg[XĂ܂
	 * @param e ExceptionCX^X
	 * @return G[y[WɑJڂꍇtrueԂ܂
	 */
	protected boolean exception(
		HttpServletRequest req,
		HttpServletResponse res,
		String exceptionName1,
		String exceptionName2,
		Error e)
		throws IOException, ServletException {
		String msg = e.getMessage();
        if( msg == null ){
            msg =e.getClass().getName();
        }
        log.error(msg);
		StackTraceElement[] traceList = e.getStackTrace();
        log.error(getStackTrace(traceList));
//		for (int i = 0; i < traceList.length; i++) {
//			StackTraceElement trace = traceList[i];
//			log.error(trace.toString());
//		}

		//---------------------
		//G[y[W̑Jڔ
		//---------------------
		ExceptionMappings mapping = ExceptionMappings.getInstance();
        ExceptionMapping exception = mapping.get(e);
		
		if (exception != null) {
            String jsp = exception.getPath();
			req.setAttribute(Globals.REQ_PARAM_SYSTEM_ERR_MSG, msg);
			req.setAttribute(Globals.REQ_PARAM_SYSTEM_ERR, traceList);
			//getServletContext().getRequestDispatcher(path).forward(req, res);
			RequestDispatcher rd = req.getRequestDispatcher(jsp);
			rd.forward(req, res);
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * NGXgpXActionCX^X擾܂B
	 * @param path NGXgpXw肵܂
	 * @return ꂽActionCX^X
	 */
	public Action getAction(HttpServletRequest req, String path)
		throws IOException {
		ActionMappings mappings = ActionMappings.getInstance();
		ActionMapping mapping = (ActionMapping) mappings.get(path);

		if (mapping == null) {
			String err = "Not found action for path(" + path + ")";
			throw new IOException(err);
		}

		Action action = (Action) BeanUtil.createInstance(mapping.getType());
		
		if( log.getLevel().equals(SimpleLog.DEBUG) ){
			HashMap roles = mapping.getRoles();
			StringBuffer roleNames = new StringBuffer();
			if( roles != null ){
				Set keySet = roles.keySet();
				Iterator it = keySet.iterator();
				while(it.hasNext()){
					Object key = it.next();
					roleNames.append(roles.get(key).toString());
					if(it.hasNext()){
						roleNames.append(", ");
					}
				}
			}else{
				roleNames.append("null");
			}
			log.debug("---------- request recieved!!!!! --------------- ");
			log.debug("PATH   : " + mapping.getPath());
			log.debug("ACTION : " + mapping.getType());
			log.debug("FORM   : " + mapping.getName());
			log.debug("ROLE   : " + roleNames.toString());
		}
		action.setForwards(mapping.getForwards());
		action.setValidates(mapping.getValidates());
		return action;
	}

	/**
	 * NGXgpXFormBeanCX^X擾܂B
	 * @param path NGXgpXw肵܂
	 * @return ꂽFormBeanCX^X
	 */
	public Object getForm(String path) throws IOException{
		ActionMappings mappings = ActionMappings.getInstance();
		ActionMapping mapping = (ActionMapping) mappings.get(path);
		String beanName = mapping.getName();

		if (beanName == null)
			return null;
		Object bean = (Object) BeanUtil.createInstance(beanName);
		//setRequestParam(req, bean);

		return bean;
	}
    
	/**
	 * NGXgp[^擾IuWFNgBeanɃp[^Zbg܂
	 * @param bean ZbgΏۂƂȂIuWFNgn܂i\bhśAp[^
     * ZbgꂽIuWFNgԂ܂j
     * @param hgForm HttpServletRequest̃p[^Zbg
	 */
	public void setRequestParam(Object bean, GeneralForm gForm) throws IOException{
        Set keySet = gForm.keySet();
        Iterator it = keySet.iterator();
        
        if( it.hasNext() ){
        	log.debug("---------- request parameter!!!! --------------- ");
        }
        
        while( it.hasNext() ){
            String paramName = (String)it.next();
            Object paramValue = gForm.getParameter(paramName);
            try {
            	//p[^̌^擾
            	Class clazz = BeanUtil.getReturnType(bean, paramName);
            	//`FbN{bNXΉ
            	//`FbN{bNXwɂāAP̃f[^I
            	//Ȃꍇ̑Ή
            	if(List.class.isAssignableFrom(clazz)
            		&& !List.class.isAssignableFrom(paramValue.getClass())){
            		ArrayList list = new ArrayList();
            		list.add(paramValue);
            		
//            		log.info("p[^["+paramName+"] ̃p[^͕݂邽ListC^[tF[XŃZbg܂");
            		
            		BeanUtil.setProperty(bean, paramName, list);
            	}else if(paramValue instanceof String || paramValue instanceof UploadFile){
            		
	                //Abv[hꂽt@CUploadFileŃZbg
	                //̂ŎMBeanɂUploadFile^ϐƑΉANZbT\bh
	                //KvI
	                BeanUtil.setProperty(bean, paramName, paramValue);
            	}else{
            		throw new ClassCastException(paramName + " is not match ["
            		+ clazz.getName() + "] but was [" + paramValue.getClass().getName() + "]");
            	}
                log.debug(paramName + " = " + paramValue);
            } catch (BeanUtilRuntimeException e) {
                //submit̖O(NAME)ȂǁABeanɊ֌WȂp[^
                //͖
//            	log.info("p[^["+paramName+"] ̃p[^̓tH[Beañoɑ݂Ȃ̂Ŗ܂");
            }
            
        }
	}

	/**
	 * NGXgURIɎw肳ꂽ擾܂<BR>
	 * 񂪒`ĂȂ΂NULLԂ܂
	 * @param path NGXgꂽURI
	 * @return HashMap ̃ANV錠XgԂ܂
	 */
	public HashMap getRoles(String path) {
		ActionMappings actionMappings = ActionMappings.getInstance();
		ActionMapping actionMapping = (ActionMapping) actionMappings.get(path);

		if (actionMapping.getRoles() == null) {
			return null;
		}
		HashMap roles = actionMapping.getRoles();
		return roles;
	}
}
