package org.itscool.stylist.tag;

import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.util.ServletTagUtil;

public class LayoutRegex {
	private ServletContext context;
	private HttpServletRequest req;
	
	public LayoutRegex(ServletContext context, HttpServletRequest req){
		this.context = context;
		this.req = req;
	}
	
	public String replacePath(String dstStr){
		String replace = "\""+req.getContextPath() + "/";
		Pattern pattern;
		Matcher matcher;
		StringBuffer criteria = new StringBuffer();
		criteria.append("<a.*href\\s*=\\s*\".*\"");
		criteria.append("|<img.*src\\s*=\\s*\".*\"");
		criteria.append("|<link.*src\\s*=\\s*\".*\"");
		criteria.append("|<link.*href\\s*=\\s*\".*\"");
		criteria.append("|<script.*src\\s*=\\s*\".*\"");
		criteria.append("|<.*background\\s*=\\s*\".*\"");
		criteria.append("|<form.*action\\s*=\\s*\".*\"");
		
		pattern = Pattern.compile(criteria.toString());
		matcher = pattern.matcher(dstStr);
		StringBuffer sb = new StringBuffer();
		while (matcher.find()) {
			StringBuffer sb2 = new StringBuffer();
			String element = matcher.group();
			//System.out.println("group:"+element);
			boolean flg = false;
			Pattern pattern2 = Pattern.compile("\"\\./");
			Matcher matcher2 = pattern2.matcher(element);
			while( matcher2.find() ){
				String path = matcher2.group();
				//System.out.println(path);
				
				matcher2.appendReplacement(sb2, replace);
				flg = true;
			}
			matcher2.appendTail(sb2);
			String tag = sb2.toString();
			if( flg == true){
				tag = supressPath(tag);
			}
//			System.out.println("tag:"+tag);
//			System.out.println(sb2.toString());
			matcher.appendReplacement(sb, tag);
		}
		matcher.appendTail(sb);
		return sb.toString();
	}
	

	public static String supressPath(String tag){
		Pattern pattern;
		Matcher matcher;
		
		pattern = Pattern.compile("\\.\\./");
		matcher = pattern.matcher(tag);
		StringBuffer sb = new StringBuffer();
		while (matcher.find()) {
			
			matcher.appendReplacement(sb, "");
		}
		matcher.appendTail(sb);
		return sb.toString();
	}
	
	public String replaceEl(String dstStr) {
		Pattern pattern;
		Matcher matcher;

		/* ̒u(X) */
		pattern = Pattern.compile("\\$\\{\\s*\\b([A-Za-z_0-9|.|\\(|\\)]*)\\s*\\}");
		matcher = pattern.matcher(dstStr);
		StringBuffer sb = new StringBuffer();
		while (matcher.find()) {
			String el = matcher.group();
//			System.out.println("el:"+el);
			
			String value = parseObj(el);
			matcher.appendReplacement(sb, value);
		}
		matcher.appendTail(sb);
		return sb.toString();
	}
	
	public String parseObj(String dstStr){
		StringBuffer sb2 = new StringBuffer();
		Pattern pattern2;
		Matcher matcher2;
		
		/* ^O̒g */
		pattern2 = Pattern.compile("\\s*\\b([A-Za-z_0-9|.]*)\\s*");
		matcher2 = pattern2.matcher(dstStr);
		if( !matcher2.find() ){
			return null;
		}
		String tag = matcher2.group();
//		System.out.println("tag:" + tag);
		
		ElementList elems = createElementList(tag);
		int size = elems.size();
		String name = elems.getElement(0);
		if( size > 1 ){
			String property = elems.getElement(1);
			Object obj = ServletTagUtil.findProperty(context, req, name, property, null);
			if( size > 2 ){
				for( int i=2; i<size; i++ ){
					property = elems.getElement(i);
					obj = BeanUtil.getProperty(obj, property);
	//				obj = getProperty(obj, property);
				}
			}
			return obj.toString();
		}else{
			Object obj = ServletTagUtil.findObject(context, req, name, null);
			return obj.toString();
		}
		
	}
	
	protected ElementList createElementList(String property){
		ElementList elems = new ElementList();
		StringTokenizer propertySt = new StringTokenizer(property, ".");
    	while(propertySt.hasMoreTokens()){
        	property = propertySt.nextToken().trim();
        	property = property.substring(0, property.length());
        	elems.add(property);
        }
    	return elems;
	}

}

class ElementList extends LinkedList{
	public static final String LINE=System.getProperty("line.separator");
	public String toString(){
		StringBuffer sb = new StringBuffer();
		int listSize = this.size();
		for(int i=0; i<listSize; i++ ){
			String str = (String)this.get(i);
			sb.append(str);
			if( (i+1) < listSize ){
				sb.append(", ");
			}
		}
		
		return sb.toString();
	}
	
	public String getElement(int index){
		return (String)this.get(index);
	}
}