package org.itscool.stylist.io;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import org.itscool.commons.util.ServletTagUtil;
import org.itscool.weber.action.Globals;

/**
 * XHTMLɊ܂܂G[o̓^Of[^ɕϊ܂
 * @author kano
 * @version 1.00A 2006/08/09 VK쐬
 */
public class HtmlErrorInfoTagConverter extends HtmlConverter {
	
	/**
	 * CX^X̏s܂
	 * @param context ServletContextCX^X
	 * @param req HttpServletRequestCX^X
	 */
	public HtmlErrorInfoTagConverter(ServletContext context,
			HttpServletRequest req) {
		super(context, req);
	}
	
	/**
	 * pXHTMLf[^̍쐬Jn܂
	 * @param node HtmlTagCX^X
	 * @return f[^
	 */
	public String convert() {
		StringBuffer sb = new StringBuffer();

		HashMap errMap =
			(HashMap)ServletTagUtil.findObject(
				context, req,
				Globals.REQ_PARAM_FORM_ERR,
				ServletTagUtil.SCOPE_REQUEST);
		StackTraceElement[] errTrace =
			(StackTraceElement[])ServletTagUtil.findObject(
			context, req,
			Globals.REQ_PARAM_SYSTEM_ERR,
			ServletTagUtil.SCOPE_REQUEST);
		String errMsg =
			(String)ServletTagUtil.findObject(
			context, req, 
			Globals.REQ_PARAM_SYSTEM_ERR_MSG,
			ServletTagUtil.SCOPE_REQUEST);
			
		if( errMap == null && errTrace == null && errMsg == null ){
			return "";
		}
		
		//VXeO`FbN
        if ( errTrace != null && errMsg != null &&
        errTrace.length > 0 && errMsg.length() > 0 ){
			sb.append(createErrObject(errTrace, errMsg));
        //tH[̓G[`FbN
		}else if (errMap != null) {
			sb.append(createErrObject(errMap));
        }
		
		//G[̍폜
		req.removeAttribute(Globals.REQ_PARAM_FORM_ERR);
		return sb.toString();
	}
	
	/**
	 * G[o͕쐬܂
	 * @param map FrontServletŃZbgꂽG[Xg
	 * @return G[o͕
	 */
	private String createErrObject(HashMap map) {
		//tH[̓G[IuWFNg擾܂
		StringBuffer sb = new StringBuffer();
		
		//G[o͂܂
		Collection values = map.values();
		Iterator it = values.iterator();
		
		sb.append("<div align=\"center\">").append(LINE);
		while (it.hasNext()) {
			sb.append((String) it.next() + "<BR>").append(LINE);
		}
		sb.append("</div>").append(LINE);
		sb.append("<HR>").append(LINE);
		return sb.toString();
	}
	
	/**
	 * G[o͕쐬܂
	 * @param errObject ÕX^bNg[XXg
	 * @param errMsg ŏʂ̃G[bZ[W
	 * @return G[o͕
	 */
	private String createErrObject(StackTraceElement[] errObject,
	String errMsg){
		//tH[̓G[IuWFNg擾܂

		//G[o͂܂
		StringBuffer sb = new StringBuffer();
		sb.append("<div align=\"left\">");
		sb.append(errMsg);
		sb.append("<HR>");
		sb.append(LINE);
		for( int i=0; i<errObject.length; i++ ){
			sb.append("    at ");
			sb.append((String) errObject[i].toString() + "<BR>");
			sb.append(LINE);
		}
		sb.append("</div>").append(LINE);
		return sb.toString();
	}
}
