package org.itscool.stylist.io;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.StringTokenizer;

import org.itscool.commons.document.XmlConfigReader;
import org.itscool.stylist.tag.HtmlAttribute;
import org.itscool.stylist.tag.HtmlRootTag;
import org.itscool.stylist.tag.HtmlTag;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * XHTML͂܂<BR>
 * ͌ʂHtmlTagNXɍ쐬܂
 * @author KANO
 * @version 1.00A 2006/08/09 VK쐬
 */
public class HtmlConfigReader extends XmlConfigReader{
	public static final String LINE = System.getProperty("line.separator");
	
	/**
     * DocumentBuildergXMLt@Cǂݍ݂܂
     * <!DOCTYPE͓ǂݔ΂܂
     * @param path RtBOt@C̃pXw肵܂
     * @param nodeList ǂݍDOMi[CX^Xw肵܂
     * @throws Exception t@C̓ǂݍ݂Ɏsꍇ͗OExceptionX[܂
     */
    public void create(String uri, byte[] buf, LinkedList nodeList ) throws IOException{
		String bufStr = new String(buf);
		int xmlStartPos = bufStr.indexOf("<?xml");
		int xmlEndPos = bufStr.indexOf("?>");
		int dtdStartPos = bufStr.indexOf("<!DOCTYPE");
		int dtdEndPos = bufStr.indexOf("dtd\">");
		
		String xml = null;
		String dtd = null;
		String xhtml = null;
		
		//xml^O̒`ȂꍇparseȂ
		if(xmlStartPos < 0 ){
			return;
		}
		xml = bufStr.substring(0, xmlEndPos+2);
//		int encStartPos = xml.indexOf("encoding=\"");
//		if( encStartPos < 0 ){
//			throw new IOException("No defined encoding to xml tag.");
//		}
//		String stack = xml.substring(encStartPos+("encoding=\"").length());
//		int encEndPos = stack.indexOf("\"");
//		if( encEndPos < 0 ){
//			throw new IOException("Can't convert encoding to xml tag.");
//		}
//		String encode = stack.substring(0, encEndPos);
		
		if( dtdEndPos > 0 ){
			dtd = bufStr.substring(dtdStartPos, dtdEndPos+5);
			xhtml = bufStr.substring(dtdEndPos+5, bufStr.length());
		}else if(xmlStartPos >= 0){
			xhtml = bufStr.substring(xmlEndPos+2, bufStr.length());
		}
//		System.out.println("xml:"+xml);
//		System.out.println("encode:"+encode);
//		System.out.println("dtd:"+dtd);
//		System.out.println("xhtml:"+xhtml);
		
		String cnvStr;
		if(xml != null){
			cnvStr = xml + xhtml;
		}else if(dtdEndPos > 0){
			cnvStr = xhtml;
		}else{
			cnvStr = bufStr;
		}
		HtmlRootTag top;
		if( nodeList instanceof HtmlRootTag ){
			top = (HtmlRootTag)nodeList;
		}else{
			throw new ClassCastException("filed cast HtmlRootTag => " + 
				nodeList.getClass().getName());
		}
		top.setXml(xml);
		top.setDtd(dtd);
//		top.setEncode(encode);
		super.create(uri, cnvStr.getBytes(), nodeList);
	}
	
	/**
     * DocumentBuildergXMLt@Cǂݍ݂܂
     * <!DOCTYPE͓ǂݔ΂܂
     * ƂŁA[JEt@C̓ǂݍ݂java.io.FileReaderNX
     * ĝ͂߂łȂB
     * ȂȂFileReaderNXJVM̃ftHgEGR[fBOɂ
     * ΉĂ炸Aǂݍݎ̕R[h𖾎IɎwłȂłB
     * ftHgEGR[fBÓAWindowsJVMłWindows-31JiMS932j
     * ƂȂAUNIXłLANGϐŐݒ肳ꂽR[hiEUC-JPUTF-8Ȃǁj
     * ɂȂB
     * ̂߁AႦWindowsŊJʕLinuxT[oŉ^p
     * P[XȂǂɂāAftHgEGR[eBÖႢɂ镶
     * ₷B
     * @
     * JavaAvP[VJł́AR[hftHgE
     * GR[eBOɈˑȂ悤ɐS|悤B
     * Ⴆ΃eLXgEt@Cǂݍޏꍇ́Aȉ̂悤
     * FileInputStreamNXInputStreamReaderNXŎɂ΂悢낤B
     * 
     * InputStreamReader isr = new InputStreamReader(
     *     new FileInputStream("filename.txt"), "Windows-31J"); 
     * @param path RtBOt@C̃pXw肵܂
     * @param nodeList ǂݍDOMi[CX^Xw肵܂
     * @throws Exception t@C̓ǂݍ݂Ɏsꍇ͗OExceptionX[܂
     */
    public void create(String path, LinkedList nodeList ) throws IOException{
    	HtmlRootTag top;
    	if( nodeList instanceof HtmlRootTag ){
			top = (HtmlRootTag)nodeList;
		}else{
			throw new ClassCastException("filed cast HtmlRootTag => " + 
				nodeList.getClass().getName());
		}
    	String encode = top.getEncode();
    	ByteArrayOutputStream bout = new ByteArrayOutputStream();
//    	BufferedReader br = new BufferedReader(new FileReader(path));
    	InputStreamReader isr = new InputStreamReader(
    		    new FileInputStream(path), encode); 
    	BufferedReader br = new BufferedReader(isr);
    	String line ;
    	
    	while((line=br.readLine()) != null){
//    		if(line.trim().indexOf("<?xml")==0 ){ 
    		if(line.indexOf("<?xml")>=0 ){ 
    	    	if( line.trim().lastIndexOf("?>")!=-1 ){
    				top.setXml(line);
    			}else{
    				StringBuffer xml = new StringBuffer(line);
    				while((line=br.readLine()) != null){
    					xml.append(line);
    					if( line.trim().lastIndexOf("?>")!=-1 ){
    						break;
    					}
    				}
    				top.setXml(xml.toString());
    			}
    		}
    		if(line == null ){
    			continue;
    		}
    		if(line.trim().indexOf("<!DOCTYPE")==0 ){
    			if( line.trim().lastIndexOf(">")!=-1 ){
    				top.setDtd(line);
    			}else{
    				StringBuffer dtd = new StringBuffer(line);
    				while((line=br.readLine()) != null){
    					dtd.append(line);
    					if( line.trim().lastIndexOf(">")!=-1 ){
    						break;
    					}
    				}
    				top.setDtd(dtd.toString());
    			}
    			continue;
    		}
    		bout.write(line.getBytes());
    		bout.write(LINE.getBytes());
    	}
    	if( top.getXml() == null || top.getXml().length() == 0 ){
    		return;
    	}
    	super.create(path, bout.toByteArray(), nodeList);
    }
    
    /**
     * DocumentBuildergXMLt@Cǂݍ݂܂
     * <!DOCTYPE͓ǂݔ΂܂
     * @param path RtBOt@C̃pXw肵܂
     * @param encode GR[hw肵܂
     * @param nodeList ǂݍDOMi[CX^Xw肵܂
     * @throws Exception t@C̓ǂݍ݂Ɏsꍇ͗OExceptionX[܂
     */
    public String create(String path, String encode) throws IOException{
    	ByteArrayOutputStream bout = new ByteArrayOutputStream();
//    	BufferedReader br = new BufferedReader(new FileReader(path));
    	InputStreamReader isr = new InputStreamReader(
    		    new FileInputStream(path), encode); 
    	BufferedReader br = new BufferedReader(isr);
    	String line ;
    	StringBuffer sb = new StringBuffer();
    	while((line=br.readLine()) != null){
    		sb.append(line).append(LINE);
    	}
    	
    	return sb.toString();
    }
    
	/**
     * XMLt@C&lt;table&gt;vf͂܂<br>
     * ͌ʂdataListɃZbg܂<br>
     * @param dataList XML̉͌
    */
    protected void doCreate(LinkedList dataList) throws IOException{
        /* [g^O擾 */
        Element root = document.getDocumentElement();
        if( root == null ){
            String err = "Can not root element at weber-message.xml(" + 
                getClass().getName()+")";
            throw new IOException(err);
        }
        
        /* action-mappings ̎擾*/
        HtmlTag tag = (HtmlTag)dataList;
        tag.setTagKind(HtmlTag.KIND_TAG);
        tag.setTagName(root.getTagName());
        NamedNodeMap attrs = root.getAttributes();
        addAttribute(tag, attrs);
        NodeList nodeList = root.getChildNodes();
        createTagTree(nodeList, tag);
    }
    
    /**
     * HTML^Õc[\z܂
     * @param nodeList NodeListCX^X
     * @param parent e^O
     * @throws IOException
     */
    protected void createTagTree(NodeList nodeList, HtmlTag parent)
    throws IOException {
    	String nodeValue;
    	String nodeName;
        for( int i = 0; i < nodeList.getLength(); i++) {
            Node node = nodeList.item(i);
            NamedNodeMap attrs = node.getAttributes();
            NodeList childList = node.getChildNodes();
            HtmlTag childTag;
            int childSize = childList.getLength();
            
            if( node.getNodeValue() != null && 
            	node.getNodeValue().length() > 0 ){
            	nodeValue = node.getNodeValue().trim();
            }else{
            	nodeValue = "";
            }
            nodeName = node.getNodeName();
        	if( nodeName.equals(HtmlTag.TEXT) && nodeValue.length()==0){
            	continue;
            }
            
            if( nodeName.equals(HtmlTag.TEXT) ){
            	childTag = createHtmlTag(HtmlTag.KIND_TEXT, nodeValue, attrs);
            }else if( nodeName.equals(HtmlTag.COMMENT)){
            	childTag = createHtmlTag(HtmlTag.KIND_COMMENT, nodeValue, attrs);
            }else if( childSize > 0 || nodeName.equals(HtmlTag.TAG_TEXTAREA)){
            	childTag = createHtmlTag(HtmlTag.KIND_TAG, nodeName, attrs);
            }else if( nodeName.equals("#cdata-section")){
//            	System.out.println("nodeName="+node.getNodeName());
//            	System.out.println("nodeValue="+node.getNodeValue());
//            	System.out.println("nodeType="+node.getNodeType());
            	childTag = createHtmlTag(HtmlTag.KIND_CDATA, nodeValue, attrs);
            }else{
            	childTag = createHtmlTag(HtmlTag.KIND_SIMPLE_TAG, nodeName, attrs);
            }
            childTag.setParent(parent);
            parent.add(childTag);
            createTagTree(childList, childTag);
            
        }
    }
    
    /**
	 * ^Oe^Oɒǉ
	 * @param tagKind ^O
	 * @param tagName ^O
	 * @return ̏ɂĐꂽ^O
	*/
	protected HtmlTag createHtmlTag(String tagKind, String tagName, 
		NamedNodeMap attrs){
		
		HtmlTag tag = new HtmlTag();
		tag.setTagName(tagName);
		tag.setTagKind(tagKind);
		addAttribute(tag, attrs);
		
		return tag;
	}
	
	/**
	 * ǉ܂
	 * @param node ^O
	 * @param attrs 
	 */
	protected void addAttribute(HtmlTag node, NamedNodeMap attrs){
		if( attrs == null ){
			return;
		}
		int size = attrs.getLength();
		for(int i=0; i<size; i++){
			Node attrNode = attrs.item(i);
			String attrName = attrNode.getNodeName();
			String attrValue = attrNode.getNodeValue();
			if( attrName.equals(HtmlAttribute.TITLE) ){
				parseControlAttribute(node, attrNode);
	    	}else{
				HtmlAttribute attr = new HtmlAttribute();
				attr.setName(attrName);
				attr.setValue(attrValue);
				node.addAttribute(attr);
	    	}
		}
	}
	
	/**
     * vpeBXgɂ͈ȉ̏łKv܂B
     * <P>
     * ږ1=l1:ږ2=l2:ږ3=l3:ږ4=l4
     * <p>
     * @return ^OʂԂ܂
     */
    public void parseControlAttribute(HtmlTag node, Node attrNode) {
    	String attrName   = attrNode.getNodeName();
    	String properties = attrNode.getNodeValue();
    	
        if(properties==null || properties.length() == 0){
            return;
        }
        StringTokenizer dataSt = new StringTokenizer(properties, HtmlAttribute.SP);
        
        while (dataSt.hasMoreTokens()) {
        	String data = dataSt.nextToken().trim();
        	StringTokenizer propertySt = new StringTokenizer(data, HtmlAttribute.EQ);
        	//IuWFNg̎擾
        	String name = propertySt.nextToken();
        	if( name==null){
        		throw new RuntimeException("name is null query="+properties);
        	}else{
        		name = name.trim();
        	}
        	//vpeB̎擾
        	String property = null;
            if( propertySt.hasMoreTokens() ){
            	property = propertySt.nextToken();
            }
            HtmlAttribute attr = new HtmlAttribute();
			attr.setName(name);
			attr.setValue(property);
			node.addAttribute(attr);
			if( name!=null && property!=null && name.equals(HtmlAttribute.W_KIND)){
				//^OʂύX
				node.setTagKind(property);
			}
        }
    }
    
}
