package org.itscool.stylist.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.bean.InitParamMap;
import org.itscool.commons.document.XmlConfigReader;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.request.CustomPageResponseWrapper;
import org.itscool.commons.util.TagInfo;
import org.itscool.commons.util.TagUtil;
import org.itscool.stylist.io.LayoutConfigReader;
import org.itscool.stylist.mapping.LayoutMapping;
import org.itscool.stylist.mapping.LayoutMappings;
import org.itscool.stylist.mapping.LayoutPutMapping;
import org.itscool.stylist.tag.LayoutRegex;

/**
 * WebRec̃CAEgsFilterNXł<br>
 * stylistt[[NComposit Viewp^[gJSP̃CAEg
 * S郌CAEgGW̃NXŎ܂B<br>
 * <hr>
 * Composite Viewp^[ɂ<br>
 * <hr>
 * [Ƃ߂Ă͂܂B<br>
 * 悤ȉƂW܂cn݂ꍇAꂼƗvWFNg
 * ƂĊe˂̍Ƃɒ肷邱Ƃ͂Ȃł傤B<br>
 * ̑ɁA^ƂȂ݌vɂāAhAAAԎȂǂ̋ʗvf
 * ėp邱Ƃł傤B<br>
 * ̃p^[̔wiɂ̂͂̂悤ȍlłB<p>
 * 
 * WebAvP[V́Aj[AirQ[Vo[AƃSȂǂ́A
 * JԂgvfō\镡Gȉʂ̂ʓIłB<p>
 * 
 * Composite Viewp^[ł́AʂfЂɕAefЂꂼꊮP
 * ƂăR[fBO邱ƂĂ܂B<br>
 * ̃p^[́AWebAvP[V̉ʂ̃bNAhtB[𓝈ꂷ邽
 * ɖ𗧂Ar[̍\vf̍ėp𑣐i܂B<p>
 *
 * JSPpComposite Viewp^[̂͊ȒPłB
 * ̎ɗpł2̑gݍ݃JjY <%@ include> fBNeBu
 * includeANV܂B<p>
 * 
 * stylistt[[Nł́ALayoutFilterʂĎsꂽT[ubg̎s
 * ʂ⃌CAEgJSPɖߍJSPpXHttpServletRequestCX^XɃZbg
 * AIncludeTagincludefBNeBugČĂяoĂ܂
 * <p>
 * CAEg̒`stylist-config.xmlgĈȉ̂悤ɒ`܂B
 * <p>
 * [CAEg̐ݒ]
 * <p>
 * <?xml version="1.0" encoding="Shift_JIS" ?>
 * <stylist-config>
 *   <layout 
 *        name="/*.do"
 *        path="/WEB-INF/jsp/layout.jsp">
 *        <!-- ̃CAEgɔzuJSPw肵܂                     -->
 *        <!-- T[ubg̎sʂname=bodyɃZbg܂B     -->
 *        <!-- name=bodystylistŗ\񂳂ĂL[[hł邽  -->
 *        <!-- layoutvfɂ̓ZbgȂł                       -->
 *        <!--yz                                                     -->
 *        <!-- name F CAEgɔzuJSP̘_w肵܂         -->
 *        <!-- path F CAEgɔzuJSP̃pXw肵܂           -->
 *        <!-- extendsF-->
 *        <put name="header" path="/WEB-INF/jsp/header.jsp"/>
 *        <put name="menu" path="/WEB-INF/jsp/menu.jsp"/>
 *    </layout>
 * </layout-mappings>
 * </stylist-config>
 *
 * @author KANO 쐬F 2004/12/12
 * @version 1.11A 2005/05/20 Include@\폜iweberƂ̕j
 * @version 1.20A 2005/05/20 JSPsʂHTMLAHEADABODY菜ǉ
 * @version 1.30A 2006/06/23 ÓIReciHTML)Ήǉ
 */
public class LayoutFilter implements Filter {
	protected FilterConfig filterConfig = null;
	protected ServletContext context = null;
	private AbstractLog log;
	
	/**
	 * LayoutFilter܂<br>
	 * 
	 * stylist-config.xmlJSP̃CAEg[h܂<br>
	 * init()ŗOtomcat̋NɎŝŁAOLb`
     * ꍇ̓X[catchď𐳏ɏIĂB
	 * @param config FilterConfigCX^X
	 */
	public void init(FilterConfig config) throws ServletException {
		if (filterConfig == null) {
			filterConfig = config;
		}
		if (filterConfig == null) {
			filterConfig = config;
		}
		context = filterConfig.getServletContext();
		BeanFactory factory = BeanFactory.getInstance();
		if( !factory.isInit() ){
			try{
        		factory.createForUrl("di-config.xml");
        	}catch(Exception ex){
        		ex.printStackTrace();
            	throw new ServletException(ex.getMessage());
        	}    
		}
		try{
			log = (AbstractLog)factory.getInstance("Log");
        	if(!log.isInit()){
        		log = (AbstractLog)factory.createInstance("Log");
        	}
        }catch(Exception ioe){
        	log = SimpleLog.getInstance();
        	log.info(ioe.getMessage());
        }
		LayoutMappings includeMappings = LayoutMappings.getInstance();
	    
		try {
//			ConfigReader includeReader = (ConfigReader)factory.createInstance("LayoutConfigReader");
//			includeReader.create(includeMappings);
			InitParamMap params = (InitParamMap)factory.createInstance("InitParams");
			String stylistConf = params.getParam("stylist-config");
			XmlConfigReader includeReader = new LayoutConfigReader();
			includeReader.setConfigName(stylistConf);
			includeReader.create(includeMappings);
		} catch (Exception ioe) {
			//throw new ServletException(ioe);
            ioe.printStackTrace();
		}
	}

	/**
	 * T[ubgNGXg̎sʂtbNāAJSP̃CAEgɖߍ݂܂<Br>
	 * @param request ServletRequestCX^X
	 * @param response ServletResponseCX^X
	 * @param chain FiltercahinCX^X
	 */
	public void doFilter(
		ServletRequest request,
		ServletResponse response,
		FilterChain chain)
		throws IOException, ServletException {

		HttpServletRequest req = (HttpServletRequest) request;
		HttpServletResponse res = (HttpServletResponse) response;
		
		//ServletResponsẽbp[IuWFNg쐬܂
		CustomPageResponseWrapper wrapper = new CustomPageResponseWrapper(res);

		//XvĂ\[XT[ubgɓn܂B
		//ServletResponse̓bp[IuWFNgnÃbp[IuWFNg
		//T[ubg̎sʂZbg܂
		chain.doFilter(req, wrapper);
//		add 2006/03/24 kano start
		//ÓIRec(HTML)Ή
		//ÓIRecFrontServletŃtH[hꍇA
		//ÓIRec̃TCYHeaderɃZbgA
		//CAEgJSPs̃TCYXVȂۂւ̑Ή
		//T[ubgsɁAX|XUNAB
		res.reset();
//add 2006/03/24 kano end
		
		try{
			//CAEg擾
			String path = req.getServletPath();
			String jsp = layout(path, req, res, chain);
			
			doLayout(chain, req, res, wrapper, jsp);
		}catch(Exception e){
			log.error(e);
			throw new ServletException(e.getMessage());
		}catch(Error e){
			log.error(e);
			throw new ServletException(e.getMessage());
		}
	}
	
	/**
	 * sʂ̃CAEgs܂
	 * @param req HttpServletRequestCX^X
	 * @param res HttpServletResponseCX^X
	 * @param wrapper NGXg̎s
	 * @param jsp CAEg
	 * @throws IOException
	 * @throws ServletException
	 */
	public void doLayout(
			FilterChain chain,
			HttpServletRequest req,
			HttpServletResponse res,
			CustomPageResponseWrapper wrapper,
			String jsp)
			throws IOException, ServletException {
		//NGXgURI擾
		//String uri = (req).getRequestURI();
		//System.out.println("uri:" + uri);
		InitParamMap params = InitParamMap.getInstance();
		
	    String encode = params.getParam("encoding");
	    if(encode == null){
	    	log.warn("No set inita param[encoding] default set[Shift_JIS]");
        	encode = "Shift_JIS";
        }
		
		//T[ubgŃtH[h/CN[hsꂽꍇ
		//sΏۂƂȂRec擾
//2005.05.20 -start-
//        String contentsName =
//			(String) (req).getAttribute(Globals.REQ_PARAM_INCLUDE_CONTENTS_NAME);
//2005.05.20 -en-

		//T[ubg̎sʂbytezŎ擾܂
		byte[] buff = wrapper.getByteStream().toByteArray();

//add 2006/10/03 kano start
		//JSP1.2EL(ȈՔ)g߂̏ǉ
        String buffStr = new String(buff);
        LayoutRegex regex = new LayoutRegex(context, req);
        //./Ŏn܂pXWebAvP[V̘_pXɕϊ
        buffStr = regex.replacePath(buffStr);
        //ELWJ
        buffStr = regex.replaceEl(buffStr);
//add 2006/10/03 kano end
        
        //ContentTypeݒ
//modify 2006/11/28 kano start
        if(wrapper.getContentType() != null){
        	res.setContentType(wrapper.getContentType());
        }else{
	        if(buffStr.indexOf("<?xml")>=0){
	        	
	        	res.setContentType("text/xml; charset=" + encode);
	        }else{
	        	res.setContentType("text/html; charset=" + encode);
	        }
        }
//modify 2006/11/28 kano end
        if(jsp==null){
        	//HTML̉͌ʂo
            PrintWriter writer = res.getWriter();
            writer.write(buffStr);
            writer.flush();
            writer.close();
        	return;
        }
//2005.05.20 -start-
        //JSPsʂbodyheadɓWJ܂
        TagInfo body = TagUtil.createTagInfo(buffStr, TagInfo.BODY_NAME);
        TagInfo head = TagUtil.createTagInfo(buffStr, TagInfo.HEAD_NAME);
        
        if( body != null ){
            //BODY̏o
            ((HttpServletRequest) req).setAttribute(Globals.REQ_PARAM_INCLUDE_BODY,
                body.getDataInTag());
            //BODYvfLq̏óiCAEgŐU蕪j
            ((HttpServletRequest) req).setAttribute(Globals.REQ_PARAM_INCLUDE_BODY_TAG,
                body.getStartTag());
            if(head != null ){
                //HEADvfLq̏óiCAEgŐU蕪j
                ((HttpServletRequest) req).setAttribute(Globals.REQ_PARAM_INCLUDE_HEAD,
                    head.getDataInTag());
            }
        }else{
            ((HttpServletRequest) req).setAttribute(
    			Globals.REQ_PARAM_INCLUDE_BODY,
    			buffStr);
        }
//2005.05.20 -end-

		//CAEgpjsptH[h܂
		filterConfig.getServletContext().getRequestDispatcher(jsp).
			forward(req, res);
	}
	
	public void destroy() {
	}

	/**
	 * CAEg擾܂
	 * @param path NCAgvꂽNGXgURI
	 * @param req HttpServletRequestCX^X
	 * @return CN[h܂ރtH[hJSP
	 */
	protected String layout(String path, HttpServletRequest req, 
		HttpServletResponse res, FilterChain chain) 
	throws IOException, ServletException{
		LayoutMappings mappings = LayoutMappings.getInstance();
		LayoutMapping include = (LayoutMapping) mappings.get(path);
		if (include == null) {
			//System.out.println("IncludeMapping is null.");
			return null;
		}

		String extendz = include.getExtendz();
		if (extendz != null) {
			//ẽCAEgvf܂
			checkParentLayout(include, req, res, chain);
		}

		String layoutPath = include.getPath();
		HashMap putMap = include.getPuts();
		if (putMap != null) {

			//namepathHttpServletRequestɃZbg
			//ƂJSP̃^OCu<jsp:include page="${path}" />
			//Ăяo΂njI
			Set keySet = putMap.keySet();
			Iterator it = keySet.iterator();

			while (it.hasNext()) {
				String name = (String) it.next();
				LayoutPutMapping put = (LayoutPutMapping) putMap.get(name);
				setIncludeContents(put, name, req, res, chain);
			}
		}

		return layoutPath;
	}

	/**
	 * ẽCAEg擾܂
	 * @param layout CAEg
	 * @param req HttpServletRequestCX^X
	 */
	protected void checkParentLayout(
		LayoutMapping layout,
		HttpServletRequest req, HttpServletResponse res, FilterChain chain) 
	throws IOException, ServletException{
		LayoutMappings mappings = LayoutMappings.getInstance();
		String parentName = layout.getExtendz();
		String extendz = layout.getExtendz();
		//Xɐe̗vfZbgĂȂ`FbN
		if (extendz != null) {
			LayoutMapping parent = (LayoutMapping) mappings.get(parentName);
			checkParentLayout(parent, req, res, chain);
		}

		HashMap putMap = layout.getPuts();
		if (putMap == null) {
			return;
		}

		//CAEgpJSPɃCN[hJSPt@C擾A
		//HttpServletRequestCX^XɃZbg
		Set keySet = putMap.keySet();
		Iterator it = keySet.iterator();
		while (it.hasNext()) {
			String name = (String) it.next();

			LayoutPutMapping put = (LayoutPutMapping) putMap.get(name);
			setIncludeContents(put, name, req, res, chain);
			
		}
	}
	
	/**
	 * CAEg񂩂畔Rec擾ANGXgp[^
	 * ɃZbg܂
	 * @param put CAEg
	 * @param attrName CAEg킷j[NȖO
	 * @param req HttpServletRequest
	 * @throws IOException
	 */
	protected void setIncludeContents(LayoutPutMapping put, 
	String attrName, HttpServletRequest req, HttpServletResponse res,
	FilterChain chain)
	throws IOException, ServletException{
//modify 2006/10/03 kano start
//		CN[hJSPt@CNGXgp[^ɃZbg
//		namepathHttpServletRequestɃZbg
//		ƂJSP̃^OCu<jsp:include page="${path}" />
//		Ăяo΂njI
//		req.setAttribute(Globals.REQ_PARAM_INCLUDE + attrName, put);
		
		//ServletResponsẽbp[IuWFNg쐬܂
		CustomPageResponseWrapper wrapper = new CustomPageResponseWrapper(res);
		
		//XvĂ\[XT[ubgɓn܂B
		//ServletResponse̓bp[IuWFNgnÃbp[IuWFNg
		//T[ubg̎sʂZbg܂
		RequestDispatcher rd = req.getRequestDispatcher(put.getPath());
		rd.forward(req, wrapper);
		byte[] buff = wrapper.getByteStream().toByteArray();
        String buffStr = new String(buff);
        //JSPt@Cbody𒊏o܂
        TagInfo body = TagUtil.createTagInfo(buffStr, TagInfo.BODY_NAME);
        if(body != null && body.getDataInTag() != null){
        	buffStr = body.getDataInTag();
        }
        LayoutRegex regex = new LayoutRegex(context, req);
        //./Ŏn܂pXWebAvP[V̘_pXɕϊ
        buffStr = regex.replacePath(buffStr);
        //ELWJ
        buffStr = regex.replaceEl(buffStr);
        req.setAttribute(Globals.REQ_PARAM_INCLUDE + attrName, buffStr);
//modify 2006/10/03 kano end
	}
	
//	/**
//	 * ZbV̍Đݒ
//	 * @param req HttpServletRequestCX^X
//	 * @param res HttpServletResponseCX^X
//	 */
//	private void initSessionTimeout(HttpServletRequest req, HttpServletResponse res){
//		//IE6Ń[JHTML̃NbL[ێȂۂւ̑Ή
//        HttpSession session = req.getSession();
//        if( session.isNew()){
//        	String sessionId = session.getId();
//	        // NbL[̔z擾
//	        Cookie cookies[] = req.getCookies();
//	        
//	        // ړĨNbL[i[ϐ
//	        Cookie accesstimeCookie = null;
//	         
//	        // ꂼ̃NbL[ɑ΂ĖOmF
//	        if(cookies != null) {
//	            for(int i = 0; i < cookies.length; i++) {
//	                // O "accesstime" ł邩`FbN
//	                 if(cookies[i].getName().equals("JSESSIONID")) {
//	                     // YNbL[擾
//	                     accesstimeCookie = cookies[i];
//	                 }
//	             }
//	         }
//	        
//	        //O"JSESSIONID"AlݎłNbL[쐬
//	        Cookie cookie = new Cookie("JSESSIONID",sessionId);
//	        
//	        // NbL[̐ݒ
//	        cookie.setMaxAge(7 * 24 * 60 * 60); //LԂ1TԂɐݒ
//	        
//	        // NbL[𔭍s
//	        res.addCookie(cookie);
//	        log.debug("session is refleshed [session id="+sessionId+"]");
//        }
//	}
	
}
