package org.itscool.stylist.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.bean.InitParamMap;
import org.itscool.commons.document.XmlConfigReader;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.util.TagInfo;
import org.itscool.commons.util.TagUtil;
import org.itscool.stylist.io.HtmlConfigReader;
import org.itscool.stylist.io.HtmlConverter;
import org.itscool.stylist.io.LayoutConfigReader;
import org.itscool.stylist.mapping.LayoutMapping;
import org.itscool.stylist.mapping.LayoutMappings;
import org.itscool.stylist.mapping.LayoutPutMapping;
import org.itscool.stylist.tag.HtmlRootTag;

/**
 * XHTML͂AsʂXHTML`ŏo͂NXł<br/>
 * StylistƎ̍\}邱ƂɂAIȉʕ\\ł<br/>
 * ܂x[XXHTML`ł邽߁AAjaxRSSƂ̘AgJSPV[X
 * sƂł܂B<br/>
 * 
 * @author kano
 * @version 1.00A 2006/08/09 VK쐬
 */
public class HtmlLayoutServlet extends HttpServlet{
	protected AbstractLog log;
	protected ServletContext context = null;
	
	/**
	 * HtmlLayoutServlet܂<br>
	 * 
	 * stylist-config.xmlHTML̃CAEg[h܂<br>
	 * init()ŗOtomcat̋NɎŝŁAOLb`
     * ꍇ̓X[catchď𐳏ɏIĂB
	 * @param config FilterConfigCX^X
	 */
	public void init(ServletConfig config) throws ServletException {
		context = config.getServletContext();
		BeanFactory factory = BeanFactory.getInstance();
		if( !factory.isInit() ){
			try{
        		factory.createForUrl("di-config.xml");
        	}catch(Exception ex){
        		ex.printStackTrace();
            	throw new ServletException(ex.getMessage());
        	}    
		}
		try{
			log = (AbstractLog)factory.getInstance("Log");
        	if(!log.isInit()){
        		log = (AbstractLog)factory.createInstance("Log");
        	}
        }catch(Exception ioe){
        	log = SimpleLog.getInstance();
        	log.info(ioe.getMessage());
        }
		LayoutMappings includeMappings = LayoutMappings.getInstance();
	    
		try {
			InitParamMap params = (InitParamMap)factory.createInstance("InitParams");
			String stylistConf = params.getParam("stylist-config");
			XmlConfigReader includeReader = new LayoutConfigReader();
			includeReader.setConfigName(stylistConf);
			includeReader.create(includeMappings);
			
		} catch (Exception ioe) {
			log.error(ioe);
		}
	}
	
	/**
	 * doGet܂
	 * @see javax.servlet.http.HttpServlet#doGet(
	 *         javax.servlet.http.HttpServletRequest, 
	 *         javax.servlet.http.HttpServletResponse)
	 */
	public void doGet(HttpServletRequest arg0, HttpServletResponse arg1)
		throws ServletException, IOException {
		execute(arg0, arg1);
	}

	/**
	 * doPost܂
	 * @see javax.servlet.http.HttpServlet#doPost(
	 *         javax.servlet.http.HttpServletRequest, 
	 *         javax.servlet.http.HttpServletResponse)
	 */
	public void doPost(HttpServletRequest arg0, HttpServletResponse arg1)
		throws ServletException, IOException {
		execute(arg0, arg1);
	}
	
	/**
	 * doGet()AdoPost()\bh̏s邽߂execute\bhĂт܂<br>
	 * VXeOꍇexception\bhĂяo܂B
	 * @param req HttpNGXgCX^X
	 * @param res HttpX|XCX^X
	*/
	protected void execute(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {
		try {
	        process(req, res);
	        
		} catch (IOException e) {
			String name1 = e.getClass().getName();
			String name2 = IOException.class.getName();
			exception(req, res, name1, name2, e);
			throw e;
		} catch (ServletException e) {
			String name1 = e.getClass().getName();
			String name2 = ServletException.class.getName();
			exception(req, res, name1, name2, e);
			throw e;
		} catch (NullPointerException e) {
			String name1 = e.getClass().getName();
			String name2 = NullPointerException.class.getName();
			exception(req, res, name1, name2, e);
			throw e;
		} catch (RuntimeException e) {
			String name1 = e.getClass().getName();
			String name2 = RuntimeException.class.getName();
			exception(req, res, name1, name2, e);
			throw e;
		} catch (Exception e) {
			String name1 = e.getClass().getName();
			String name2 = Exception.class.getName();
			exception(req, res, name1, name2, e);
			throw new ServletException(e.getMessage());
		} catch (Error e){
			String name1 = e.getClass().getName();
			String name2 = Exception.class.getName();
			exception(req, res, name1, name2, e);
			throw e;
		}
	}
	
	/**
	 * doGet()AdoPost()\bh̏s܂<br>
	 * @param req HttpNGXgCX^X
	 * @param res HttpX|XCX^X
	*/
	protected void process(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException {
		String path = context.getRealPath(req.getServletPath());
//		if( path.indexOf("/") == 0){
//			path = req.getRequestURL() + path.substring(1, path.length());
//		}else{
//			path = req.getRequestURL() + path;
//		}
		log.debug("------------ HtmlLayoutServlet Information ------------");
		log.debug("[RequestPath]" + path );
	    log.debug("[ServerName]" + req.getServerName() );
	    log.debug("[ContextPath]" + req.getContextPath());
	    log.debug("[ServletPath]" + req.getServletPath());
	    log.debug("[PathInfo]" + req.getPathInfo());
	    log.debug("[RequestURI]" + req.getRequestURI());
	    log.debug("[RequestURL]" + req.getRequestURL());
	    log.debug("[RequestEncoding]" + req.getCharacterEncoding());
	    log.debug("[ContentType]"+req.getContentType());
	    
//		RequestDispatcher rd = req.getRequestDispatcher(path);
//		rd.forward(req, res);
	    InitParamMap params = InitParamMap.getInstance();
		
	    String encode = params.getParam("encoding");
	    if(encode == null){
	    	log.warn("No set inita param[encoding] default set[Shift_JIS]");
        	encode = "Shift_JIS";
        }
		HtmlRootTag html = new HtmlRootTag(encode);
        HtmlConfigReader reader = new HtmlConfigReader();
        reader.create(path, html);
        String convStr;
        log.debug(html.toString(0, ""));
        
        String xml = html.getXml();
        if( xml != null && xml.length() > 0 ){
			HtmlConverter converter = new HtmlConverter(context, req);
			convStr = html.getXml()+System.getProperty("line.separator");
			convStr += html.getDtd()+System.getProperty("line.separator");
			convStr += converter.convert(html);
			
			//CAEg擾
			String servletPath = req.getServletPath();
			String layoutName = layout(servletPath, req);
			if( layoutName != null && xml != null && xml.length() > 0){
				//HTMLHEADBODYɓWJ
				TagInfo body = TagUtil.createTagInfo(convStr, TagInfo.BODY_NAME);
		        TagInfo head = TagUtil.createTagInfo(convStr, TagInfo.HEAD_NAME);
		        if( body != null ){
		            //BODY̏o
		            req.setAttribute(Globals.REQ_PARAM_INCLUDE_BODY,
		                body.getDataInTag());
		            if(head != null ){
		                //HEADvfLq̏óiCAEgŐU蕪j
		                req.setAttribute(Globals.REQ_PARAM_INCLUDE_HEAD,
		                    head.getDataInTag());
		            }
		        }else{
		            req.setAttribute(Globals.REQ_PARAM_INCLUDE_BODY, convStr);
		        }
		        
		        //CAEg͂܂
		        String contextPath = req.getServerName();
		        int port = req.getServerPort();
		        String layoutPath = context.getRealPath(layoutName);
		        HtmlRootTag layoutTag = new HtmlRootTag(encode);
		        HtmlConfigReader layoutReader = new HtmlConfigReader();
		        layoutReader.create(layoutPath, layoutTag);
		        convStr = converter.convert(layoutTag);
		        if( body != null ){
		        	//CAEgvfbodyvfCRecbodyvfɒu
		        	String bodyTagStr = body.getStartTag();
		        	Pattern pattern = Pattern.compile("<body>");
		        	Matcher matcher = pattern.matcher(convStr);
		    		convStr = matcher.replaceAll(body.getStartTag());
		        }
			}
	
        }else{
        	convStr = reader.create(path, encode);
        }
        
        if( !res.isCommitted() ){
			res.reset();
			//IE6Ń[JHTML̃NbL[ێȂۂւ̑Ή
	        initSessionTimeout(req, res);
		}
        
		//ContentTypeݒ
        res.setContentType("text/html; charset=" + encode);
//	    res.setCharacterEncoding(encode);
	    
	    //HTML̉͌ʂo
        PrintWriter writer = res.getWriter();
        writer.write(convStr);
        writer.flush();
        writer.close();
	}
	
	/**
	 * CAEg擾܂
	 * @param path NCAgvꂽNGXgURI
	 * @param req HttpServletRequestCX^X
	 * @return CN[h܂ރtH[hJSP
	 */
	protected String layout(String path, HttpServletRequest req) 
	throws IOException, ServletException{
		LayoutMappings mappings = LayoutMappings.getInstance();
		LayoutMapping include = (LayoutMapping) mappings.get(path);
		if (include == null) {
			//System.out.println("IncludeMapping is null.");
			return null;
		}

		String extendz = include.getExtendz();
		if (extendz != null) {
			//ẽCAEgvf܂
			checkParentLayout(include, req);
		}

		String layoutPath = include.getPath();
		HashMap putMap = include.getPuts();
		if (putMap != null) {

			//namepathHttpServletRequestɃZbg
			//ƂJSP̃^OCu<jsp:include page="${path}" />
			//Ăяo΂njI
			Set keySet = putMap.keySet();
			Iterator it = keySet.iterator();

			while (it.hasNext()) {
				String name = (String) it.next();
				LayoutPutMapping put = (LayoutPutMapping) putMap.get(name);
				setIncludeContents(put, name, req);
			}
		}

		return layoutPath;
	}

	/**
	 * ẽCAEg擾܂
	 * @param layout CAEg
	 * @param req HttpServletRequestCX^X
	 */
	protected void checkParentLayout(
		LayoutMapping layout,
		HttpServletRequest req) 
	throws IOException, ServletException{
		LayoutMappings mappings = LayoutMappings.getInstance();
		String parentName = layout.getExtendz();
		String extendz = layout.getExtendz();
		//Xɐe̗vfZbgĂȂ`FbN
		if (extendz != null) {
			LayoutMapping parent = (LayoutMapping) mappings.get(parentName);
			checkParentLayout(parent, req);
		}

		HashMap putMap = layout.getPuts();
		if (putMap == null) {
			return;
		}

		//CAEgpJSPɃCN[hJSPt@C擾A
		//HttpServletRequestCX^XɃZbg
		Set keySet = putMap.keySet();
		Iterator it = keySet.iterator();
		while (it.hasNext()) {
			String name = (String) it.next();

			LayoutPutMapping put = (LayoutPutMapping) putMap.get(name);
			setIncludeContents(put, name, req);
			
		}
	}
	
	/**
	 * CAEg񂩂畔Rec擾ANGXgp[^
	 * ɃZbg܂
	 * @param put CAEg
	 * @param attrName CAEg킷j[NȖO
	 * @param req HttpServletRequest
	 * @throws IOException
	 */
	protected void setIncludeContents(LayoutPutMapping put, 
	String attrName, HttpServletRequest req)
	throws IOException{
		String layoutName = put.getPath();
		
		//Rec񂪊i[ĂpX擾
		String contextPath = req.getServerName();
        int port = req.getServerPort();
        String layoutPath = context.getRealPath(layoutName);
        
        //Recp[X܂
        InitParamMap params = InitParamMap.getInstance();
        String encode = params.getParam("encoding");
	    if(encode == null){
	    	log.warn("No set inita param[encoding] default set[Shift_JIS]");
        	encode = "Shift_JIS";
        }
        HtmlRootTag layoutTag = new HtmlRootTag(encode);
        HtmlConfigReader layoutReader = new HtmlConfigReader();
        layoutReader.create(layoutPath, layoutTag);
        HtmlConverter converter = new HtmlConverter(context, req);
		String convStr = converter.convert(layoutTag);
		
//		req.setAttribute(Globals.REQ_PARAM_INCLUDE + attrName, convStr);
		TagInfo body = TagUtil.createTagInfo(convStr, TagInfo.BODY_NAME);
        if( body != null ){
            //BODY̏o
        	req.setAttribute(Globals.REQ_PARAM_INCLUDE + attrName, body.getDataInTag());
        }else{
            req.setAttribute(Globals.REQ_PARAM_INCLUDE + attrName, convStr);
        }
	}
	
	/**
	 * ZbV̍Đݒ
	 * @param req HttpServletRequestCX^X
	 * @param res HttpServletResponseCX^X
	 */
	private void initSessionTimeout(HttpServletRequest req, HttpServletResponse res){
		//IE6Ń[JHTML̃NbL[ێȂۂւ̑Ή
        HttpSession session = req.getSession();
        if( session.isNew()){
        	String sessionId = session.getId();
	        // NbL[̔z擾
	        Cookie cookies[] = req.getCookies();
	        
	        // ړĨNbL[i[ϐ
	        Cookie accesstimeCookie = null;
	         
	        // ꂼ̃NbL[ɑ΂ĖOmF
	        if(cookies != null) {
	            for(int i = 0; i < cookies.length; i++) {
	                // O "accesstime" ł邩`FbN
	                 if(cookies[i].getName().equals("JSESSIONID")) {
	                     // YNbL[擾
	                     accesstimeCookie = cookies[i];
	                 }
	             }
	         }
	        
	        //O"JSESSIONID"AlݎłNbL[쐬
	        Cookie cookie = new Cookie("JSESSIONID",sessionId);
	        
	        // NbL[̐ݒ
	        cookie.setMaxAge(7 * 24 * 60 * 60); //LԂ1TԂɐݒ
	        
	        // NbL[𔭍s
	        res.addCookie(cookie);
        }
	}
	
	/**
	 * Oo͂܂<BR
	 * Õ͔NXŃLb`ČďoƂ̃NXthrow
	 * ƂɂAÕg[XǐՂ鎖ł܂<BR>
	 * Õg[XJDK1.4œꂽException.getStackTrace()
	 * \bhgėOg[XĂ܂
	 * @param e ExceptionCX^X
	 * @return G[y[WɑJڂꍇtrueԂ܂
	 */
	protected void exception(
		HttpServletRequest req,
		HttpServletResponse res,
		String exceptionName1,
		String exceptionName2,
		Exception e){
		String msg = e.getMessage();
        if( msg == null ){
            msg =e.getClass().getName();
        }
        log.error(msg);
		StackTraceElement[] traceList = e.getStackTrace();
		for (int i = 0; i < traceList.length; i++) {
			StackTraceElement trace = traceList[i];
			log.error(trace.toString());
		}

	}
	
	/**
	 * Oo͂܂<BR
	 * Õ͔NXŃLb`ČďoƂ̃NXthrow
	 * ƂɂAÕg[XǐՂ鎖ł܂<BR>
	 * Õg[XJDK1.4œꂽException.getStackTrace()
	 * \bhgėOg[XĂ܂
	 * @param e ExceptionCX^X
	 * @return G[y[WɑJڂꍇtrueԂ܂
	 */
	protected void exception(
		HttpServletRequest req,
		HttpServletResponse res,
		String exceptionName1,
		String exceptionName2,
		Error e) {
		String msg = e.getMessage();
        if( msg == null ){
            msg =e.getClass().getName();
        }
        log.error(msg);
		StackTraceElement[] traceList = e.getStackTrace();
		for (int i = 0; i < traceList.length; i++) {
			StackTraceElement trace = traceList[i];
			log.error(trace.toString());
		}
	}
	
}
