package org.itscool.commons.util;

import java.util.List;

/**
 * HTML̃^O͗p[eBeBł
 * @author kanou
 */
public class TagUtil {
	public static final String SCOPE_PAGE="page";
    /**
     * NGXgXR[v
     * <code>SCOPE_REQUEST</code>
     */
    public static final String SCOPE_REQUEST="request";
    /**
     * ZbVXR[v
     * <code>SCOPE_SESSION</code>
     */
    public static final String SCOPE_SESSION="session";
    /**
     * ReLXgXR[v
     * <code>SCOPE_APPLICATION</code>
     */
    public static final String SCOPE_APPLICATION="application";
    
	/**
     * ^OɎw肳ꂽlBeanɃZbgꂽlł邩`FbN܂<br>
     * @param beanVal IuWFNgɃZbgĂvpeBl
     * @param value ^OɎw肳ꂽl
     * @return ^OɎw肳ꂽlBeanɃZbgꂽlꍇtrueԂ܂
     * 
    */
    public static boolean isCheckedValue(Object beanVal, String value){
        boolean ret = false;
        if( beanVal == null || value == null || value.length() == 0){
            return ret;
        }
//add 2006/03/07 Mr.sawamura start
        if ( beanVal instanceof List ) {
            List al = (List)beanVal;
            for (int i = 0; i < al.size(); i++) {
            	Object bv = al.get(i);
            	boolean b = isCheckedValue(bv, value);
                if (b) {
                     ret = true;
                     break;
                  }
              }
       }
//add 2006/03/07 Mr.sawamura end
       else if( beanVal instanceof Boolean ){
            Boolean chkVal = new Boolean(value);
        
            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
                ret = true;
            }
        }else if( beanVal instanceof String ){
            String chkVal = new String(value);
            
            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
                ret = true;
            }
        }else if( beanVal instanceof Integer ){
            Integer chkVal = new Integer(value);
            
            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
                ret = true;
            }
        }else if( beanVal instanceof Double ){
            Double chkVal = new Double(value);
            
            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
                ret = true;
            }
        }else if( beanVal instanceof Float ){
            Float chkVal = new Float(value);
            
            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
                ret = true;
            }
        }else if( beanVal instanceof Long ){
            Long chkVal = new Long(value);
            
            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
                ret = true;
            }
        }else{
            String chkVal = new String(value);
            
            if( beanVal != null && beanVal.toString().equals(chkVal.toString())){
                ret = true;
            }
        }
        return ret;
    }
    
    /**
     * HTMLLq`̕񂩂w肳ꂽ^O̕擾܂
     * 
     * @param html HTMLLq̕
     * @param tag ^Ow肵܂ibodyAheadAtitleȂǁj
     * @return TagInfoCX^XԂ܂
     *          HTMLLqsȏꍇNULLԂ܂
     */
    public static TagInfo createTagInfo(String html, String tag){
        int startIndex = html.indexOf("<"+ tag);
        int endIndex = html.indexOf("</" + tag + ">");
    
        if( startIndex == -1 || endIndex == -1){
            return null;
        }
    
        String body = html.substring(startIndex, endIndex + ("</" + tag + ">").length());
    
        int startBodyIndex = body.indexOf(">") + 1;
        int endBodyIndex = body.indexOf("</" + tag + ">");
    
        if( endBodyIndex == -1 ){
            return null;
        }
    
        String bodyIn = body.substring(startBodyIndex, endBodyIndex);

        TagInfo tagInfo = new TagInfo();
        tagInfo.setDataInTag(bodyIn);
        tagInfo.setStartTag(body.substring(0, startBodyIndex));
        tagInfo.setEndTag(body.substring(endBodyIndex, body.length()));
    
        return tagInfo;
    }
}
