package org.itscool.commons.util;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.request.GeneralForm;

/**
 * ^OCűʊ֐`NXłB
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 * @version 1.10A 2006/02/12 GeneralFormΉiThanks V) <br>
 * @version 1.10B 2006/03/07 w肳ꂽ^Oz̏ꍇ̑ΉǉiThanks V) <br>
*/
public class JspTagUtil extends TagUtil{
    
    /**
     * value擾܂B<BR>
     * value̒^ŕ\ꍇAw肳ꂽϐXR[v
     * ܂<BR>
     * <p>
     * value̒^F${IuWFNg.vpeB}<br>
     * <p>
     * ^ɊYȂꍇ́Avaluel̂܂ܕԂ܂<BR>
     * 
     * @param pageContext PageContextCX^Xw肵܂B
     * @param value value
     * @param scope BeañXR[vw肵܂B
     * @return valuěʂԂ܂
     */
    public static Object findValue(PageContext pageContext, String value, String scope)
    throws JspException{
        if( value == null ){
        	return ""; 
        }else if(value.length() < 3 ){
    		return value;
    	}
    	String topKey = value.substring(0,1);
    	String stKakko = value.substring(1,2);
    	String edKakko = value.substring(value.length()-1,value.length());
    	
    	if(!topKey.equals("$")){
    		return value;
    	}
    	StringTokenizer propertySt = new StringTokenizer(value, ".");
    	String name = propertySt.nextToken().trim();
    	name = name.substring(2, name.length());
    	String property = null;
        if(propertySt.hasMoreTokens()){
        	property = propertySt.nextToken().trim();
        	property = property.substring(0, property.length()-1);
        }else{
        	name = name.substring(0, name.length()-1);
        }
//        System.out.print("[" + name +"]");
//        System.out.println("["+property+"]");
        
        Object result = findProperty(pageContext, name, property, scope);
        if( result == null){
        	return "";
        }else{
        	return result;
        }
    }
    
    /**
     * PageContextCX^Xw肳ꂽBean擾܂B
     * @param pageContext PageContextCX^Xw肵܂B
     * @param name pageContextɃZbgꂽBean̖Ow肵܂B
     * @param scope BeañXR[vw肵܂B
     * @return IuWFNgԂ܂
    */
    public static Object findObject(PageContext pageContext, 
    String name, String scope){
        Object obj = lookup(pageContext, name, scope);
        
        return obj;
        
    }
    
    /**
     * PageContextCX^Xw肳ꂽBeañvpeB擾܂B
     * @param pageContext PageContextCX^Xw肵܂B
     * @param name pageContextɃZbgꂽBean̖Ow肵܂B
     * @param property pageContextɃZbgꂽBeañvpeBw肵܂B
     * @param scope BeañXR[vw肵܂B
     * @return vpeBԂ܂
     * @throws JspException
    */
    public static Object findProperty(PageContext pageContext, 
    String name, String property, String scope) throws JspException{
        Object pObj = null;       
        Object obj = null;
        
        if(name != null && name.length() != 0){
            obj = lookup(pageContext, name, scope);
        }
        
        if( obj != null && property != null){
//modify 2006.02.12 GeneralFormΉ start 
			if( obj instanceof GeneralForm ){
            	pObj = ((GeneralForm)obj).getParameter(property);
//add 2006.03.14 HashΉ start
			}else if(obj instanceof Map ){
				pObj = ((Map)obj).get(property);
			}else if(obj instanceof Hashtable ){
				pObj = ((Hashtable)obj).get(property);
//add 2006.03.14 HashΉ end
			}else{
				pObj = BeanUtil.getProperty(obj, property);
			}
//modify 2006.02.12 GeneralFormΉ end
        }else if( obj == null && property != null ){
            pObj = lookup(pageContext, property, scope);
        
        }else if( obj != null && property == null ){
        	pObj = obj;
        }
        
        if(pObj == null){
            pObj = new String("");
        }
        
        return pObj;
    }
    
    /**
     * ̏nameɎw肳ꂽIuWFNg̃XR[v܂<BR>
     * request, session, application̏
     * @param pageContext PageContextCX^Xw肵܂
     * @param name PageContextCX^XɃZbgĂBeanw肵܂
     * @return XR[vԂ܂
    */
    public static String findScope(PageContext pageContext, String name){
        Object obj = null;
        
        obj = pageContext.getAttribute(name);
        if( obj != null ){
            return SCOPE_PAGE;
        }
        
        obj = pageContext.getRequest().getAttribute(name);
        if( obj != null ){
            return SCOPE_REQUEST;
        }
        
        obj = pageContext.getSession().getAttribute(name);
        if( obj != null ){
            return SCOPE_SESSION;
        }
        
        obj = pageContext.getServletContext().getAttribute(name);
        if( obj != null){
            return SCOPE_APPLICATION;
        }
        
        return null;
        
    }
    
    /**
     * PageContextCX^Xw肳ꂽBean擾܂B<BR>
     * scopew肳ĂȂꍇ́ȀŃIuWFNg܂B<BR>
     * request, session, context̏
     * @param pageContext PageContextCX^Xw肵܂B
     * @param name pageContextɃZbgꂽBean̖Ow肵܂B
     * @param scope BeañXR[vw肵܂B
     * @return IuWFNgԂ܂
    */
    protected static Object lookup(PageContext pageContext, String name, String scope)
    {
        Object obj = null;
        
        if(scope == null){
            //scopew肳ĂȂꍇ͎̏ŃIuWFNg܂B
            // request, session, context
            obj = lookup(pageContext, name);
            
            return obj;
        }
        
        if( scope.equals(SCOPE_APPLICATION) ){
            obj = pageContext.getServletContext().getAttribute(name);
                                
        }else if( scope.equals(SCOPE_SESSION) ){
            obj = pageContext.getSession().getAttribute(name);
        
        }else if( scope.equals(SCOPE_REQUEST) ){
            obj = pageContext.getRequest().getAttribute(name);
            
        }else if( scope.equals(SCOPE_PAGE)){
            obj = pageContext.getAttribute(name);
        }
        
        return obj;
    }
    
    /**
     * ̏PageContextCX^Xw肳ꂽBean擾܂B<BR>
     * request, session, context̏
     * @param pageContext PageContextCX^Xw肵܂B
     * @param name pageContextɃZbgꂽBean̖Ow肵܂B
     * @return IuWFNgԂ܂
    */
    protected static Object lookup(PageContext pageContext, String name){
        Object obj = null;
        
        obj = pageContext.getAttribute(name);
        if( obj != null ){
            return obj;
        }
        
        obj = pageContext.getRequest().getAttribute(name);
        if( obj != null ){
            return obj;
        }
        
        obj = pageContext.getSession().getAttribute(name);
        if( obj != null ){
            return obj;
        }
        
        obj = pageContext.getServletContext().getAttribute(name);
        if( obj != null ){
            return obj;
        }
        
        obj = pageContext.getServletContext().getAttribute(name);
        if( obj != null ){
            return obj;
        }
        return obj;
        
    }
    
    /**
     * [ value="value" ]`̃^O쐬܂
     * @param pageContext PageContextCX^Xw肵܂
     * @param name   PageContextCX^XɕێĂIuWFNg̘_
     *             w肵܂
     * @param property IuWFNg̃vpeBw肵܂
     * @param scope IuWFNgPageContextCX^XɕێĂXR[v
     *              w肵܂B
     * @param value valueɎw肷lw肵܂<BR>
     *              valuenull̏ꍇ̓IuWFNgɃZbgĂlgp
     *              ܂
     * @return ^OԂ܂
    */
    public static String createAttribute(PageContext pageContext, 
    String name, String property, String scope, String key, String value ) throws JspException{
        StringBuffer inputTag = new StringBuffer();
        
        if( property == null || property.length() == 0 ){
            inputTag.append("");
            
        }else{
            Object result = JspTagUtil.findProperty(pageContext, name, property, scope);
            if( value != null && value.toString().length() > 0){
                
                //ELΉo[W
            	value = JspTagUtil.findValue(pageContext, value, scope).toString();
            	
            	//Valuew肳Ăꍇ
                //Valueo͂
                inputTag.append(" " + key + "=\"").append(value).append("\" ");
            }else if( result == null || result.toString().length() == 0 ){
                //BeanZbgĂȂꍇ́AvpeBṔinamej
                //ŒlZbgĂȂmFB
                //̓G[ł̃y[Wɖ߂ėꍇ͈ȉ̃vpeB
                //ZbgB
            	result = (String)pageContext.getRequest().getAttribute(property);
                if( result != null && result.toString().length() > 0 ){
                    inputTag.append(" "+ key + "=\"").append(result).append("\" ");
                
                //vpeBZbgĂȂꍇ̓ftHgij
                //o͂
                }else{
                    //inputTag.append(name).append("\" ");
                    inputTag.append("");
                    
                }
            }else{
                //BeanZbgĂꍇBeanɃZbgĂ
                //vpeBo͂
                
                inputTag.append(" " + key + "=\"").append(result).append("\" ");
            }
        }
        
        return inputTag.toString();
    }
    
    /**
     * [ ${tagName}="${tagValue}" ]`̃^O쐬܂
     * @param tagName w肵܂
     * @param tagValue ɃZbglw肵܂
     * @return ^OԂ܂
    */
    public static String createAttribute(String tagName, String tagValue){
        StringBuffer inputTag = new StringBuffer(" ").append(tagName);
        inputTag.append("=\"");
        inputTag.append(tagValue).append("\" ");
        
        if( tagName == null || tagName.length() == 0 || 
        tagValue == null || tagValue.length() == 0){
        	return "";
        }else{
        	return inputTag.toString();
        }
    }
    
	/**
	 * [ ${tagName}="${tagValue(true/false)}" ]`̃^O쐬܂
	 * @param tagName w肵܂
	 * @param tagValue ɃZbglw肵܂
	 * @return ^OԂ܂
	*/
	public static String createBoolAttribute(String tagName, String tagValue){
		StringBuffer inputTag = new StringBuffer(" ").append(tagName);
		
		if( tagName == null || tagName.length() == 0 || tagValue == null ){
			return "";
		}else if(tagValue.toLowerCase().equals("true") ){
			inputTag.append(createAttribute(tagName, "true"));
			return inputTag.toString();
		}else{
			inputTag.append(createAttribute(tagName, "false"));
			return inputTag.toString();
		}
	}
    
    
    
    /**
     * vpeBIuWFNg̃vpeB擾AʂNG[ŕԂ܂B
     * <BR>
     * vpeBXgɂ͈ȉ̏łKv܂B
     * <P>
     * IuWFNg:IuWFNg擾̃vpeBiȗ\):gslkɏo͂Ƃ̃vpeBiȗ\),
     * IuWFNg2:vpeB2,gslkɏo͂Ƃ̃vpeB2iȗ\),(ȍ~p[^JԂ)
     * 
     * <p>
     *  vpeBȗꍇ̓IuWFNgŎ擾IuWFNgtoString()Ԃ܂
     * @param pageContext PageContextCX^X
     * @param properties vpeBXg
     * @param scope XR[v
     * @return NG[Ԃ܂
     * @throws JspException
     */
    public static String createQueryString(PageContext pageContext, 
    		String properties, String scope) throws JspException{
        if(properties==null || properties.length() == 0){
            return "";
        }
        StringTokenizer dataSt = new StringTokenizer(properties, ",");
        StringBuffer sb = new StringBuffer("");
        if(dataSt.hasMoreTokens()){
            sb.append("?");
        }
        while (dataSt.hasMoreTokens()) {
        	String data = dataSt.nextToken().trim();
        	StringTokenizer propertySt = new StringTokenizer(data, ":");
        	//IuWFNg̎擾
        	String name = propertySt.nextToken();
        	if( name==null){
        		throw new RuntimeException("name is null query="+properties);
        	}else{
        		name = name.trim();
        	}
        	//vpeB̎擾
        	String property = null;
            if( propertySt.hasMoreTokens() ){
            	property = propertySt.nextToken();
            }
            //HTMLɏo͂vpeB̎擾
            String htmlName = null;
            if( propertySt.hasMoreTokens() ){
            	htmlName = propertySt.nextToken().trim();
            }
            Object value = null;
            if( property == null ){
            	value = findObject(pageContext, name, scope);
            }else{
            	property = property.trim();
            	value = findProperty(pageContext, name, property, scope);
            }
            if( htmlName != null ){
            	sb.append(htmlName).append("=");
            }else if( property == null ){
            	sb.append(name).append("=");
            }else{
            	sb.append(property).append("=");
            }
            if( value != null){
            	sb.append(value.toString());
            }
            if(dataSt.hasMoreTokens()){
                sb.append("&");
            }
            //println(st.nextToken());
        }
        return sb.toString();
    }
    
    public static String createRealPath(PageContext pageContext, String path){
    	if( path == null){
    		path = "/";
    	}else if( path.indexOf("/") != 0 ){
			path += "/";
		}
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        String realPath = req.getContextPath();
        return realPath + path;
    }
    
}
