package org.itscool.commons.bean;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;

/**
 * Beant@NgNX<br/>
 * Bean`t@CɎw肳ꂽJavaBeans𐶐܂B<p/>
 * 
 * Bean`t@C̋Lq<hr>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS" ?&gt;
 * &lt;di-config&gt;
 *     &lt;bean-mappings&gt;
 *         &lt;bean id="sample" type="SampleBeanImpl"&gt;
 *             &lt;property name="id" value="1"/&gt;
 *             &lt;property name="name" value="ios taro"/&gt;
 *             &lt;property name="age" value="32"/&gt;
 *             &lt;property name="child" ref="child"/&gt;	
 *         &lt;/bean&gt;
 *         &lt;bean&gt;
 *             &lt;bean id="child" type="SampleChild"&gt;
 *             &lt;property name="name" value="ios Jr"/&gt;
 *         &lt;/bean&gt;
 *         &lt;bean id="params" type="org.itscool.commons.bean.InitParamMap" singleton="true"&gt;
 *         &lt;property name="infos" collection="map"&gt;
 *             &lt;bean id="encoding" type="java.lang.String" value="Shift_JIS"/&gt;
 *             &lt;bean id="weber-config" value="weber-config.xml"/&gt;
 *             &lt;bean id="stylist-config" value="stylist-config.xml"/&gt;
 *             &lt;bean id="message-config" value="message-config.xml"/&gt;
 *         &lt;/property&gt;
 *         &lt;/bean&gt;
 *     &lt;/bean-mappings&gt;
 * &lt;/di-config&gt;
 * </pre>
 * 
 * <p>
 * ^O̐<hr><br/>
 * &lt;di-config&gt; FK{ڂłiBean`t@C1`)<br/>
 * &lt;bean-mappings&gt;FK{ڂłiBean`t@C1`j<br/>
 * &lt;bean&gt;JavaBeans`܂<br/>
 * &lt;bean&gt;^O͍XɈȉ̑w肵܂<br/>
 * @idFJavaBeans̘_<BR>
 * @typeFJavaBeanś̕ipbP[W܂߂NXj<br/>
 * @singletonFVOgNX̏ꍇtruew肵Ă<br/>
 *@<br>
 *@ VOgNX̏ꍇAVOgNXɈȉɎgetInstance\bh
 *@̋LqKvłB<br/>
 *@Stylist̓IuWFNĝ̃\bhgăIuWFNg𐶐܂<br/>
 *<div id="area">
 *<pre>
 * public class InitParamMap{
 *    private static InitParamMap instance;
 *     
 *     public static synchronized InitParamMap getInstance(){
 *         if( instance == null ){
 *             instance = new InitParamMap();
 *         }
 *         return instance;
 *     }
 * }
 * </pre>
 * </div>
 * </p>
 * <p>
 * &lt;property&gt;FJavaBeans̃vpeB`܂<br/>
 * &lt;property&gt;^O͍XɈȉ̑w肵܂<br/>
 * @nameF̖OiJavaBeansł͂̑ɑΉANZbT\bhKvłj<br/>
 * @valueFvpeB̏l<br/>
 * @refFvaluȇrefw肷邱Ƃł܂B<br/>
 * @ref́ABean`t@Cɒ`ꂽʂJavaBeans_̂Ŏw肷邱Ƃł܂B<br/>
 * 
 * 
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2005/08/20
 */
public class BeanFactory {
	private static BeanFactory instance = new BeanFactory();
	private HashMap beanMap = new HashMap();
	private BeanConfigReader reader = new BeanConfigReader();
	private boolean initFlg = false;
	private AbstractLog log = SimpleLog.getInstance();
	
	public boolean isInit(){
		return initFlg;
	}
	
	/**
	 * BeanFactoryCX^X擾܂
	 * @return BeanFactoryCX^X
	 */
	public static BeanFactory getInstance(){
		return instance;
	}
	
	/**
	 * Bean`t@C[h܂
	 * @param configName Bean`t@C̃pX
	 * @throws IOException
	 */
	public void createForUrl(String configName) throws IOException{
		ClassLoader parent = Thread.currentThread().getContextClassLoader(); 
		URL diconfigUrl = parent.getResource(configName);
		try{
        	if( diconfigUrl == null ){
        		throw new IOException(configName+"ւ̃pX܂");
        	}
        	String configFwName = diconfigUrl.getPath();
    	   	create(configFwName);
        }catch(Exception ex){
        	log.error(ex.getMessage());
           	throw new IOException(ex.getMessage());
        }  	
	}
	
	/**
	 * Bean`t@C[h܂
	 * @param pathList Bean`t@C̃pXXg
	 * @throws IOException
	 */
	public void create(String[] pathList) throws IOException{
		String path = new String("");
		try{
			for(int i=0; i<pathList.length; i++ ){
				path = pathList[i];
				reader.create(path, beanMap);
			}
		}catch( IOException ioe ){
			log.error(ioe.getMessage());
			throw new IOException(ioe.getMessage() + "[" + path + "]");
		}
	}
	
	/**
	 * Bean`t@C[h܂
	 * @param path Bean`t@C̃pX
	 * @throws IOException
	 */
	public void create(String path) throws IOException{
		reader.create(path, beanMap);
		initFlg = true;
		log.info("completed initialize config='" + path + "'");
	}
	
	/**
	 * w肳ꂽBean_ɕRÂVOgCX^X擾܂
	 * @param id Bean`t@CɊ֘ABean_
	 * @return Bean_ɕRÂCX^X擾܂
	 */
	public Object getInstance(String id){
		BeanInfoMapping beanInfo = (BeanInfoMapping)beanMap.get(id);
		Object obj = null;
		
		if( beanInfo == null ){
			String msg = getClass().getName() + " not found[" + id + "]";
			//log.error(msg);
			throw new BeanFactoryRuntimeException(msg);
		}
		if( beanInfo.getSingleton() ){
			//SingletonCX^X𐶐
			obj = BeanUtil.getInstance(beanInfo.getType());
		}
        return obj;
	}
	
	/**
	 * w肳ꂽBean_ɕRÂCX^X𐶐܂
	 * @param id Bean`t@CɊ֘ABean_
	 * @return Bean_ɕRÂCX^X擾܂
	 */
	public Object createInstance(String id){
		BeanInfoMapping beanInfo = (BeanInfoMapping)beanMap.get(id);
		Object obj = null;
		
		if( beanInfo == null ){
			String msg = getClass().getName() + " not found[" + id + "]";
			//log.error(msg);
			throw new BeanFactoryRuntimeException(msg);
		}
		obj = createInstance(beanInfo);
        return obj;
	}
	
	/**
	 * w肳ꂽBean_ɕRÂCX^X𐶐܂
	 * @param id Bean`t@CɊ֘ABean_
	 * @return Bean_ɕRÂCX^X擾܂
	 */
	public Object createInstance(BeanInfoMapping beanInfo){
		Object obj = null;
		
		//VOg̎w肪ꍇ
		if( beanInfo.getSingleton() ){
			//SingletonCX^X𐶐
			obj = BeanUtil.getInstance(beanInfo.getType());

//add 2005/01/18 start
		//RXgN^String^̈1ꍇ
		}else if( beanInfo.getValue() != null ){
			String[] argTypes = new String[1];
			String[] argValues = new String[1];
			argTypes[0] = String.class.getName();
			argValues[0] = beanInfo.getValue();
			
			obj = BeanUtil.createInstance(beanInfo.getType(), argTypes, argValues);
//add 2005/01/18 end
			
		}else{
			obj = BeanUtil.createInstance(beanInfo.getType());
		}
        
		//ꂽCX^XɏlZbg܂
        HashMap pMap = beanInfo.getProperties();
        if( pMap == null ){
        	return obj;
        }
        Set pKeySet = pMap.keySet();
        Iterator pIt = pKeySet.iterator();
        while(pIt.hasNext()){
        	String pKey = (String)pIt.next();
            BeanPropertyInfo propertyInfo = (BeanPropertyInfo)pMap.get(pKey);
            String ref = propertyInfo.getRef();
            String collection = propertyInfo.getCollection();
            
            //Collection^̃IuWFNgݒ肷ꍇ
            if( collection != null ){
            	Object colObj = createCollection(propertyInfo);
            	BeanUtil.setProperty(obj, propertyInfo.getName(), colObj);
            
            //̃IuWFNgݒ肷ꍇ
            }else if(ref != null){
            	Object refObj = this.createInstance(ref);
            	BeanUtil.setProperty(obj, propertyInfo.getName(), refObj);
            
            //w肳ꂽlŐݒ肷ꍇ
            }else if(propertyInfo.getValue() != null ){
            	BeanUtil.setProperty(obj, propertyInfo.getName(), propertyInfo.getValue());
            
            //ݒG[
            }else{
            	String msg = getClass().getName() + " not found property[" + pKey + "]";
				log.warn(msg);
            }
        }
        log.debug(beanInfo.getType() + " is created instance.");
        return obj;
	}
	
//add 2006/01/18 start
	/**
	 * RNVCX^X𐶐܂
	 * @param propertyInfo Bean`
	 * @return RNVCX^XԂ܂
	 */
	protected Object createCollection(BeanPropertyInfo propertyInfo){
		Map attrList = propertyInfo.getAttrList();
    	Set set = attrList.keySet();
    	Iterator it = set.iterator();
    	String collection = propertyInfo.getCollection();
    	
    	//Map^RNV̏ꍇ
    	if( collection.equals("map")){
    		HashMap map = new HashMap();
    		
    		while(it.hasNext()){
    			Object key = it.next();
    			BeanInfoMapping childBeanInfo  = (BeanInfoMapping)attrList.get(key);
    			Object chldObj = createInstance(childBeanInfo);
    			map.put(childBeanInfo.getId(), chldObj);
    		}
    		
    		return map;
    	//List^RNV̏ꍇ
    	}else if( collection.equals("list")){
    		ArrayList lst = new ArrayList();
    		
    		while(it.hasNext()){
    			Object key = it.next();
    			BeanInfoMapping childBeanInfo  = (BeanInfoMapping)attrList.get(key);
    			Object chldObj = createInstance(childBeanInfo);
    			lst.add(chldObj);
    		}
    		
    		return lst;
    	}else{
			String msg = getClass().getName() + " not found collection kind.[" + collection + "]";
			log.warn(msg);
    		return null;
    	}
	}
//add 2006/01/18 end
}
