package test.org.itscool.webersample.dao;

import org.itscool.commons.connection.TransactionUtil;
import org.itscool.weber.testcase.WeberDbTestCase;
import org.itscool.weber.user.User;
import org.itscool.weber.user.UserDao;
import org.itscool.webersample.bean.GoStatus;
import org.itscool.webersample.bean.OfficeWorker;
import org.itscool.webersample.bean.OfficialTitle;
import org.itscool.webersample.bean.Post;
import org.itscool.webersample.dao.OfficeWorkerDao;
import org.itscool.webersample.dao.OfficialTitleDao;
import org.itscool.webersample.dao.PostDao;

/**
 * 쐬: 2005/06/28
 * @author kanoum
 */
public class TestOfficeWorker extends WeberDbTestCase{
    
    public void setUp(){
        this.initTables("test-db-data.xml");
	}
    

    public void testSave(){
    	UserDao userDao = new UserDao();
    	User user = userDao.getUser(1);
    	
        PostDao postDao = new PostDao();
        Post post = postDao.getPost(1);
        
        OfficialTitleDao titleDao = new OfficialTitleDao();
        OfficialTitle title = titleDao.getOfficialTitle(1);
        
        try{
            
            OfficeWorkerDao workerDao = new OfficeWorkerDao();
            OfficeWorker worker = new OfficeWorker();
            worker.setWorkerId("1111");
            worker.setFirstName("ACIX");
            worker.setFirstName_kana("ACIX");
            worker.setSecondName("Y");
            worker.setSecondName_kana("^E");
            worker.setAddr("{c");
            worker.setMailAddr("taro@ios-net.co.jp");
            worker.setPassword("taro");
            worker.setTel("123-456");
            worker.setTitleId(title.getId());
            worker.setPostId(post.getId());
            worker.setUser(user);
            worker.setUserId(user.getId());
            
            workerDao.save(worker);
            
            TransactionUtil.commitTransaction();
        }catch(Exception e){
        	TransactionUtil.rollbackTransaction();
            fail(e.getMessage());
        }
    }
    
    public void testSaveFail(){
        try{
            OfficeWorkerDao workerDao = new OfficeWorkerDao();
            OfficeWorker worker = new OfficeWorker();
            worker.setWorkerId("1234");
            worker.setFirstName("ACIX");
            worker.setFirstName_kana("ACIX");
            worker.setSecondName("Y");
            worker.setSecondName_kana("^E");
            worker.setAddr("{c");
            worker.setMailAddr("taro@ios-net.co.jp");
            worker.setPassword("taro");
            worker.setTel("123-456");
//            worker.setTitleId(title.getId());
//            worker.setPostId(post.getId());
            
            GoStatus status = new GoStatus();
            status.setWorkerId(worker.getId());
            status.setEtc("---");
            status.setStatus("---");
            
            //workerDao.addNew(worker, status);
            workerDao.save(worker);
            TransactionUtil.commitTransaction();
            fail("BĂ͂ȂȂR[h");
            
        }catch(Exception e){
        	TransactionUtil.rollbackTransaction();
            
        }
    }
    
}

